/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field;

import com.informix.timeseries.field.AbstractTimeSeriesField;
import com.informix.timeseries.field.TimeSeriesField;
import com.informix.timeseries.field.TimeSeriesFieldFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.VarcharTimeSeriesFieldDefinition;

public class VarcharTimeSeriesField
extends AbstractTimeSeriesField<String>
implements TimeSeriesField<String> {
    public VarcharTimeSeriesField(String fieldName) {
        this(fieldName, new VarcharTimeSeriesFieldDefinition());
    }

    public VarcharTimeSeriesField(String fieldName, int length) {
        this(fieldName, new VarcharTimeSeriesFieldDefinition(length));
    }

    protected VarcharTimeSeriesField(String fieldName, TimeSeriesFieldDefinition<String> fieldDefinition) {
        super(fieldName, fieldDefinition);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VarcharTimeSeriesField [fieldName=");
        builder.append(this.fieldName);
        builder.append(", definition=");
        builder.append(this.definition);
        builder.append(']');
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldFactory<String> {
        @Override
        public TimeSeriesField<String> parse(String s) {
            String trimmed = s.trim();
            int index = trimmed.indexOf(32);
            String fieldName = trimmed.substring(0, index);
            String fieldDefArg = trimmed.substring(index + 1);
            return new VarcharTimeSeriesField(fieldName, VarcharTimeSeriesFieldDefinition.parseFieldDefinition(fieldDefArg));
        }
    }
}

