/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;

public final class JdbcUtilities {
    private static final char[] dbRestrictedChars = new char[]{'/', '\\', '.', ' ', '\"', '\'', '*', '<', '>', ':', '|', '?'};

    private JdbcUtilities() {
    }

    public static final void closeWithoutException(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void closeWithoutException(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void closeWithoutException(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final IllegalArgumentException validateInformixIdentifier(String identifier) {
        if (identifier == null) {
            return new IllegalArgumentException("identifier must not be null");
        }
        if (identifier.length() == 0) {
            return new IllegalArgumentException("identifier must not be empty");
        }
        IllegalArgumentException exception = null;
        int i = 0;
        while (i < dbRestrictedChars.length && exception == null) {
            char restrictedCharacter = dbRestrictedChars[i];
            int index = identifier.indexOf(restrictedCharacter);
            if (index != -1) {
                String message = MessageFormat.format("identifier ''{0}'' must not contain the ''{1}'' character (at position {2})", identifier, Character.valueOf(dbRestrictedChars[i]), index);
                exception = new IllegalArgumentException(message);
            }
            ++i;
        }
        return exception;
    }
}

