/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries;

public enum IfxDateTimeCode {
    YEAR("year", 0),
    MONTH("month", 2),
    DAY("day", 4),
    HOUR("hour", 6),
    MINUTE("minute", 8),
    SECOND("second", 10),
    FRACTION_1("fraction(1)", 11),
    FRACTION("fraction", 12),
    FRACTION_2("fraction(2)", 12),
    FRACTION_3("fraction(3)", 13),
    FRACTION_4("fraction(4)", 14),
    FRACTION_5("fraction(5)", 15);

    private final String fieldName;
    private final byte fieldId;

    private IfxDateTimeCode(String fieldName, byte fieldId) {
        this.fieldName = fieldName;
        this.fieldId = fieldId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldName(boolean isStartCode) {
        if (isStartCode && this.fieldId >= IfxDateTimeCode.FRACTION_1.fieldId) {
            return "fraction";
        }
        return this.fieldName;
    }

    public byte fieldId() {
        return this.fieldId;
    }

    public int compareFieldIdTo(IfxDateTimeCode other) {
        return this.fieldId() - other.fieldId();
    }

    public static IfxDateTimeCode findByFieldName(String fieldName) {
        IfxDateTimeCode[] ifxDateTimeCodeArray = IfxDateTimeCode.values();
        int n = ifxDateTimeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IfxDateTimeCode code = ifxDateTimeCodeArray[n2];
            if (code.fieldName.equalsIgnoreCase(fieldName)) {
                return code;
            }
            ++n2;
        }
        return null;
    }

    public static IfxDateTimeCode findByFieldId(byte fieldId) {
        IfxDateTimeCode[] ifxDateTimeCodeArray = IfxDateTimeCode.values();
        int n = ifxDateTimeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IfxDateTimeCode code = ifxDateTimeCodeArray[n2];
            if (code.fieldId == fieldId) {
                return code;
            }
            ++n2;
        }
        return null;
    }

    public static String getQualiferName(IfxDateTimeCode startCode, IfxDateTimeCode endCode, boolean isInterval) {
        short qualifier = IfxDateTimeCode.getQualifier(startCode, endCode);
        if (qualifier == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(startCode.getFieldName(true));
        if (isInterval && startCode.compareFieldIdTo(SECOND) <= 0) {
            byte length = IfxDateTimeCode.getLength(qualifier);
            int leadingFieldPrecision = length - endCode.fieldId() + startCode.fieldId();
            sb.append('(');
            sb.append(leadingFieldPrecision);
            sb.append(')');
        }
        sb.append(" to ");
        sb.append(endCode.getFieldName(false));
        return sb.toString();
    }

    static String getQualifierName(short qual, int ifxType) {
        if (qual == 0) {
            return null;
        }
        byte startCode = IfxDateTimeCode.getStartCode(qual);
        byte endCode = IfxDateTimeCode.getEndCode(qual);
        byte length = IfxDateTimeCode.getLength(qual);
        String s = IfxDateTimeCode.getFieldName(startCode, true);
        if (ifxType == 14 && startCode <= IfxDateTimeCode.SECOND.fieldId) {
            int leadingFieldPrecision = length - endCode + startCode;
            s = String.valueOf(s) + "(" + leadingFieldPrecision + ")";
        }
        s = String.valueOf(s) + " to ";
        s = String.valueOf(s) + IfxDateTimeCode.getFieldName(endCode, false);
        return s;
    }

    public static byte getStartCode(short qualifier) {
        byte startCode = (byte)(qualifier >> 4 & 0xF);
        return startCode;
    }

    public static byte getEndCode(short qualifier) {
        byte endCode = (byte)(qualifier & 0xF);
        return endCode;
    }

    static byte getLength(short qual) {
        byte length = (byte)(qual >> 8);
        return length;
    }

    public static short getQualifier(IfxDateTimeCode startCode, IfxDateTimeCode endCode) {
        return IfxDateTimeCode.getQualifier(startCode.fieldId, endCode.fieldId);
    }

    public static short getQualifier(byte startCode, byte endCode) {
        short length = (short)(endCode - startCode + (startCode == IfxDateTimeCode.YEAR.fieldId ? 4 : 2));
        short qual = (short)((byte)length << 8 | startCode << 4 | endCode);
        return qual;
    }

    static String getFieldName(byte code, boolean isStartCode) {
        if (isStartCode && code >= IfxDateTimeCode.FRACTION_1.fieldId) {
            return "fraction";
        }
        switch (code) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }
}

