/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.net.ssl.SSLContext;
import javax.sql.XAConnection;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.jdbc.UCPConnectionBuilderImpl;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.util.OpaqueString;

public abstract class UCPXAConnectionBuilderImpl
implements UCPXAConnectionBuilder {
    private String user;
    private OpaqueString password;
    protected Properties labels = null;
    private String serviceName;
    protected int proxyType = -1;
    protected Properties proxyProperties;
    protected boolean isBuilt = false;
    protected OracleShardingKey shardingKey = null;
    protected OracleShardingKey superShardingKey = null;
    private Properties pdbRoles;
    private SSLContext sslContext;
    private PoolDataSource.HostnameResolver hostnameResolver;
    private boolean readOnlyInstanceAllowed;
    protected Executor executor = ForkJoinPool.commonPool();

    public UCPXAConnectionBuilderImpl(PoolXADataSourceImpl pds) {
        this.user = pds.getUser();
        this.password = pds.getPasswordInternal();
        this.serviceName = pds.getServiceName();
        this.pdbRoles = pds.getPdbRoles();
        this.sslContext = pds.getSSLContext();
        this.hostnameResolver = pds.getHostnameResolver();
        this.readOnlyInstanceAllowed = pds.isReadOnlyInstanceAllowed();
    }

    @Override
    public UCPXAConnectionBuilder user(String user) {
        this.user = user;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder password(@Blind String password) {
        this.password = OpaqueString.newOpaqueString(password);
        return this;
    }

    UCPXAConnectionBuilder internalPassword(OpaqueString password) {
        this.password = password;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder labels(Properties labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder proxyProperties(int proxyType, Properties proxyProperties) {
        this.proxyType = proxyType;
        this.proxyProperties = proxyProperties;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder shardingKey(OracleShardingKey shardingKey) {
        this.shardingKey = shardingKey;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder superShardingKey(OracleShardingKey superShardingKey) {
        if (superShardingKey != null) {
            ((OracleShardingKeyImpl)superShardingKey).markSuperShardingKey(true);
        }
        this.superShardingKey = superShardingKey;
        return this;
    }

    @Override
    public UCPXAConnectionBuilder pdbRoles(Properties pdbRoles) {
        this.pdbRoles = pdbRoles;
        return this;
    }

    UCPXAConnectionBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    UCPXAConnectionBuilder hostnameResolver(PoolDataSource.HostnameResolver hostnameResolver) {
        this.hostnameResolver = hostnameResolver;
        return this;
    }

    UCPXAConnectionBuilder readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.readOnlyInstanceAllowed = readOnlyInstanceAllowed;
        return this;
    }

    UCPXAConnectionBuilder copyFrom(UCPConnectionBuilderImpl ucpConnBldr) {
        this.user(ucpConnBldr.getUser()).password(ucpConnBldr.getPassword().get()).labels(ucpConnBldr.labels).proxyProperties(ucpConnBldr.proxyType, ucpConnBldr.proxyProperties).serviceName(ucpConnBldr.getServiceName()).shardingKey(ucpConnBldr.shardingKey).superShardingKey(ucpConnBldr.superShardingKey).pdbRoles(ucpConnBldr.getPdbRoles());
        return this;
    }

    @Override
    public abstract XAConnection build() throws SQLException;

    public String getUser() {
        return this.user;
    }

    OpaqueString getPassword() {
        return this.password;
    }

    String getServiceName() {
        return this.serviceName;
    }

    Properties getPdbRoles() {
        return this.pdbRoles;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    PoolDataSource.HostnameResolver getHostnameResolver() {
        return this.hostnameResolver;
    }

    boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed;
    }

    @Override
    public UCPXAConnectionBuilder executor(Executor executor) {
        if (Objects.isNull(executor)) {
            throw new IllegalArgumentException("executor should not be null");
        }
        this.executor = executor;
        return this;
    }
}

