/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.UCPConnectionBuilder;
import oracle.ucp.jdbc.UCPConnectionBuilderImpl;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.jdbc.UCPXAConnectionBuilderImpl;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.UCPErrorHandler;

public class JDBCConnectionRetrievalInfo
implements ConnectionRetrievalInfo {
    static final String CLASS_NAME = JDBCConnectionRetrievalInfo.class.getName();
    private final String user;
    private final OpaqueString password;
    private final int hashcode;
    private final Labels labels = new Labels();
    private final int proxyType;
    private final Properties proxyProperties;
    private final String serviceName;
    private final String userRequestedServiceName;
    private OracleShardingKey shardingKey;
    private OracleShardingKey superShardingKey;
    private OracleShardingKey lookupShardingKey;
    private SSLContext sslContext;
    private PoolDataSource.HostnameResolver hostnameResolver;
    private boolean readOnlyInstanceAllowed;
    private Properties pdbRoles;

    @Deprecated
    public JDBCConnectionRetrievalInfo(String user, String password) {
        this(user, OpaqueString.newOpaqueString(password), null);
    }

    @Deprecated
    public JDBCConnectionRetrievalInfo(String user, String password, Properties labels) {
        this(user, OpaqueString.newOpaqueString(password), labels);
    }

    public JDBCConnectionRetrievalInfo(String user, OpaqueString password) {
        this(user, password, null);
    }

    public JDBCConnectionRetrievalInfo(String user, OpaqueString password, Properties labels) {
        this.user = user;
        this.password = password;
        if (labels != null) {
            this.labels.putAllLabels(labels);
        }
        String tuser = user == null ? "" : user;
        this.hashcode = tuser.hashCode();
        this.serviceName = null;
        this.userRequestedServiceName = null;
        this.proxyType = -1;
        this.proxyProperties = null;
    }

    JDBCConnectionRetrievalInfo(UCPConnectionBuilder connBldr) {
        this(JDBCConnectionRetrievalInfo.createBuilder(connBldr));
    }

    JDBCConnectionRetrievalInfo(UCPXAConnectionBuilder xaConnBldr) {
        this(JDBCConnectionRetrievalInfo.createBuilder(xaConnBldr));
    }

    public JDBCConnectionRetrievalInfo(JDBCConnectionRetrievalInfo copyCri) {
        this(copyCri.copyBuilder());
    }

    @Override
    public boolean equals(Object obj) {
        String ouser;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo other = (JDBCConnectionRetrievalInfo)obj;
        String luser = this.user == null ? "" : this.user;
        boolean isEqual = luser.equals(ouser = other.user == null ? "" : other.user);
        if (isEqual) {
            isEqual = this.serviceName == null && other.serviceName == null ? true : (this.serviceName != null && other.serviceName != null ? this.serviceName.equals(other.serviceName) : false);
        }
        return isEqual;
    }

    @Override
    public boolean equalsIncludingPassword(ConnectionRetrievalInfo cri) {
        Objects.requireNonNull(cri);
        Objects.requireNonNull(this.password);
        return this.equals(cri) && this.password.equals(((JDBCConnectionRetrievalInfo)cri).password);
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    public String getUser() {
        return this.user;
    }

    public OpaqueString getPassword() {
        return this.password;
    }

    @Override
    public void addLabel(String key, String value) throws UniversalConnectionPoolException {
        if (key == null || key.equals("")) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(201);
        }
        String val = value == null ? "" : value;
        this.labels.addLabel(key, val);
    }

    @Override
    public void removeLabel(String key) throws UniversalConnectionPoolException {
        if (key == null || key.equals("")) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(201);
        }
        this.labels.removeLabel(key);
    }

    @Override
    public JDBCConnectionRetrievalInfo getCopyWithNoLabels() {
        return this.copyBuilder().labels(null).build();
    }

    public JDBCConnectionRetrievalInfo getCopyWithNewProxyProperties(int type, Properties newProxyProps) {
        return this.copyBuilder().proxyProperties(type, newProxyProps).build();
    }

    public JDBCConnectionRetrievalInfo getCopyWithService(String newService) {
        return this.copyBuilder().serviceName(newService).build();
    }

    public JDBCConnectionRetrievalInfo getCopyWithSSLContext(SSLContext newSSLContext) {
        return this.copyBuilder().sslContext(newSSLContext).build();
    }

    public JDBCConnectionRetrievalInfo getCopyWithUserRequestedService(String newService) {
        return this.copyBuilder().userRequestedServiceName(newService).build();
    }

    public JDBCConnectionRetrievalInfo getCopyWithPassword(OpaqueString newPassword) {
        return this.copyBuilder().password(newPassword).build();
    }

    public JDBCConnectionRetrievalInfo getCopyWithUser(String newUser) {
        return this.copyBuilder().user(newUser).build();
    }

    @Override
    public Properties getLabels() {
        if (this.labels.isEmpty()) {
            return null;
        }
        return this.labels;
    }

    public Properties getProxyProperties() {
        if (this.proxyProperties == null) {
            return null;
        }
        Properties proxyProps = new Properties();
        proxyProps.putAll((Map<?, ?>)this.proxyProperties);
        return proxyProps;
    }

    public int getProxyType() {
        return this.proxyType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUserRequestedServiceName() {
        return this.userRequestedServiceName;
    }

    public OracleShardingKey getShardingKey() {
        return this.shardingKey;
    }

    public OracleShardingKey getSuperShardingKey() {
        return this.superShardingKey;
    }

    public Properties getPdbRoles() {
        return this.pdbRoles;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public PoolDataSource.HostnameResolver getHostnameResolver() {
        return this.hostnameResolver;
    }

    public boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed;
    }

    public void setLookupShardingKey(OracleShardingKey lookupKey) {
        this.lookupShardingKey = lookupKey;
    }

    public OracleShardingKey getLookupShardingKey() {
        return this.lookupShardingKey;
    }

    public String toString() {
        return "user=" + this.user + ", password=********" + ", labels=" + this.labels + (this.proxyType != -1 ? ", Proxy Type =" + this.proxyType : "") + (this.proxyProperties != null ? ", Proxy Properties =" + this.proxyProperties : "") + (this.serviceName != null ? ", Service Name =" + this.serviceName : "") + (this.shardingKey != null ? ", Sharding Key =" + this.shardingKey : "") + (this.superShardingKey != null ? ", Super Sharding Key =" + this.superShardingKey : "") + (this.pdbRoles != null ? ", PDB Roles =" + this.pdbRoles : "");
    }

    public String stringValue() {
        return "user=" + this.user + ", password=" + this.password + ", labels=" + this.labels + (this.proxyType != -1 ? ", Proxy Type =" + this.proxyType : "") + (this.proxyProperties != null ? ", Proxy Properties =" + this.proxyProperties : "") + (this.serviceName != null ? ", Service Name =" + this.serviceName : "") + (this.shardingKey != null ? ", Sharding Key =" + this.shardingKey : "") + (this.superShardingKey != null ? ", Super Sharding Key =" + this.superShardingKey : "") + (this.pdbRoles != null ? ", PDB Roles =" + this.pdbRoles : "");
    }

    private JDBCConnectionRetrievalInfo(Builder builder) {
        this.user = builder.user;
        this.password = builder.password;
        if (builder.labels != null) {
            this.labels.putAllLabels(builder.labels);
        }
        this.proxyType = builder.proxyType;
        if (builder.proxyProperties == null) {
            this.proxyProperties = null;
        } else {
            this.proxyProperties = new Properties();
            this.proxyProperties.putAll((Map<?, ?>)builder.proxyProperties);
        }
        this.serviceName = builder.serviceName != null ? builder.serviceName.toLowerCase() : null;
        this.userRequestedServiceName = builder.userRequestedServiceName != null ? builder.userRequestedServiceName.toLowerCase() : null;
        int tempHashCode = 0;
        String tuser = this.user == null ? "" : this.user;
        tempHashCode = tuser.hashCode();
        if (this.serviceName != null) {
            tempHashCode = tempHashCode * 31 + this.serviceName.hashCode();
        }
        this.hashcode = tempHashCode;
        this.shardingKey = builder.shardingKey;
        this.superShardingKey = builder.superShardingKey;
        if (builder.pdbRoles == null) {
            this.pdbRoles = null;
        } else {
            this.pdbRoles = new Properties();
            this.pdbRoles.putAll((Map<?, ?>)builder.pdbRoles);
        }
        this.sslContext = builder.sslContext;
        this.hostnameResolver = builder.hostnameResolver;
        this.readOnlyInstanceAllowed = builder.readOnlyInstanceAllowed;
        this.lookupShardingKey = builder.lookupShardingKey;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    static Builder createBuilder(UCPConnectionBuilder builder) {
        UCPConnectionBuilderImpl connBldr = (UCPConnectionBuilderImpl)builder;
        return new Builder().user(connBldr.getUser()).password(connBldr.getPassword()).labels(connBldr.labels).proxyProperties(connBldr.proxyType, connBldr.proxyProperties).serviceName(connBldr.getServiceName()).shardingKey(connBldr.shardingKey).superShardingKey(connBldr.superShardingKey).pdbRoles(connBldr.getPdbRoles()).sslContext(connBldr.getSslContext()).hostnameResolver(connBldr.getHostnameResolver()).readOnlyInstanceAllowed(connBldr.isReadOnlyInstanceAllowed());
    }

    static Builder createBuilder(UCPXAConnectionBuilder builder) {
        UCPXAConnectionBuilderImpl xaConnBldr = (UCPXAConnectionBuilderImpl)builder;
        return new Builder().user(xaConnBldr.getUser()).password(xaConnBldr.getPassword()).labels(xaConnBldr.labels).proxyProperties(xaConnBldr.proxyType, xaConnBldr.proxyProperties).serviceName(xaConnBldr.getServiceName()).shardingKey(xaConnBldr.shardingKey).superShardingKey(xaConnBldr.superShardingKey).pdbRoles(xaConnBldr.getPdbRoles()).sslContext(xaConnBldr.getSslContext()).hostnameResolver(xaConnBldr.getHostnameResolver()).readOnlyInstanceAllowed(xaConnBldr.isReadOnlyInstanceAllowed());
    }

    private Builder copyBuilder() {
        return JDBCConnectionRetrievalInfo.createBuilder().user(this.user).password(this.password).labels(this.labels).proxyProperties(this.proxyType, this.proxyProperties).serviceName(this.serviceName).userRequestedServiceName(this.userRequestedServiceName).shardingKey(this.shardingKey).superShardingKey(this.superShardingKey).pdbRoles(this.pdbRoles).sslContext(this.sslContext).hostnameResolver(this.hostnameResolver).readOnlyInstanceAllowed(this.readOnlyInstanceAllowed).lookupShardingKey(this.lookupShardingKey);
    }

    public static final class Builder {
        private String user = null;
        private OpaqueString password = OpaqueString.NULL;
        private Properties labels = null;
        private int proxyType = -1;
        private Properties proxyProperties = null;
        private String serviceName = null;
        private String userRequestedServiceName = null;
        private OracleShardingKey shardingKey = null;
        private OracleShardingKey superShardingKey = null;
        private Properties pdbRoles = null;
        private SSLContext sslContext = null;
        private PoolDataSource.HostnameResolver hostnameResolver = null;
        private boolean readOnlyInstanceAllowed = false;
        private OracleShardingKey lookupShardingKey = null;

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(OpaqueString password) {
            this.password = password;
            return this;
        }

        public Builder labels(Properties labels) {
            this.labels = labels;
            return this;
        }

        public Builder proxyProperties(int type, Properties proxyProperties) {
            this.proxyType = type;
            this.proxyProperties = proxyProperties;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder userRequestedServiceName(String userRequestedServiceName) {
            this.userRequestedServiceName = userRequestedServiceName;
            return this;
        }

        public Builder shardingKey(OracleShardingKey shardingKey) {
            this.shardingKey = shardingKey;
            return this;
        }

        public Builder superShardingKey(OracleShardingKey superKey) {
            this.superShardingKey = superKey;
            return this;
        }

        public Builder pdbRoles(Properties pdbRoles) {
            this.pdbRoles = pdbRoles;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder hostnameResolver(PoolDataSource.HostnameResolver hostnameResolver) {
            this.hostnameResolver = hostnameResolver;
            return this;
        }

        public Builder readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
            this.readOnlyInstanceAllowed = readOnlyInstanceAllowed;
            return this;
        }

        public Builder lookupShardingKey(OracleShardingKey shardingKey) {
            this.lookupShardingKey = shardingKey;
            return this;
        }

        public JDBCConnectionRetrievalInfo build() {
            return new JDBCConnectionRetrievalInfo(this);
        }
    }

    private static final class Labels
    extends Properties {
        private static final long serialVersionUID = 4112578634029874841L;
        private static final String EXCEPTION_MESSAGE = "immutable properties";

        private Labels() {
        }

        private void addLabel(Object key, Object val) {
            super.put(key, val);
        }

        private void putAllLabels(Properties props) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.addLabel(k, v)));
        }

        private void removeLabel(String key) {
            super.remove(key);
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public Object putIfAbsent(Object key, Object value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public boolean remove(Object key, Object val) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public Object replace(Object key, Object val) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public boolean replace(Object key, Object oldval, Object newval) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }
    }
}

