/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;

public class DriverConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    static final String CLASS_NAME = DriverConnectionFactoryAdapter.class.getName();
    protected Driver m_driver;
    protected final Properties m_connectionProperties;
    protected final Properties m_connectionFactoryProperties;

    public DriverConnectionFactoryAdapter(Driver driver, String url, Properties connectionFactoryProperties, Properties connectionProperties, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(diagnosticsCollector);
        if (null == driver) {
            UCPErrorHandler.throwUniversalConnectionPoolException(268);
        }
        if (url == null || "".equals(url)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(269);
        }
        this.m_driver = driver;
        this.m_url = url;
        this.m_connectionFactoryProperties = connectionFactoryProperties;
        this.m_connectionProperties = connectionProperties;
    }

    public DriverConnectionFactoryAdapter(Driver driver, String url, Properties connectionFactoryProperties, Properties connectionProperties) throws UniversalConnectionPoolException {
        this(driver, url, connectionFactoryProperties, connectionProperties, DiagnosticsCollectorImpl.getCommon());
    }

    public Driver getDriver() {
        return this.m_driver;
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        Connection connection = null;
        try {
            Properties connProps = new Properties();
            connProps.putAll((Map<?, ?>)this.m_connectionProperties);
            connProps.putAll((Map<?, ?>)this.m_connectionFactoryProperties);
            connection = this.m_driver.connect(this.m_url, connProps);
            if (null != connection) {
                this.onSuccessfulConnectionCreation(connection);
            }
        }
        catch (Throwable e) {
            this.onFailedConnectionCreation(e);
            this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
            if (null != connection) {
                this.closeConnection(connection);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
        }
        return connection;
    }

    @Override
    public void closeConnection(Object connection) throws UniversalConnectionPoolException {
        if (!(connection instanceof Connection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(258);
        }
        Connection javaSQLConnection = (Connection)connection;
        try {
            javaSQLConnection.close();
        }
        catch (SQLException sqlException) {
            this.trace(Level.WARNING, CLASS_NAME, "closeConnection", "", null, sqlException, new Object[0]);
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
    }
}

