/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CriStats;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.Service;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;

public interface ConnectionSource
extends Diagnosable {
    default public CoreConnection create(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback, EnumSet<CreateMode> createModes, long timeToRetry) throws UniversalConnectionPoolException {
        throw new NoSuchMethodError();
    }

    default public CompletionStage<CoreConnection> createAsync(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback, EnumSet<CreateMode> createModes, long timeToRetry, Executor executor) {
        throw new NoSuchMethodError();
    }

    default public Predicate<CoreConnection> loadBalancedBorrowSelector(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback) {
        throw new NoSuchMethodError();
    }

    default public Counter totalCount() {
        throw new NoSuchMethodError();
    }

    default public Counter borrowedCount() {
        throw new NoSuchMethodError();
    }

    default public Counter totalCount(ConnectionRetrievalInfo cri) {
        throw new NoSuchMethodError();
    }

    default public Counter borrowedCount(ConnectionRetrievalInfo cri) {
        throw new NoSuchMethodError();
    }

    default public CriStats getCriMetadata(ConnectionRetrievalInfo cri) {
        throw new NoSuchMethodError();
    }

    default public boolean available(ConnectionRetrievalInfo cri) {
        throw new NoSuchMethodError();
    }

    default public Comparator<CoreConnection> costComparator(Properties labels) {
        throw new NoSuchMethodError();
    }

    default public Predicate<CoreConnection> routingKeyBasedBorrowSelector(ConnectionRetrievalInfo cri, boolean usePriority) {
        throw new NoSuchMethodError();
    }

    default public void start(ConnectionRetrievalInfo cri, Consumer<String> serviceNameConsumer, Consumer<CoreConnection> connectionConsumer) throws UniversalConnectionPoolException {
        throw new NoSuchMethodError();
    }

    default public void stop() {
        throw new NoSuchMethodError();
    }

    default public LoadBalancer.Stats loadBalancerStats(String serviceName) {
        throw new NoSuchMethodError();
    }

    default public FailoverDriver.Stats failoverDriverStats(String serviceName) {
        throw new NoSuchMethodError();
    }

    default public boolean isReplayable() {
        throw new NoSuchMethodError();
    }

    default public void setReplayable(boolean isReplayable) {
        throw new NoSuchMethodError();
    }

    default public boolean failoverEnabled() {
        throw new NoSuchMethodError();
    }

    default public void registerService(String serviceName, FailoverCallback failoverCallback, RebalanceCallback rebalanceCallback) {
        throw new NoSuchMethodError();
    }

    default public boolean isServiceRegistered(String serviceName) {
        throw new NoSuchMethodError();
    }

    default public boolean validateCri(ConnectionRetrievalInfo cri) {
        throw new NoSuchMethodError();
    }

    default public String serviceName(ConnectionRetrievalInfo cri) {
        throw new NoSuchMethodError();
    }

    default public ConnectionRetrievalInfo defaultCri() {
        throw new NoSuchMethodError();
    }

    default public String defaultServiceName() {
        throw new NoSuchMethodError();
    }

    default public ConnectionRetrievalInfo defaultCriAndService() {
        ConnectionRetrievalInfo cri = this.defaultCri();
        if (!1.$assertionsDisabled && null == cri) {
            throw new AssertionError();
        }
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jcri = (JDBCConnectionRetrievalInfo)cri;
            String defaultServiceName = this.defaultServiceName();
            if (!1.$assertionsDisabled && null == defaultServiceName) {
                throw new AssertionError();
            }
            return jcri.getCopyWithService(defaultServiceName);
        }
        return cri;
    }

    default public Predicate<CoreConnection> serviceSelector(String serviceName) {
        throw new NoSuchMethodError();
    }

    default public boolean isShardedDatabase() {
        throw new NoSuchMethodError();
    }

    default public boolean isCatalogDatabase() {
        throw new NoSuchMethodError();
    }

    default public boolean isMultitenantDatabase() {
        throw new NoSuchMethodError();
    }

    default public boolean isRacDataAffinityEnabled() {
        throw new NoSuchMethodError();
    }

    default public Predicate<CoreConnection> serviceBasedRepurposeSelector(ConnectionRetrievalInfo cri, boolean balanced) {
        throw new NoSuchMethodError();
    }

    default public boolean isShareable() {
        throw new NoSuchMethodError();
    }

    default public boolean isReadOnlyInstanceAllowed() {
        throw new NoSuchMethodError();
    }

    default public int getOutboundConnectTimeout() {
        throw new NoSuchMethodError();
    }

    default public boolean isOracle() {
        throw new NoSuchMethodError();
    }

    default public LongAdder getCumulativeConnectionCreationAttempts() {
        throw new NoSuchMethodError("not implemented");
    }

    default public LongAdder getConnectionCreationAttemptsSinceLastOutage() {
        throw new NoSuchMethodError("not implemented");
    }

    default public Service getServiceByName(String serviceName) {
        throw new NoSuchMethodError("not implemented");
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface RebalanceCallback {
        public Result handle(Predicate<CoreConnection> var1, Predicate<CoreConnection> var2);

        public static class Result {
            final AtomicBoolean terminate = new AtomicBoolean(false);

            Result() {
            }

            void terminate() {
                this.terminate.set(true);
            }
        }
    }

    public static enum CreateMode {
        USE_BEST_INSTANCE;

    }

    public static interface FailoverCallback {
        public Result handle(Predicate<CoreConnection> var1, Predicate<CoreConnection> var2, boolean var3, boolean var4);

        public static class Result {
            ResultType type;
            int availConns;
            int availOpened;
            int availFailedToProcess;
            int availMarkedDown;
            int availClosed;
            int borrowedConns;
            int borrowedFailedToProcess;
            int borrowedMarkedDown;
            int borrowedClosed;

            Result(ResultType type, int availConns, int availOpened, int availFailedToProcess, int availMarkedDown, int availClosed, int borrowedConns, int borrowedFailedToProcess, int borrowedMarkedDown, int borrowedClosed) {
                this.type = type;
                this.availConns = availConns;
                this.availOpened = availOpened;
                this.availFailedToProcess = availFailedToProcess;
                this.availMarkedDown = availMarkedDown;
                this.availClosed = availClosed;
                this.borrowedConns = borrowedConns;
                this.borrowedFailedToProcess = borrowedFailedToProcess;
                this.borrowedMarkedDown = borrowedMarkedDown;
                this.borrowedClosed = borrowedClosed;
            }

            Result() {
                this(ResultType.SUCCESS, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            }

            Result(ResultType type) {
                this(type, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            }

            public String toString() {
                return "availConns=" + this.availConns + ", availOpened=" + this.availOpened + ", availFailedToProcess=" + this.availFailedToProcess + ", availMarkedDown=" + this.availMarkedDown + ", availClosed=" + this.availClosed + ", borrowedConns=" + this.borrowedConns + ", borrowedFailedToProcess=" + this.borrowedFailedToProcess + ", borrowedMarkedDown=" + this.borrowedMarkedDown + ", borrowedClosed=" + this.borrowedClosed;
            }

            static enum ResultType {
                SUCCESS,
                FAILURE,
                INVALID_NOT_PROCESSED,
                REDUNDANT_NOT_PROCESSED,
                OUTOFORDER_NOT_PROCESSED;

            }
        }
    }
}

