/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.gcp;

import com.dbeaver.net.auth.gcp.AuthModelGCPAbstract;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AuthModelGCPAlloyDB
extends AuthModelGCPAbstract<AuthModelGCPCredentials> {
    public static final String ID = "gcp_cloud_iam_alloydb";
    private static final Log log = Log.getLog(AuthModelGCPAlloyDB.class);
    private UUID uuid;

    @NotNull
    public AuthModelGCPCredentials createCredentials() {
        return new AuthModelGCPCredentials();
    }

    @Override
    @NotNull
    protected AuthModelGCPCredentials copyCredentials(@NotNull AuthModelGCPCredentials credentials) {
        return new AuthModelGCPCredentials(credentials);
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelGCPCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        credentials.resolveCredentials(monitor);
        connProperties.put("alloydbInstanceName", configuration.getHostName());
        GoogleCredentials googleCredentials = (GoogleCredentials)credentials.getGoogleCredentials();
        this.uuid = UUID.randomUUID();
        try {
            String configBuilderClassName = "com.google.cloud.alloydb.ConnectorConfig$Builder";
            Object driverInstance = dataSource.getContainer().getDriver().getDefaultDriverLoader().getDriverInstance(monitor);
            ClassLoader classLoader = driverInstance.getClass().getClassLoader();
            Class<?> configBuilderClass = classLoader.loadClass(configBuilderClassName);
            Constructor<?> declaredConstructor = configBuilderClass.getDeclaredConstructor(new Class[0]);
            Object builderInstance = declaredConstructor.newInstance(new Object[0]);
            Method withGoogleCredentials = builderInstance.getClass().getDeclaredMethod("withGoogleCredentials", GoogleCredentials.class);
            builderInstance = withGoogleCredentials.invoke(builderInstance, googleCredentials);
            String configClassName = "com.google.cloud.alloydb.ConnectorConfig";
            Class<?> configClass = classLoader.loadClass(configClassName);
            Object configInstance = builderInstance.getClass().getDeclaredMethod("build", new Class[0]).invoke(builderInstance, new Object[0]);
            String registryClassName = "com.google.cloud.alloydb.ConnectorRegistry";
            Class<?> registryClass = classLoader.loadClass(registryClassName);
            Method register = registryClass.getMethod("register", String.class, configClass);
            register.invoke(null, this.uuid.toString(), configInstance);
            connProperties.put("alloydbNamedConnector", this.uuid.toString());
        }
        catch (Exception e) {
            log.debug((Object)"Error configuring alloyDB configuration", (Throwable)e);
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    @Override
    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelGCPCredentials credentials) throws DBException {
        credentials.refreshSession(monitor);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

