/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client;

import com.dbeaver.remote.client.RefreshSMSessionFunction;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.auth.SMCredentials;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;

public abstract class AbstractRemoteClientConfiguration {
    public static final SMCredentialsProvider NO_AUTH_CREDENTIALS_MANAGER = new SMCredentialsProvider(){

        public SMCredentials getActiveUserCredentials() {
            return null;
        }

        public boolean hasPermission(String permission) {
            return false;
        }
    };
    @NotNull
    protected final String apiUrl;
    @NotNull
    protected final SMCredentialsProvider credentialsProvider;
    @Nullable
    protected final RefreshSMSessionFunction refreshSMSessionFunction;
    @Nullable
    private final String dcCertificate;
    @Nullable
    private final String applicationId;
    private final int initRetryRequestDuration;

    protected AbstractRemoteClientConfiguration(@NotNull String apiUrl, @NotNull SMCredentialsProvider credentialsProvider, @Nullable RefreshSMSessionFunction refreshSMSessionFunction) {
        this(apiUrl, credentialsProvider, refreshSMSessionFunction, null, null);
    }

    protected AbstractRemoteClientConfiguration(@NotNull String apiUrl, @NotNull SMCredentialsProvider credentialsProvider, @Nullable RefreshSMSessionFunction refreshSMSessionFunction, @Nullable String dcCertificate, @Nullable String applicationId) {
        this(apiUrl, credentialsProvider, refreshSMSessionFunction, dcCertificate, applicationId, 0);
    }

    protected AbstractRemoteClientConfiguration(@NotNull String apiUrl, @NotNull SMCredentialsProvider credentialsProvider, @Nullable RefreshSMSessionFunction refreshSMSessionFunction, @Nullable String dcCertificate, @Nullable String applicationId, int initRetryRequestDuration) {
        this.apiUrl = Objects.requireNonNull(apiUrl, "DC api url is null");
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "SM credentials provider is null");
        this.refreshSMSessionFunction = refreshSMSessionFunction;
        this.dcCertificate = dcCertificate;
        this.applicationId = applicationId;
        this.initRetryRequestDuration = initRetryRequestDuration;
    }

    @NotNull
    public String getApiUrl() {
        return this.apiUrl;
    }

    @NotNull
    public SMCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Nullable
    public RefreshSMSessionFunction getRefreshSMSessionFunction() {
        return this.refreshSMSessionFunction;
    }

    @Nullable
    public String getDcCertificate() {
        return this.dcCertificate;
    }

    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    public int getInitRetryRequestDuration() {
        return this.initRetryRequestDuration;
    }

    protected static abstract class AbstractBuilder<BUILDER extends AbstractBuilder, CLIENT_CONFIG> {
        protected String apiUrl;
        protected SMCredentialsProvider credentialsProvider = NO_AUTH_CREDENTIALS_MANAGER;
        protected RefreshSMSessionFunction refreshSMSessionFunction;
        protected int initRetryRequestDuration = 300;
        protected String dcCertificate = null;
        protected String applicationId = null;

        protected AbstractBuilder() {
        }

        public BUILDER from(@NotNull AbstractRemoteClientConfiguration originConfig) {
            this.apiUrl = originConfig.apiUrl;
            this.credentialsProvider = originConfig.credentialsProvider;
            this.dcCertificate = originConfig.dcCertificate;
            this.applicationId = originConfig.applicationId;
            this.initRetryRequestDuration = originConfig.initRetryRequestDuration;
            return this.getThis();
        }

        public BUILDER setDcCertificate(String dcCertificate) {
            this.dcCertificate = dcCertificate;
            return this.getThis();
        }

        public BUILDER setApiUrl(@NotNull String apiUrl) {
            this.apiUrl = apiUrl;
            return this.getThis();
        }

        public BUILDER setCredentialsProvider(@NotNull SMCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this.getThis();
        }

        public BUILDER setRefreshSMSessionFunction(@Nullable RefreshSMSessionFunction refreshSMSessionFunction) {
            this.refreshSMSessionFunction = refreshSMSessionFunction;
            return this.getThis();
        }

        public BUILDER setApplicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
            return this.getThis();
        }

        public BUILDER setInitRetryRequestDuration(int initRetryRequestDuration) {
            this.initRetryRequestDuration = initRetryRequestDuration;
            return this.getThis();
        }

        public abstract CLIENT_CONFIG build();

        protected abstract BUILDER getThis();
    }
}

