/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class FederatedIdentityCredentialProperties {
    @JsonProperty(value="issuer", required=true)
    private String issuer;
    @JsonProperty(value="subject", required=true)
    private String subject;
    @JsonProperty(value="audiences", required=true)
    private List<String> audiences;
    private static final ClientLogger LOGGER = new ClientLogger(FederatedIdentityCredentialProperties.class);

    public String issuer() {
        return this.issuer;
    }

    public FederatedIdentityCredentialProperties withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public FederatedIdentityCredentialProperties withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public List<String> audiences() {
        return this.audiences;
    }

    public FederatedIdentityCredentialProperties withAudiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public void validate() {
        if (this.issuer() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property issuer in model FederatedIdentityCredentialProperties"));
        }
        if (this.subject() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property subject in model FederatedIdentityCredentialProperties"));
        }
        if (this.audiences() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property audiences in model FederatedIdentityCredentialProperties"));
        }
    }
}

