/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.wire.BatchCompletionResponse;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.FetchResponse;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.SqlResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.KnownServerKey;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractWireOperations
implements FbWireOperations {
    private static final Logger log = LoggerFactory.getLogger(AbstractWireOperations.class);
    private final WireConnection<?, ?> connection;
    private final WarningMessageCallback defaultWarningMessageCallback;

    protected AbstractWireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        this.connection = Objects.requireNonNull(connection, "connection");
        this.defaultWarningMessageCallback = Objects.requireNonNull(defaultWarningMessageCallback, "defaultWarningMessageCallback");
    }

    @Override
    public final XdrStreamAccess getXdrStreamAccess() {
        return this.connection.getXdrStreamAccess();
    }

    protected final Encoding getEncoding() {
        return this.connection.getEncoding();
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    @Override
    public final SQLException readStatusVector() throws SQLException {
        return this.readStatusVector(this.getXdrIn());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final SQLException readStatusVector(XdrInputStream xdrIn) throws SQLException {
        boolean debug = log.isDebugEnabled();
        FbExceptionBuilder builder = new FbExceptionBuilder();
        try {
            block10: while (true) {
                int arg = xdrIn.readInt();
                switch (arg) {
                    case 1: {
                        int errorCode = xdrIn.readInt();
                        if (debug) {
                            log.debugf("readStatusVector arg:isc_arg_gds int: %d", (Object)errorCode);
                        }
                        if (errorCode == 0) continue block10;
                        builder.exception(errorCode);
                        continue block10;
                    }
                    case 18: {
                        int errorCode = xdrIn.readInt();
                        if (debug) {
                            log.debugf("readStatusVector arg:isc_arg_warning int: %d", (Object)errorCode);
                        }
                        if (errorCode == 0) continue block10;
                        builder.warning(errorCode);
                        continue block10;
                    }
                    case 2: 
                    case 5: {
                        String stringValue = xdrIn.readString(this.getEncoding());
                        log.debugf("readStatusVector string: %s", (Object)stringValue);
                        builder.messageParameter(stringValue);
                        continue block10;
                    }
                    case 19: {
                        String sqlState = xdrIn.readString(this.getEncoding());
                        log.debugf("readStatusVector sqlstate: %s", (Object)sqlState);
                        builder.sqlState(sqlState);
                        continue block10;
                    }
                    case 4: {
                        int intValue = xdrIn.readInt();
                        if (debug) {
                            log.debugf("readStatusVector arg:isc_arg_number int: %d", (Object)intValue);
                        }
                        builder.messageParameter(intValue);
                        continue block10;
                    }
                    case 0: {
                        if (builder.isEmpty()) {
                            return null;
                        }
                        return builder.toFlatSQLException();
                    }
                }
                int e = xdrIn.readInt();
                if (debug) {
                    log.debugf("readStatusVector arg: %d int: %d", (Object)arg, (Object)e);
                }
                builder.messageParameter(e);
            }
        }
        catch (IOException ioe) {
            throw new FbExceptionBuilder().exception(335544726).cause(ioe).toSQLException();
        }
    }

    @Override
    public final Response readResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return this.readOperationResponse(this.readNextOperation(), warningCallback);
    }

    @Override
    public final Response readOperationResponse(int operationCode, WarningMessageCallback warningCallback) throws SQLException, IOException {
        Response response = this.processOperation(operationCode);
        this.processResponseWarnings(response, warningCallback);
        this.processResponse(response);
        return response;
    }

    public final int readNextOperation() throws IOException {
        try (LockCloseable ignored = this.withLock();){
            this.processDeferredActions();
            int n = this.connection.readNextOperation();
            return n;
        }
    }

    protected final Response processOperation(int operation) throws SQLException, IOException {
        XdrInputStream xdrIn = this.getXdrIn();
        switch (operation) {
            case 9: {
                return new GenericResponse(xdrIn.readInt(), xdrIn.readLong(), xdrIn.readBuffer(), this.readStatusVector());
            }
            case 66: {
                return new FetchResponse(xdrIn.readInt(), xdrIn.readInt());
            }
            case 78: {
                return new SqlResponse(xdrIn.readInt());
            }
            case 103: {
                return this.readBatchCompletionResponse(xdrIn);
            }
        }
        throw new FbExceptionBuilder().nonTransientException(337248276).messageParameter(operation).messageParameter("processOperation").toSQLException();
    }

    protected BatchCompletionResponse readBatchCompletionResponse(XdrInputStream xdrIn) throws SQLException, IOException {
        throw new FBDriverNotCapableException("Reading batch completion response not supported by " + this);
    }

    @Override
    public final void processResponse(Response response) throws SQLException {
        GenericResponse genericResponse;
        SQLException exception;
        if (response instanceof GenericResponse && (exception = (genericResponse = (GenericResponse)response).getException()) != null && !(exception instanceof SQLWarning)) {
            throw exception;
        }
    }

    @Override
    public final void processResponseWarnings(Response response, WarningMessageCallback warningCallback) {
        GenericResponse genericResponse;
        SQLException exception;
        if (response instanceof GenericResponse && (exception = (genericResponse = (GenericResponse)response).getException()) instanceof SQLWarning) {
            this.orDefault(warningCallback).processWarning((SQLWarning)exception);
        }
    }

    private WarningMessageCallback orDefault(WarningMessageCallback warningMessageCallback) {
        return warningMessageCallback != null ? warningMessageCallback : this.defaultWarningMessageCallback;
    }

    @Override
    public final GenericResponse readGenericResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return (GenericResponse)this.readResponse(warningCallback);
    }

    @Override
    public final SqlResponse readSqlResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return (SqlResponse)this.readResponse(warningCallback);
    }

    @Override
    public void handleCryptKeyCallback(DbCryptCallback dbCryptCallback) throws IOException, SQLException {
        throw new FBDriverNotCapableException("Crypt key callbacks not supported in this protocol version");
    }

    @Override
    public final void consumePackets(int numberOfResponses, WarningMessageCallback warningCallback) {
        while (numberOfResponses > 0) {
            --numberOfResponses;
            try {
                this.readResponse(warningCallback);
            }
            catch (Exception e) {
                this.orDefault(warningCallback).processWarning(new SQLWarning(e));
                log.warnDebug("Exception in consumePackets", e);
            }
        }
    }

    @Override
    public final void writeDirect(byte[] data) throws IOException {
        this.connection.writeDirect(data);
    }

    @Override
    public void setNetworkTimeout(int milliseconds) throws SQLException {
        if (milliseconds < 0) {
            throw FbExceptionBuilder.forException(337248296).toSQLException();
        }
        this.connection.setSoTimeout(milliseconds);
    }

    protected final LockCloseable withLock() {
        return this.connection.withLockProxy();
    }

    protected final void addServerKeys(byte[] serverKeys) throws SQLException {
        this.connection.addServerKeys(serverKeys);
    }

    protected final void clearServerKeys() {
        this.connection.clearServerKeys();
    }

    protected final ClientAuthBlock getClientAuthBlock() {
        return this.connection.getClientAuthBlock();
    }

    protected final IAttachProperties<?> getAttachProperties() {
        return this.connection.getAttachProperties().asImmutable();
    }

    protected final List<KnownServerKey.PluginSpecificData> getPluginSpecificData() {
        return this.connection.getPluginSpecificData();
    }

    protected final WireConnection<?, ?> getConnection() {
        return this.connection;
    }

    protected final WarningMessageCallback getDefaultWarningMessageCallback() {
        return this.defaultWarningMessageCallback;
    }
}

