/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Arrays;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbExceptionBuilder;

public class ClumpletReader {
    private final Kind kind;
    private final byte[] buffer;
    private int spbState;
    private int position;

    public ClumpletReader(Kind kind, byte[] buffer) {
        this.kind = kind;
        this.buffer = buffer;
    }

    public boolean isTagged() {
        switch (this.kind) {
            case Tpb: 
            case Tagged: 
            case WideTagged: 
            case SpbAttach: {
                return true;
            }
        }
        return false;
    }

    public int getBufferTag() throws SQLException {
        switch (this.kind) {
            case Tpb: 
            case Tagged: 
            case WideTagged: {
                if (this.buffer.length == 0) {
                    throw ClumpletReader.invalidStructure("empty buffer");
                }
                return this.buffer[0];
            }
            case SpbStart: 
            case UnTagged: 
            case WideUnTagged: 
            case SpbSendItems: 
            case SpbReceiveItems: {
                throw ClumpletReader.usageMistake("buffer is not tagged");
            }
            case SpbAttach: {
                if (this.buffer.length == 0) {
                    throw ClumpletReader.invalidStructure("empty buffer");
                }
                switch (this.buffer[0]) {
                    case 1: {
                        return this.buffer[0];
                    }
                    case 2: {
                        if (this.buffer.length == 1) {
                            throw ClumpletReader.invalidStructure("buffer too short (1 byte)");
                        }
                        return this.buffer[1];
                    }
                    case 3: {
                        return this.buffer[0];
                    }
                }
                throw ClumpletReader.invalidStructure("spb in service attach should begin with isc_spb_version1 or isc_spb_version");
            }
        }
        throw new SQLException("Unexpected clumplet kind: " + this.kind);
    }

    public ClumpletType getClumpletType(byte tag) throws SQLException {
        switch (this.kind) {
            case Tagged: 
            case SpbAttach: 
            case UnTagged: {
                return ClumpletType.TraditionalDpb;
            }
            case WideTagged: 
            case WideUnTagged: {
                return ClumpletType.Wide;
            }
            case Tpb: {
                switch (tag) {
                    case 10: 
                    case 11: 
                    case 21: {
                        return ClumpletType.TraditionalDpb;
                    }
                }
                return ClumpletType.SingleTpb;
            }
            case SpbSendItems: {
                switch (tag) {
                    case 69: {
                        return ClumpletType.Wide;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 126: 
                    case 127: {
                        return ClumpletType.SingleTpb;
                    }
                }
                return ClumpletType.StringSpb;
            }
            case SpbReceiveItems: {
                return ClumpletType.SingleTpb;
            }
            case SpbStart: {
                switch (tag) {
                    case 111: 
                    case 115: 
                    case 116: 
                    case 117: {
                        return ClumpletType.Wide;
                    }
                }
                switch (this.spbState) {
                    case 0: {
                        return ClumpletType.SingleTpb;
                    }
                    case 1: 
                    case 2: {
                        switch (tag) {
                            case 5: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 106: {
                                return ClumpletType.StringSpb;
                            }
                            case 6: 
                            case 7: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 108: 
                            case 114: {
                                return ClumpletType.IntSpb;
                            }
                            case 107: {
                                return ClumpletType.SingleTpb;
                            }
                            case 12: {
                                return ClumpletType.ByteSpb;
                            }
                        }
                        throw ClumpletReader.invalidStructure("unknown parameter for backup/restore");
                    }
                    case 3: {
                        switch (tag) {
                            case 106: {
                                return ClumpletType.StringSpb;
                            }
                            case 15: 
                            case 17: 
                            case 34: 
                            case 108: {
                                return ClumpletType.IntSpb;
                            }
                            case 49: 
                            case 50: 
                            case 51: {
                                return ClumpletType.BigIntSpb;
                            }
                        }
                        throw ClumpletReader.invalidStructure("unknown parameter for repair");
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 27: 
                    case 28: 
                    case 29: {
                        switch (tag) {
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 60: 
                            case 106: {
                                return ClumpletType.StringSpb;
                            }
                            case 5: 
                            case 6: 
                            case 13: {
                                return ClumpletType.IntSpb;
                            }
                        }
                        throw ClumpletReader.invalidStructure("unknown parameter for security database operation");
                    }
                    case 8: {
                        switch (tag) {
                            case 106: {
                                return ClumpletType.StringSpb;
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 9: 
                            case 10: 
                            case 14: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 108: {
                                return ClumpletType.IntSpb;
                            }
                            case 11: 
                            case 12: 
                            case 13: 
                            case 44: 
                            case 45: {
                                return ClumpletType.ByteSpb;
                            }
                        }
                        throw ClumpletReader.invalidStructure("unknown parameter for setting database properties");
                    }
                    case 11: {
                        switch (tag) {
                            case 64: 
                            case 105: 
                            case 106: {
                                return ClumpletType.StringSpb;
                            }
                            case 108: {
                                return ClumpletType.IntSpb;
                            }
                        }
                        throw ClumpletReader.invalidStructure("unknown parameter for getting statistics");
                    }
                    case 12: {
                        throw ClumpletReader.invalidStructure("unknown parameter for getting log");
                    }
                    case 20: 
                    case 21: {
                        switch (tag) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 106: {
                                return ClumpletType.StringSpb;
                            }
                            case 5: 
                            case 10: 
                            case 11: 
                            case 108: {
                                return ClumpletType.IntSpb;
                            }
                            case 9: {
                                return ClumpletType.SingleTpb;
                            }
                        }
                        throw ClumpletReader.invalidStructure("unknown parameter for nbackup");
                    }
                    case 31: {
                        switch (tag) {
                            case 106: {
                                return ClumpletType.StringSpb;
                            }
                            case 108: {
                                return ClumpletType.IntSpb;
                            }
                        }
                        throw ClumpletReader.invalidStructure("unknown parameter for nbackup");
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        switch (tag) {
                            case 2: 
                            case 3: {
                                return ClumpletType.StringSpb;
                            }
                            case 1: {
                                return ClumpletType.IntSpb;
                            }
                        }
                        break;
                    }
                    case 30: {
                        switch (tag) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 106: {
                                return ClumpletType.StringSpb;
                            }
                            case 5: {
                                return ClumpletType.IntSpb;
                            }
                        }
                    }
                }
                throw ClumpletReader.invalidStructure("wrong spb state");
            }
        }
        throw ClumpletReader.invalidStructure("unknown reason");
    }

    public void adjustSpbState() throws SQLException {
        if (this.kind == Kind.SpbStart && this.spbState == 0 && this.getClumpletSize(true, true, true) == 1) {
            this.spbState = this.getClumpTag();
        }
    }

    public int getClumpletSize(boolean wTag, boolean wLength, boolean wData) throws SQLException {
        if (this.position >= this.buffer.length) {
            throw ClumpletReader.usageMistake("read past EOF");
        }
        int rc = wTag ? 1 : 0;
        int lengthSize = 0;
        int dataSize = 0;
        switch (this.getClumpletType(this.buffer[this.position])) {
            case Wide: {
                if (this.buffer.length - this.position < 5) {
                    throw ClumpletReader.invalidStructure("buffer end before end of clumplet - no length component");
                }
                lengthSize = 4;
                dataSize = VaxEncoding.iscVaxInteger(this.buffer, this.position + 1, 4);
                break;
            }
            case TraditionalDpb: {
                if (this.buffer.length - this.position < 2) {
                    throw ClumpletReader.invalidStructure("buffer end before end of clumplet - no length component");
                }
                lengthSize = 1;
                dataSize = this.buffer[this.position + 1] & 0xFF;
                break;
            }
            case SingleTpb: {
                break;
            }
            case StringSpb: {
                if (this.buffer.length - this.position < 3) {
                    throw ClumpletReader.invalidStructure("buffer end before end of clumplet - no length component");
                }
                lengthSize = 2;
                dataSize = VaxEncoding.iscVaxInteger2(this.buffer, this.position + 1);
                break;
            }
            case IntSpb: {
                dataSize = 4;
                break;
            }
            case BigIntSpb: {
                dataSize = 8;
                break;
            }
            case ByteSpb: {
                dataSize = 1;
            }
        }
        int total = 1 + lengthSize + dataSize;
        if (this.position + total > this.buffer.length) {
            throw ClumpletReader.invalidStructure("buffer end before end of clumplet - clumplet too long");
        }
        if (wLength) {
            rc += lengthSize;
        }
        if (wData) {
            rc += dataSize;
        }
        return rc;
    }

    public void moveNext() throws SQLException {
        if (this.isEof()) {
            return;
        }
        int cs = this.getClumpletSize(true, true, true);
        this.adjustSpbState();
        this.position += cs;
    }

    public void rewind() throws SQLException {
        if (this.buffer == null || this.buffer.length == 0) {
            this.position = 0;
            this.spbState = 0;
            return;
        }
        switch (this.kind) {
            case SpbStart: 
            case UnTagged: 
            case WideUnTagged: 
            case SpbSendItems: 
            case SpbReceiveItems: {
                this.position = 0;
                break;
            }
            default: {
                this.position = this.kind == Kind.SpbAttach && this.getBufferLength() > 0 && this.buffer[0] != 1 ? 2 : 1;
            }
        }
        this.spbState = 0;
    }

    public boolean find(int tag) throws SQLException {
        int markPosition = this.position;
        this.rewind();
        while (!this.isEof()) {
            if (tag == this.getClumpTag()) {
                return true;
            }
            this.moveNext();
        }
        this.position = markPosition;
        return false;
    }

    public boolean next(int tag) throws SQLException {
        if (!this.isEof()) {
            int markPosition = this.position;
            if (tag == this.getClumpTag()) {
                this.moveNext();
            }
            while (!this.isEof()) {
                if (tag == this.getClumpTag()) {
                    return true;
                }
                this.moveNext();
            }
            this.position = markPosition;
        }
        return false;
    }

    public boolean directNext(int tag) throws SQLException {
        if (!this.isEof()) {
            int markPosition = this.position;
            this.moveNext();
            if (!this.isEof() && tag == this.getClumpTag()) {
                return true;
            }
            this.position = markPosition;
        }
        return false;
    }

    public int getClumpTag() throws SQLException {
        if (this.position >= this.buffer.length) {
            throw ClumpletReader.usageMistake("read past EOF");
        }
        return this.buffer[this.position] & 0xFF;
    }

    public int getClumpLength() throws SQLException {
        return this.getClumpletSize(false, false, true);
    }

    public byte[] getBytes() throws SQLException {
        int from = this.position + this.getClumpletSize(true, true, false);
        int to = from + this.getClumpLength();
        return Arrays.copyOfRange(this.buffer, from, to);
    }

    public int getInt() throws SQLException {
        int length = this.getClumpLength();
        if (length > 4) {
            throw ClumpletReader.invalidStructure("length of integer exceeds 4 bytes");
        }
        int from = this.position + this.getClumpletSize(true, true, false);
        return VaxEncoding.iscVaxInteger(this.buffer, from, length);
    }

    public long getLong() throws SQLException {
        int length = this.getClumpLength();
        if (length > 8) {
            throw ClumpletReader.invalidStructure("length of long exceeds 8 bytes");
        }
        int from = this.position + this.getClumpletSize(true, true, false);
        return VaxEncoding.iscVaxLong(this.buffer, from, length);
    }

    public String getString(Encoding encoding) throws SQLException {
        int length = this.getClumpLength();
        int from = this.position + this.getClumpletSize(true, true, false);
        return encoding.decodeFromCharset(this.buffer, from, length);
    }

    public String getString(Charset charset) throws SQLException {
        int length = this.getClumpLength();
        int from = this.position + this.getClumpletSize(true, true, false);
        return new String(this.buffer, from, length, charset);
    }

    public boolean isEof() {
        return this.position >= this.getBufferLength();
    }

    private int getBufferLength() {
        if (this.buffer.length == 1 && this.kind != Kind.UnTagged && this.kind != Kind.SpbStart && this.kind != Kind.WideUnTagged && this.kind != Kind.SpbSendItems && this.kind != Kind.SpbReceiveItems) {
            return 0;
        }
        return this.buffer.length;
    }

    private static SQLException invalidStructure(String message) {
        return FbExceptionBuilder.forException(337248261).messageParameter(message).toSQLException();
    }

    private static SQLException usageMistake(String message) {
        return FbExceptionBuilder.forException(337248262).messageParameter(message).toSQLException();
    }

    public static enum ClumpletType {
        TraditionalDpb,
        SingleTpb,
        StringSpb,
        IntSpb,
        BigIntSpb,
        ByteSpb,
        Wide;

    }

    public static enum Kind {
        EndOfList,
        Tagged,
        UnTagged,
        SpbAttach,
        SpbStart,
        Tpb,
        WideTagged,
        WideUnTagged,
        SpbSendItems,
        SpbReceiveItems;

    }
}

