/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.logging;

public enum LogLevel {
    OFF(0),
    DEBUG(2),
    INFO(3),
    ENTRY_EXIT(4),
    FATAL(5);

    private int level = -1;

    private LogLevel(int level) {
        this.level = level;
    }

    public static LogLevel getDefault() {
        return OFF;
    }

    public String toString() {
        switch (this.level) {
            case 0: {
                return "OFF";
            }
            case 3: {
                return "INFO";
            }
            case 2: {
                return "DEBUG";
            }
            case 4: {
                return "ENTRY_EXIT";
            }
            case 5: {
                return "FATAL";
            }
        }
        return "OFF";
    }

    public boolean greaterThanEqualTo(LogLevel level) {
        if (level == null || level == OFF) {
            return false;
        }
        return this.level >= level.level;
    }

    public static LogLevel getLogLevel(int loglevel) {
        switch (loglevel) {
            case 0: {
                return OFF;
            }
            case 3: {
                return INFO;
            }
            case 2: {
                return DEBUG;
            }
            case 4: {
                return ENTRY_EXIT;
            }
            case 5: {
                return FATAL;
            }
        }
        return OFF;
    }

    public static LogLevel getLogLevel(String loglevel) {
        if (loglevel == null) {
            return OFF;
        }
        if ((loglevel = loglevel.trim()).equalsIgnoreCase(OFF.toString())) {
            return OFF;
        }
        if (loglevel.equalsIgnoreCase(DEBUG.toString())) {
            return DEBUG;
        }
        if (loglevel.equalsIgnoreCase(INFO.toString())) {
            return INFO;
        }
        if (loglevel.equalsIgnoreCase(ENTRY_EXIT.toString())) {
            return ENTRY_EXIT;
        }
        if (loglevel.equalsIgnoreCase(FATAL.toString())) {
            return FATAL;
        }
        try {
            return LogLevel.getLogLevel(Integer.parseInt(loglevel));
        }
        catch (NumberFormatException e) {
            return OFF;
        }
    }
}

