/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.netezza.Driver;
import org.netezza.datasource.NzDatasource;

public class NzURL {
    private final String url;
    private final Properties properties;
    private NzDatasource datasource;
    private boolean isParsed;
    private String tempProtocol = "";

    public NzURL(String url, Properties properties) {
        this.url = url;
        this.properties = properties;
    }

    public String getUrl() {
        return this.url;
    }

    public NzDatasource getDatasource() {
        return this.datasource;
    }

    public boolean parse() throws SQLException {
        boolean containMixedChar = this.url.indexOf("\"") != -1;
        this.datasource = new NzDatasource();
        String user = this.properties.getProperty("user");
        String password = this.properties.getProperty("password");
        if (containMixedChar) {
            String firstPart = "jdbc:netezza://";
            if (this.url.indexOf("jdbc:netezza://") == 0) {
                this.tempProtocol = this.url.substring("jdbc:netezza://".length());
            } else if (this.url.indexOf("jdbc:netezza:/") == 0) {
                this.tempProtocol = this.url.substring("jdbc:netezza:/".length());
            } else {
                return false;
            }
            this.datasource.setProtocol("netezza");
            if (this.tempProtocol.toLowerCase().indexOf("dsn=") == 0) {
                this.parseDSNProtocol();
            } else {
                this.parseHostDBProtocol();
            }
        } else {
            int count = 0;
            StringTokenizer st = new StringTokenizer(this.url, "?&;");
            boolean first = true;
            String[] secondPart = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                if (first) {
                    if (!this.parseFirstPart(part, this.datasource)) {
                        return false;
                    }
                    first = false;
                    continue;
                }
                int n = count;
                count = (byte)(count + 1);
                secondPart[n] = part;
            }
            this.parsesSecondPart(secondPart, this.datasource);
        }
        if (this.datasource.isClientKrbSSODelegated()) {
            try {
                GSSManager manager = GSSManager.getInstance();
                GSSCredential clientCreds = manager.createCredential(1);
                GSSName clientName = clientCreds.getName();
                this.datasource.setUser("\"" + clientName.toString().substring(0, clientName.toString().lastIndexOf(64)) + "\"");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (user == null && this.datasource.getUser() == null) {
            throw new SQLException("Invalid Username", "28000");
        }
        if (password == null && this.datasource.getPassword() == null) {
            throw new SQLException("Invalid Password", "28000");
        }
        if (user != null && !this.datasource.isClientKrbSSODelegated()) {
            this.datasource.setUser(user);
        }
        if (password != null && !this.datasource.isClientKrbSSODelegated()) {
            this.datasource.setPassword(password);
        }
        this.datasource.setUrl(this.url);
        this.isParsed = true;
        return true;
    }

    private boolean parseDSNProtocol() throws SQLException {
        int i;
        String temp = "\"";
        boolean dsn = true;
        boolean count = false;
        this.tempProtocol = this.tempProtocol.trim().substring(this.tempProtocol.trim().toLowerCase().indexOf("dsn=") + "dsn=".length());
        this.tempProtocol = this.tempProtocol.trim();
        for (i = 0; i < this.tempProtocol.length() && this.tempProtocol.charAt(i) == ' '; ++i) {
        }
        if (this.tempProtocol.charAt(i) == '\"') {
            temp = this.getNextDoubleQuoteToken();
            this.tempProtocol = this.tempProtocol.substring(this.tempProtocol.indexOf(temp) + temp.length());
            NzDatasource datasource1 = Driver.getDatasource(temp);
            if (datasource1 == null) {
                throw new SQLException("Datasource name not found '" + temp + "'.", "IM002");
            }
            datasource1.copyTo(this.datasource);
        } else {
            StringTokenizer dsnArr = new StringTokenizer(this.tempProtocol, "?&;");
            if (dsnArr.hasMoreTokens() && dsn) {
                temp = dsnArr.nextToken().trim();
                if (temp.trim().equals("")) {
                    throw new SQLException("Invalid URL format", "08001");
                }
                NzDatasource datasource1 = Driver.getDatasource(temp);
                if (datasource1 == null) {
                    throw new SQLException("Datasource name not found '" + temp + "'.", "IM002");
                }
                datasource1.copyTo(this.datasource);
                this.tempProtocol = this.tempProtocol.substring(this.tempProtocol.indexOf(temp) + temp.length());
                dsn = false;
            }
        }
        this.fillSecondPart(false, this.tempProtocol);
        return true;
    }

    private boolean parseHostDBProtocol() throws SQLException {
        String dbname;
        boolean isFirst;
        String hostname;
        block13: {
            int i;
            hostname = "";
            boolean ishostname = true;
            isFirst = true;
            dbname = "";
            String temp = "";
            while (this.tempProtocol.charAt(0) == '\"') {
                temp = this.getNextDoubleQuoteToken();
                this.tempProtocol = this.tempProtocol.substring(this.tempProtocol.indexOf(temp) + temp.length());
                if (ishostname) {
                    if (!this.tempProtocol.contains("/")) {
                        throw new SQLException("Invalid URL format", "08001");
                    }
                    hostname = this.tempProtocol.substring(0, this.tempProtocol.indexOf("/"));
                    if (!hostname.equals("") && hostname.trim().charAt(0) == ':') {
                        try {
                            this.datasource.setPort(Integer.parseInt(hostname.replace(":", "")));
                            this.tempProtocol = this.tempProtocol.substring(this.tempProtocol.indexOf(hostname) + hostname.length() + 1);
                            this.datasource.setHost(temp);
                            hostname = temp;
                            ishostname = false;
                            continue;
                        }
                        catch (NumberFormatException exception) {
                            throw new SQLException("Invalid value for port '" + this.tempProtocol.substring(0, this.tempProtocol.indexOf("/")) + "'.", "08001");
                        }
                    }
                    temp = temp + hostname;
                    this.datasource.setHost(temp);
                    hostname = temp;
                    ishostname = false;
                    this.tempProtocol = this.tempProtocol.substring(this.tempProtocol.indexOf("/") + 1);
                    continue;
                }
                dbname = temp;
                this.datasource.setDatabase(temp);
                isFirst = false;
                break block13;
            }
            if (ishostname) {
                temp = this.tempProtocol.substring(0, this.tempProtocol.indexOf("/"));
                String[] hostArr = temp.split(":");
                hostname = hostArr[0];
                this.datasource.setHost(hostArr[0]);
                if (hostArr.length > 1) {
                    try {
                        this.datasource.setPort(Integer.parseInt(hostArr[1]));
                    }
                    catch (NumberFormatException exception) {
                        throw new SQLException("Invalid value for port '" + hostArr[1] + "'.", "08001");
                    }
                }
                this.tempProtocol = this.tempProtocol.substring(this.tempProtocol.indexOf(temp) + temp.length() + 1);
            }
            if (this.tempProtocol.charAt(i = 0) == '\"') {
                dbname = temp = this.getNextDoubleQuoteToken();
                this.datasource.setDatabase(temp);
                isFirst = false;
                this.tempProtocol = this.tempProtocol.substring(this.tempProtocol.indexOf(temp) + temp.length());
            }
        }
        if (hostname.equals("")) {
            throw new SQLException("Invalid URL format", "08001");
        }
        if (!isFirst && dbname.equals("")) {
            throw new SQLException("Invalid URL format", "08001");
        }
        return this.fillSecondPart(isFirst, this.tempProtocol);
    }

    private String getNextDoubleQuoteToken() {
        String temp = "\"";
        for (int i = 1; i < this.tempProtocol.length(); ++i) {
            if (this.tempProtocol.charAt(i) != '\"') {
                temp = temp + this.tempProtocol.charAt(i);
                continue;
            }
            temp = temp + this.tempProtocol.charAt(i);
            break;
        }
        return temp;
    }

    private boolean fillSecondPart(boolean first, String tempURL) throws SQLException {
        StringTokenizer st = new StringTokenizer(tempURL, "?&;");
        String[] secondPart = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            if (first) {
                this.datasource.setDatabase(part);
                first = false;
                continue;
            }
            secondPart[count++] = part;
        }
        this.parsesSecondPart(secondPart, this.datasource);
        return true;
    }

    private boolean parseFirstPart(String part, NzDatasource dsnToUpdate) throws SQLException {
        String[] tokens = part.split("//|/");
        String protocol = null;
        block7: for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            switch (i) {
                case 0: {
                    String[] protocols = token.split(":");
                    if (protocols.length != 2 || !protocols[0].equals("jdbc") || !protocols[1].equals("netezza")) {
                        return false;
                    }
                    protocol = protocols[1];
                    continue block7;
                }
                case 1: {
                    String[] protocols;
                    if (token.indexOf(61) > 0) {
                        if (tokens.length >= 3) {
                            throw new SQLException("Invalid URL format", "08001");
                        }
                        protocols = token.split("=");
                        if (protocols.length != 2 || !protocols[0].equalsIgnoreCase("dsn")) {
                            throw new SQLException("Invalid URL format", "08001");
                        }
                        NzDatasource datasource = Driver.getDatasource(protocols[1]);
                        if (datasource == null) {
                            throw new SQLException("Datasource name not found '" + protocols[1] + "'.", "IM002");
                        }
                        datasource.copyTo(dsnToUpdate);
                        continue block7;
                    }
                    if (token.indexOf(58) >= 0) {
                        protocols = token.split(":");
                        if (protocols.length != 2) {
                            throw new SQLException("Invalid URL format", "08001");
                        }
                        dsnToUpdate.setHost(protocols[0]);
                        try {
                            dsnToUpdate.setPort(Integer.parseInt(protocols[1]));
                            continue block7;
                        }
                        catch (NumberFormatException exception) {
                            throw new SQLException("Invalid value for port '" + protocols[1] + "'.", "08001");
                        }
                    }
                    dsnToUpdate.setHost(token);
                    continue block7;
                }
                case 2: {
                    dsnToUpdate.setDatabase(token);
                    continue block7;
                }
                default: {
                    throw new SQLException("Invalid URL format", "08001");
                }
            }
        }
        dsnToUpdate.setProtocol(protocol);
        return true;
    }

    private void parsesSecondPart(String[] parts, NzDatasource dsnToupdate) throws SQLException {
        for (int i = 0; i < parts.length; ++i) {
            String[] property;
            String part = parts[i];
            if (part == null || (property = part.split("=")).length != 2) continue;
            String key = property[0];
            String value = property[1];
            if (key.equalsIgnoreCase("dsn")) {
                NzDatasource dsn = Driver.getDatasource(value);
                if (dsn == null) {
                    throw new SQLException("Datasource name not found '" + value + "'.", "IM002");
                }
                String host = dsnToupdate.getHost();
                int port = dsnToupdate.getPort();
                String database = dsnToupdate.getDatabase();
                String protocol = dsnToupdate.getProtocol();
                dsn.copyTo(dsnToupdate);
                dsnToupdate.setHost(host);
                dsnToupdate.setPort(port);
                dsnToupdate.setDatabase(database);
                dsnToupdate.setProtocol(protocol);
                continue;
            }
            Driver.setDatasourceProperty(dsnToupdate, key, value);
        }
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        properties.setProperty("user", "admin");
        properties.setProperty("password", "password");
        String[] urls = new String[]{"jdbc:netezza://localhost:8888/system?dsn=test;batchsize=100;logintimeout=10", "jdbc:netezza://dsn=test?batchsize=100;logintimeout=10"};
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("\n\nURL" + urls[i] + "\n");
            NzURL url = new NzURL(urls[i], properties);
            try {
                url.parse();
                System.out.println(url.getDatasource());
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

