/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.sql.SQLException;

public enum NzFeature {
    CROSS_DATABASE,
    CATALOG_API,
    SQL_IDENTIFIER_CASE,
    SCHEMA_WORKAROUND,
    STORED_PROCEDURE;

    private boolean enabled;

    public static void setFeature(byte feature) throws SQLException {
        switch (feature) {
            case 1: {
                NzFeature.CROSS_DATABASE.enabled = true;
                break;
            }
            case 2: {
                NzFeature.CATALOG_API.enabled = true;
                break;
            }
            case 4: {
                NzFeature.SQL_IDENTIFIER_CASE.enabled = true;
                break;
            }
            case 8: {
                NzFeature.SCHEMA_WORKAROUND.enabled = true;
                break;
            }
            case 16: {
                NzFeature.STORED_PROCEDURE.enabled = true;
                break;
            }
            default: {
                throw new SQLException("Backend Feature not supported by the driver");
            }
        }
    }

    public static void resetFeature(byte feature) throws SQLException {
        switch (feature) {
            case 1: {
                NzFeature.CROSS_DATABASE.enabled = false;
                break;
            }
            case 2: {
                NzFeature.CATALOG_API.enabled = false;
                break;
            }
            case 4: {
                NzFeature.SQL_IDENTIFIER_CASE.enabled = false;
                break;
            }
            case 8: {
                NzFeature.SCHEMA_WORKAROUND.enabled = false;
                break;
            }
            case 16: {
                NzFeature.STORED_PROCEDURE.enabled = false;
                break;
            }
            default: {
                throw new SQLException("Backend Feature not supported by the driver");
            }
        }
    }

    public boolean isSet() {
        return this.enabled;
    }
}

