/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.netezza.error.NzSQLException;

public class NzPooledConnection
implements PooledConnection,
InvocationHandler {
    private LinkedList<ConnectionEventListener> listeners = new LinkedList();
    private final Connection connection;

    public NzPooledConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void close() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection.close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection.isClosed()) {
            throw new SQLException("The physical connection is already closed.");
        }
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)this);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(this.listeners);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name == null) {
            return null;
        }
        if (method.getName().equals("toString")) {
            return "Pooled connection wrapping physical connection " + this.connection;
        }
        if (method.getName().equals("hashCode")) {
            return this.connection.hashCode();
        }
        if (method.getName().equals("equals")) {
            if (args[0] == null) {
                return false;
            }
            try {
                return Proxy.isProxyClass(args[0].getClass()) && ((NzPooledConnection)Proxy.getInvocationHandler((Object)args[0])).connection == this.connection;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        if (method.getName().equals("close")) {
            SQLException ex = null;
            if (!this.connection.getAutoCommit()) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException e) {
                    ex = e;
                }
            }
            this.connection.clearWarnings();
            this.fireConnectionClosed();
            if (ex != null) {
                throw ex;
            }
            return null;
        }
        try {
            return method.invoke((Object)this.connection, args);
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof SQLException) {
                this.fireConnectionErrorOccurred((SQLException)t);
                throw t;
            }
            NzSQLException sqlEx = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.fireConnectionErrorOccurred(sqlEx);
            throw sqlEx;
        }
    }

    private void fireConnectionClosed() {
        ConnectionEvent evt = new ConnectionEvent(this);
        int length = this.listeners.size();
        for (int i = 0; i < length; ++i) {
            this.listeners.get(i).connectionClosed(evt);
        }
    }

    private void fireConnectionErrorOccurred(SQLException sqlEx) {
        ConnectionEvent evt = new ConnectionEvent(this, sqlEx);
        int length = this.listeners.size();
        for (int i = 0; i < length; ++i) {
            this.listeners.get(i).connectionErrorOccurred(evt);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }
}

