/*
 * Decompiled with CFR 0.152.
 */
package waffle.util.cache;

import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.util.cache.CacheSupplier;
import waffle.util.cache.CaffeineCache;

public interface Cache<K, V> {
    public static <K, V> Cache<K, V> newCache(int timeout) throws NoSuchElementException {
        NoSuchElementException exception = new NoSuchElementException();
        boolean cacheSupplierFound = false;
        for (CacheSupplier cacheSupplier : ServiceLoader.load(CacheSupplier.class)) {
            cacheSupplierFound = true;
            try {
                return cacheSupplier.newCache(timeout);
            }
            catch (Exception e) {
                exception.addSuppressed(e);
            }
        }
        if (!cacheSupplierFound) {
            Logger logger = LoggerFactory.getLogger(Cache.class);
            logger.error("No CacheSupplier implementation found by ServiceLoader. Please see https://github.com/Waffle/waffle/blob/master/Docs/faq/CustomCache.md for possible solutions. Falling back to default CaffeineCache implementation.", (Throwable)exception);
            return new CaffeineCache(timeout);
        }
        throw exception;
    }

    public V get(K var1);

    public void put(K var1, V var2);

    public void remove(K var1);

    public int size();
}

