/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.ui;

import com.dbeaver.db.bigquery.BigQueryConstantsPro;
import com.dbeaver.db.bigquery.model.BigQueryDialect;
import com.dbeaver.db.bigquery.ui.BigQueryMessages;
import java.util.ArrayList;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.ext.bigquery.ui.views.BigQueryConnectionPage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.utils.CommonUtils;

public class BigQueryConnectionPagePro
extends BigQueryConnectionPage {
    private Group advancedSettings;
    private Combo queryDialectCombo;
    private Control infoLabel;
    private Button enableSession;
    private Label locationLabel;
    private Combo locationCombo;

    protected void createAdditionalControls(Composite settingsGroup) {
        this.advancedSettings = UIUtils.createControlGroup((Composite)settingsGroup, (String)BigQueryMessages.connection_page_group_advanced_settings, (int)3, (int)768, (int)-1);
        this.advancedSettings.setLayoutData((Object)new GridData(768));
        this.queryDialectCombo = UIUtils.createLabelCombo((Composite)this.advancedSettings, (String)BigQueryMessages.connection_page_query_dialect_label, (String)BigQueryMessages.connection_page_query_dialect_tip, (int)12);
        this.queryDialectCombo.setLayoutData((Object)new GridData(32));
        BigQueryDialect[] bigQueryDialectArray = BigQueryDialect.values();
        int n = bigQueryDialectArray.length;
        int n2 = 0;
        while (n2 < n) {
            BigQueryDialect dialect = bigQueryDialectArray[n2];
            this.queryDialectCombo.add(dialect.getDisplayName());
            ++n2;
        }
        this.queryDialectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BigQueryConnectionPagePro.this.updateDialectHintVisibility();
            }
        });
        this.infoLabel = UIUtils.createWarningLabel((Composite)this.advancedSettings, (String)"Legacy dialect doesn't support many system features", (int)768, (int)1);
        this.updateDialectHintVisibility();
        this.addSessionModeComponents(UIUtils.createFormPlaceholder((Composite)this.advancedSettings, (int)4, (int)3));
        this.updateLocationVisibility();
    }

    private void addSessionModeComponents(Composite composite) {
        this.enableSession = UIUtils.createCheckbox((Composite)composite, (String)BigQueryMessages.connection_page_enable_session, (String)BigQueryMessages.connection_page_enable_session_tip, (boolean)false, (int)1);
        this.enableSession.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BigQueryConnectionPagePro.this.updateLocationVisibility();
            }
        });
        this.locationLabel = UIUtils.createControlLabel((Composite)composite, (String)BigQueryMessages.connection_page_session_location);
        this.locationLabel.setToolTipText(BigQueryMessages.connection_page_session_location_tip);
        GridData locationLabelLayoutData = new GridData(128);
        locationLabelLayoutData.horizontalIndent = 20;
        this.locationLabel.setLayoutData((Object)locationLabelLayoutData);
        this.locationCombo = new Combo(composite, 4);
        this.locationCombo.setToolTipText(BigQueryMessages.connection_page_session_location_tip);
        this.locationCombo.setLayoutData((Object)new GridData(32));
        String[] stringArray = BigQueryConstantsPro.LOCATIONS;
        int n = BigQueryConstantsPro.LOCATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            this.locationCombo.add(location);
            ++n2;
        }
        IContentProposalProvider proposalProvider = (contents, position) -> {
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            String[] stringArray = this.locationCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.toLowerCase().contains(contents.toLowerCase())) {
                    proposals.add(new ContentProposal(item));
                }
                ++n2;
            }
            return (IContentProposal[])proposals.toArray(IContentProposal[]::new);
        };
        ContentAssistUtils.installContentProposal((Control)this.locationCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)proposalProvider);
    }

    private void updateLocationVisibility() {
        UIUtils.setControlVisible((Control)this.locationCombo, (boolean)this.enableSession.getSelection());
        UIUtils.setControlVisible((Control)this.locationLabel, (boolean)this.enableSession.getSelection());
        this.advancedSettings.getParent().layout(true, true);
    }

    private void updateDialectHintVisibility() {
        boolean needToShowHint = this.queryDialectCombo.getSelectionIndex() != 0;
        UIUtils.setControlVisible((Control)this.infoLabel, (boolean)needToShowHint);
        this.infoLabel.getParent().layout(true, true);
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.queryDialectCombo.setText(((BigQueryDialect)CommonUtils.valueOf(BigQueryDialect.class, (String)connectionInfo.getProperty("QueryDialect"), (Enum)BigQueryConstantsPro.DEFAULT_DIALECT)).getDisplayName());
        this.updateDialectHintVisibility();
        this.enableSession.setSelection("1".equals(CommonUtils.toString((Object)connectionInfo.getProperty("EnableSession"))));
        this.locationCombo.setText(CommonUtils.toString((Object)connectionInfo.getProperty("Location"), (String)""));
        this.updateLocationVisibility();
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setProperty("QueryDialect", ((BigQueryDialect)CommonUtils.fromOrdinal(BigQueryDialect.class, (int)this.queryDialectCombo.getSelectionIndex())).toString());
        if (this.enableSession.getSelection()) {
            connectionInfo.setProperty("EnableSession", "1");
            if (!this.locationCombo.getText().isBlank()) {
                connectionInfo.setProperty("Location", this.locationCombo.getText());
            } else {
                connectionInfo.removeProperty("Location");
            }
        } else {
            connectionInfo.removeProperty("EnableSession");
            connectionInfo.removeProperty("Location");
        }
        super.saveSettings(dataSource);
    }
}

