/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc.bridge;

import com.dbeaver.jdbc.odbc.OdbcException;
import com.dbeaver.jdbc.odbc.bridge.OdbcHandle;
import com.dbeaver.jdbc.odbc.bridge.OdbcObject;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcUtil;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class OdbcResource<HANDLE extends OdbcHandle>
extends OdbcObject
implements AutoCloseable {
    protected final OdbcResource<?> parent;
    protected final HANDLE handle;
    protected SQLWarning warnings;

    public OdbcResource(@Nullable OdbcResource<?> parent, @NotNull HANDLE handle) {
        this.parent = parent;
        this.handle = handle;
        this.warnings = null;
    }

    @NotNull
    public Object getParent() {
        return Objects.requireNonNull(this.parent, "Object has no parent");
    }

    @NotNull
    public HANDLE getHandle() {
        return this.handle;
    }

    @Nullable
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.ensureOpen();
        this.warnings = null;
    }

    public void addWarning() throws SQLException {
        this.ensureOpen();
        SQLException exception = OdbcUtil.diagnose(this.handle);
        if (exception instanceof OdbcException) {
            OdbcException oe = (OdbcException)exception;
            this.addWarning(oe.toWarning());
        }
    }

    public void addWarning(@NotNull SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    public void ensureOpen() throws SQLException {
        if (this.isClosed()) {
            throw new OdbcException("Resource is closed");
        }
        if (this.parent != null) {
            this.parent.ensureOpen();
        }
    }

    public boolean isClosed() {
        return ((OdbcHandle)this.handle).isClosed() || this.parent != null && this.parent.isClosed();
    }

    @Override
    public void close() throws SQLException {
        ((OdbcHandle)this.handle).close();
    }
}

