/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc;

import com.dbeaver.jdbc.model.AbstractJdbcResultSet;
import com.dbeaver.jdbc.model.AbstractJdbcResultSetMetaData;
import com.dbeaver.jdbc.model.AbstractJdbcStatement;
import com.dbeaver.jdbc.odbc.JdbcOdbcResultSetMetaData;
import com.dbeaver.jdbc.odbc.JdbcOdbcStatement;
import com.dbeaver.jdbc.odbc.OdbcException;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.struct.OdbcDate;
import com.dbeaver.jdbc.odbc.bridge.struct.OdbcTime;
import com.dbeaver.jdbc.odbc.bridge.struct.OdbcTimestamp;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcUtil;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.ShortByReference;
import java.io.ByteArrayOutputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class JdbcOdbcResultSet
extends AbstractJdbcResultSet<JdbcOdbcStatement, JdbcOdbcResultSetMetaData> {
    private static final int DATA_BUFFER_SIZE = 1024;
    private final Object[] cachedRow;
    private boolean wasNull;
    private boolean closed;
    private boolean orphan;

    public JdbcOdbcResultSet(@NotNull JdbcOdbcStatement statement, @NotNull JdbcOdbcResultSetMetaData metadata) throws SQLException {
        this(statement, metadata, false);
    }

    public JdbcOdbcResultSet(@NotNull JdbcOdbcStatement statement, @NotNull JdbcOdbcResultSetMetaData metadata, boolean orphan) throws SQLException {
        super((AbstractJdbcStatement)statement, (AbstractJdbcResultSetMetaData)metadata);
        this.cachedRow = new Object[statement.getColumnCount()];
        this.orphan = orphan;
        if (statement.getLargeMaxRows() > 0L) {
            statement.setAttrLong((short)1, statement.getLargeMaxRows());
        }
    }

    public JdbcOdbcResultSet(@NotNull JdbcOdbcStatement statement) throws SQLException {
        this(statement, new JdbcOdbcResultSetMetaData(statement, null, null), false);
    }

    public JdbcOdbcResultSet(@NotNull JdbcOdbcStatement statement, boolean orphan) throws SQLException {
        this(statement, new JdbcOdbcResultSetMetaData(statement, null, null), orphan);
    }

    public boolean next() throws SQLException {
        ((JdbcOdbcStatement)this.statement).ensureOpen();
        Arrays.fill(this.cachedRow, null);
        Memory fetchedRows = new Memory(1024L);
        OdbcLibrary.INSTANCE.SQLSetStmtAttrW(((JdbcOdbcStatement)this.statement).getHandle(), 26, (Pointer)fetchedRows, 0);
        short rc = OdbcLibrary.INSTANCE.SQLFetchScroll(((JdbcOdbcStatement)this.statement).getHandle(), (short)1, (short)0);
        if (rc == 100) {
            return false;
        }
        OdbcUtil.check(((JdbcOdbcStatement)this.statement).getResource(), rc);
        this.clearWarnings();
        return true;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getString(int columnIndex) throws SQLException {
        return this.getVariableData(columnIndex, (short)-8, String.class, StringBuilder::new, StringBuilder::append, StringBuilder::toString, (mem, len) -> mem.getWideString(0L));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Byte result = this.getSizedData(columnIndex, -7, Byte.class, ByteByReference::new, ByteByReference::getValue);
        return result != null && result > 0;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Byte result = this.getSizedData(columnIndex, -26, Byte.class, ByteByReference::new, ByteByReference::getValue);
        return result != null ? result : (byte)0;
    }

    public short getShort(int columnIndex) throws SQLException {
        Short result = this.getSizedData(columnIndex, -15, Short.class, ShortByReference::new, ShortByReference::getValue);
        return result != null ? result : (short)0;
    }

    public int getInt(int columnIndex) throws SQLException {
        Integer result = this.getSizedData(columnIndex, -16, Integer.class, IntByReference::new, IntByReference::getValue);
        return result != null ? result : 0;
    }

    public long getLong(int columnIndex) throws SQLException {
        try {
            Long result = this.getSizedData(columnIndex, -25, Long.class, LongByReference::new, LongByReference::getValue);
            return result != null ? result : 0L;
        }
        catch (SQLException sQLException) {
            return this.getInt(columnIndex);
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        Float result = this.getSizedData(columnIndex, 6, Float.class, FloatByReference::new, FloatByReference::getValue);
        return result != null ? result.floatValue() : 0.0f;
    }

    public double getDouble(int columnIndex) throws SQLException {
        Double result = this.getSizedData(columnIndex, 8, Double.class, DoubleByReference::new, DoubleByReference::getValue);
        return result != null ? result : 0.0;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getVariableData(columnIndex, (short)-2, byte[].class, ByteArrayOutputStream::new, ByteArrayOutputStream::writeBytes, ByteArrayOutputStream::toByteArray, (mem, len) -> mem.getByteArray(0L, len.intValue()));
    }

    public SQLWarning getWarnings() throws SQLException {
        return ((JdbcOdbcStatement)this.statement).getWarnings();
    }

    public void clearWarnings() throws SQLException {
        ((JdbcOdbcStatement)this.statement).clearWarnings();
    }

    public Object getObject(int columnIndex) throws SQLException {
        int type = ((JdbcOdbcResultSetMetaData)this.metadata).getColumnType(columnIndex);
        switch (type) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -6: {
                return this.getByte(columnIndex);
            }
            case 5: {
                return this.getShort(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 6: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return this.getDouble(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case -360: {
                return this.getBigDecimal(columnIndex);
            }
        }
        throw new OdbcException("Can't determine Java type for SQL type " + type);
    }

    public int findColumn(String columnLabel) throws SQLException {
        return ((JdbcOdbcResultSetMetaData)this.metadata).findColumn(columnLabel);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.getParent().setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.getParent().getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.getParent().setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.getParent().getFetchSize();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        OdbcDate result = this.getSizedData(columnIndex, 91, OdbcDate.class, OdbcDate::new);
        if (result == null) {
            return null;
        }
        cal.set(1, result.year);
        cal.set(2, result.month - 1);
        cal.set(5, result.day);
        return new Date(cal.getTimeInMillis());
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        OdbcTime result = this.getSizedData(columnIndex, 92, OdbcTime.class, OdbcTime::new);
        if (result == null) {
            return null;
        }
        cal.set(11, result.hour);
        cal.set(12, result.minute);
        cal.set(13, result.second);
        return new Time(cal.getTimeInMillis());
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        OdbcTimestamp result = this.getSizedData(columnIndex, 93, OdbcTimestamp.class, OdbcTimestamp::new);
        if (result == null) {
            return null;
        }
        cal.set(1, result.date.year);
        cal.set(2, result.date.month - 1);
        cal.set(5, result.date.day);
        cal.set(11, result.time.hour);
        cal.set(12, result.time.minute);
        cal.set(13, result.time.second);
        cal.set(14, result.fraction / 1000000);
        return new Timestamp(cal.getTimeInMillis());
    }

    @NotNull
    public JdbcOdbcStatement getParent() {
        return (JdbcOdbcStatement)this.statement;
    }

    public boolean isClosed() {
        return this.closed || ((JdbcOdbcStatement)this.statement).getHandle().isClosed();
    }

    public void close() throws SQLException {
        if (!this.closed && this.orphan) {
            ((JdbcOdbcStatement)this.getStatement()).close();
        }
        this.closed = true;
    }

    @Nullable
    private <R extends Structure> R getSizedData(int columnIndex, int targetType, @NotNull Class<R> type, @NotNull Supplier<R> supplier) throws SQLException {
        ((JdbcOdbcStatement)this.statement).ensureOpen();
        this.ensureColumn(columnIndex);
        Object cachedValue = this.cachedRow[columnIndex - 1];
        if (cachedValue != null) {
            if (cachedValue == NULL_MARKER) {
                return null;
            }
            if (type.isInstance(cachedValue)) {
                return (R)((Structure)type.cast(cachedValue));
            }
        }
        Structure container = (Structure)supplier.get();
        LongByReference length = new LongByReference();
        OdbcUtil.check(((JdbcOdbcStatement)this.statement).getResource(), OdbcLibrary.INSTANCE.SQLGetData(((JdbcOdbcStatement)this.getStatement()).getHandle(), (short)columnIndex, (short)targetType, container, (long)container.size(), length));
        if (length.getValue() == -1L) {
            this.wasNull = true;
            this.cachedRow[columnIndex - 1] = NULL_MARKER;
            return null;
        }
        this.wasNull = false;
        this.cachedRow[columnIndex - 1] = container;
        return (R)container;
    }

    @Nullable
    private <T extends ByReference, R> R getSizedData(int columnIndex, int targetType, @NotNull Class<R> type, @NotNull Supplier<T> supplier, @NotNull Function<T, R> extractor) throws SQLException {
        ((JdbcOdbcStatement)this.statement).ensureOpen();
        this.ensureColumn(columnIndex);
        Object cachedValue = this.cachedRow[columnIndex - 1];
        if (cachedValue != null) {
            if (cachedValue == NULL_MARKER) {
                return null;
            }
            if (type.isInstance(cachedValue)) {
                return type.cast(cachedValue);
            }
        }
        ByReference container = (ByReference)supplier.get();
        LongByReference length = new LongByReference();
        OdbcUtil.check(((JdbcOdbcStatement)this.getStatement()).getResource(), OdbcLibrary.INSTANCE.SQLGetData(this.getParent().getHandle(), (short)columnIndex, (short)targetType, container, 0, length));
        if (length.getValue() == -1L) {
            this.wasNull = true;
            this.cachedRow[columnIndex - 1] = NULL_MARKER;
            return null;
        }
        R output = extractor.apply(container);
        this.wasNull = false;
        this.cachedRow[columnIndex - 1] = output;
        return output;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T, V, R> R getVariableData(int columnIndex, short targetType, @NotNull Class<R> type, @NotNull Supplier<T> creator, @NotNull BiConsumer<T, V> accumulator, @NotNull Function<T, R> finalizer, @NotNull BiFunction<Memory, Integer, V> extractor) throws SQLException {
        ((JdbcOdbcStatement)this.statement).ensureOpen();
        this.ensureColumn(columnIndex);
        Object cachedValue = this.cachedRow[columnIndex - 1];
        if (cachedValue != null) {
            if (cachedValue == NULL_MARKER) {
                return null;
            }
            if (type.isInstance(cachedValue)) {
                return type.cast(cachedValue);
            }
        }
        LongByReference length = new LongByReference();
        T container = creator.get();
        Throwable throwable = null;
        Object var13_13 = null;
        try (Memory buffer = new Memory(1024L);){
            int rc = OdbcLibrary.INSTANCE.SQLGetData(this.getParent().getHandle(), (short)columnIndex, targetType, (Pointer)buffer, 1024L, length);
            if (rc != 100) {
                OdbcUtil.check(((JdbcOdbcStatement)this.getStatement()).getResource(), rc);
            }
            if (rc == 0 && length.getValue() < 0L) {
                rc = -1;
            }
            if (rc == 1 || rc == 0) {
                int remaining;
                switch ((int)length.getValue()) {
                    case -1: {
                        this.wasNull = true;
                        return null;
                    }
                    case -4: {
                        remaining = (int)buffer.size();
                        break;
                    }
                    default: {
                        remaining = (int)length.getValue();
                    }
                }
                accumulator.accept(container, extractor.apply(buffer, Math.min(remaining, 1024)));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void ensureColumn(int index) throws SQLException {
        int count = ((JdbcOdbcResultSetMetaData)this.metadata).getColumnCount();
        if (index <= 0 || index > count) {
            throw new SQLException("Column " + index + " out of bounds [1, " + count + "]");
        }
    }
}

