/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.cloud;

import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;

public abstract class AuthModelCloudConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private static final Log log = Log.getLog(AuthModelCloudConfigurator.class);
    private IObjectPropertyConfigurator<AuthModelCloudConfigurator, DBPDataSourceContainer> cloudConfigurator;
    protected boolean isCloudProvided;

    public AuthModelCloudConfigurator() {
        UIPropertyConfiguratorDescriptor pcd = UIPropertyConfiguratorRegistry.getInstance().getDescriptor((Object)this);
        if (pcd != null) {
            try {
                this.cloudConfigurator = pcd.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)"Error creating configurator for cloud auth model", (Throwable)e);
            }
        }
    }

    public boolean isCloudProvided() {
        return this.isCloudProvided;
    }

    public void setCloudProvided(boolean cloudProvided) {
        this.isCloudProvided = cloudProvided;
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        boolean bl = this.isCloudProvided = !"local".equals(dataSource.getOrigin().getType());
        if (this.cloudConfigurator != null) {
            this.cloudConfigurator.loadSettings((Object)dataSource);
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (this.cloudConfigurator != null) {
            this.cloudConfigurator.saveSettings((Object)dataSource);
        }
    }

    protected void createCloudConfig(@NotNull Composite parent) {
        if (this.cloudConfigurator != null) {
            this.cloudConfigurator.createControl(parent, (Object)this, () -> {});
        }
    }
}

