/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.OperationKind;
import com.azure.cosmos.implementation.Resource;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosConflictProperties {
    private Conflict conflict;

    CosmosConflictProperties() {
        this.conflict = new Conflict();
    }

    CosmosConflictProperties(ObjectNode jsonNode) {
        this.conflict = new Conflict(jsonNode);
    }

    public OperationKind getOperationKind() {
        return this.conflict.getOperationKind();
    }

    String getResourceType() {
        return this.conflict.getResourceType();
    }

    Resource getResource() {
        return this.conflict;
    }

    public <T> T getItem(Class<T> klass) {
        return this.conflict.getItem(klass);
    }

    public String getId() {
        return this.conflict.getId();
    }

    public CosmosConflictProperties setId(String id) {
        this.conflict.setId(id);
        return this;
    }

    String getResourceId() {
        return this.conflict.getResourceId();
    }

    public Instant getTimestamp() {
        return this.conflict.getTimestamp();
    }

    public String getETag() {
        return this.conflict.getETag();
    }

    static List<CosmosConflictProperties> getFromV2Results(List<Conflict> results) {
        return results.stream().map(conflict -> new CosmosConflictProperties(conflict.getPropertyBag())).collect(Collectors.toList());
    }
}

