/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.models.SqlQuerySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQuerySpecLogger {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final SqlQuerySpecLogger INSTANCE = new SqlQuerySpecLogger(LoggerFactory.getLogger(SqlQuerySpecLogger.class));
    private final Logger logger;

    public static SqlQuerySpecLogger getInstance() {
        return INSTANCE;
    }

    SqlQuerySpecLogger(Logger logger) {
        this.logger = logger;
    }

    private static String toPrettyString(SqlQuerySpec query) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(query.getQueryText());
        query.getParameters().forEach(p -> sb.append(LINE_SEPARATOR).append(" > param: ").append(p.getName()).append(" = ").append(p.getValue(Object.class)));
        return sb.toString();
    }

    public void logQuery(SqlQuerySpec querySpec) {
        if (this.logger.isTraceEnabled() && !querySpec.getParameters().isEmpty()) {
            this.logger.debug(SqlQuerySpecLogger.toPrettyString(querySpec));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(querySpec.getQueryText());
        }
    }
}

