/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.util.tracing.ProcessKind;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.CosmosDiagnosticsHandler;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.DiagnosticsProviderJvmFatalErrorMapper;
import com.azure.cosmos.implementation.FeedOperationState;
import com.azure.cosmos.implementation.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.directconnectivity.StoreResponseDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.StoreResultDiagnostics;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava25.base.Splitter;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosClientTelemetryConfig;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ShowQueryMode;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class DiagnosticsProvider {
    private static final ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.CosmosClientTelemetryConfigAccessor clientTelemetryConfigAccessor = ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor();
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.CosmosDiagnosticsContextAccessor ctxAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.getCosmosDiagnosticsContextAccessor();
    private static final ImplementationBridgeHelpers.CosmosAsyncClientHelper.CosmosAsyncClientAccessor clientAccessor = ImplementationBridgeHelpers.CosmosAsyncClientHelper.getCosmosAsyncClientAccessor();
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor diagnosticsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor();
    private static final ImplementationBridgeHelpers.CosmosBatchResponseHelper.CosmosBatchResponseAccessor cosmosBatchResponseAccessor = ImplementationBridgeHelpers.CosmosBatchResponseHelper.getCosmosBatchResponseAccessor();
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticsProvider.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String COSMOS_CALL_DEPTH = "cosmosCallDepth";
    public static final String COSMOS_CALL_DEPTH_VAL = "nested";
    public static final int ERROR_CODE = 0;
    public static final String RESOURCE_PROVIDER_NAME = "Microsoft.DocumentDB";
    public static final String DB_TYPE_VALUE = "Cosmos";
    public static final String DB_TYPE = "db.type";
    public static final String LEGACY_DB_URL = "db.url";
    public static final String LEGACY_DB_STATEMENT = "db.statement";
    public static final String LEGACY_DB_INSTANCE = "db.instance";
    private static final Duration FEED_RESPONSE_CONSUMER_LATENCY_THRESHOLD = Duration.ofMillis(5L);
    private static final String REACTOR_TRACING_CONTEXT_KEY = "tracing-context";
    private static final String COSMOS_DIAGNOSTICS_CONTEXT_KEY = "azure-cosmos-context";
    private static final Object DUMMY_VALUE = new Object();
    private final Mono<Object> propagatingMono;
    private final Flux<Object> propagatingFlux;
    private final ArrayList<CosmosDiagnosticsHandler> diagnosticHandlers;
    private final Tracer tracer;
    private final CosmosTracer cosmosTracer;
    private final CosmosClientTelemetryConfig telemetryConfig;
    private final boolean shouldSystemExitOnError;
    private final AtomicLong diagnosticsHandlerFailures = new AtomicLong(0L);
    final Supplier<Double> samplingRateSnapshotSupplier;

    public DiagnosticsProvider(CosmosClientTelemetryConfig clientTelemetryConfig, String clientId, String userAgent, ConnectionMode connectionMode) {
        Preconditions.checkNotNull(clientTelemetryConfig, "Argument 'clientTelemetryConfig' must not be null.");
        Preconditions.checkNotNull(clientId, "Argument 'clientId' must not be null.");
        Preconditions.checkNotNull(userAgent, "Argument 'userAgent' must not be null.");
        Preconditions.checkNotNull(connectionMode, "Argument 'connectionMode' must not be null.");
        this.telemetryConfig = clientTelemetryConfig;
        this.samplingRateSnapshotSupplier = () -> this.isEnabled() ? clientTelemetryConfigAccessor.getSamplingRate(this.telemetryConfig) : 0.0;
        this.diagnosticHandlers = new ArrayList<CosmosDiagnosticsHandler>(clientTelemetryConfigAccessor.getDiagnosticHandlers(clientTelemetryConfig));
        Tracer tracerCandidate = clientTelemetryConfigAccessor.getOrCreateTracer(clientTelemetryConfig);
        this.tracer = tracerCandidate.isEnabled() ? tracerCandidate : (!this.diagnosticHandlers.isEmpty() ? EnabledNoOpTracer.INSTANCE : tracerCandidate);
        this.cosmosTracer = this.tracer.isEnabled() ? (clientTelemetryConfigAccessor.isLegacyTracingEnabled(clientTelemetryConfig) ? new LegacyCosmosTracer(this.tracer) : new OpenTelemetryCosmosTracer(this.tracer, clientTelemetryConfig, clientId, userAgent, connectionMode.name().toLowerCase(Locale.ROOT))) : null;
        this.propagatingMono = new PropagatingMono();
        this.propagatingFlux = new PropagatingFlux();
        this.shouldSystemExitOnError = Configs.shouldDiagnosticsProviderSystemExitOnError();
    }

    public boolean isEnabled() {
        return this.tracer.isEnabled();
    }

    public boolean isRealTracer() {
        return this.tracer.isEnabled() && this.tracer != EnabledNoOpTracer.INSTANCE;
    }

    public String getTraceConfigLog() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isEnabled());
        sb.append(", ");
        sb.append(this.isRealTracer());
        sb.append(", ");
        sb.append(this.tracer.getClass().getCanonicalName());
        if (!this.diagnosticHandlers.isEmpty()) {
            sb.append(", [");
            for (int i = 0; i < this.diagnosticHandlers.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.diagnosticHandlers.get(i).getClass().getCanonicalName());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public CosmosClientTelemetryConfig getClientTelemetryConfig() {
        return this.telemetryConfig;
    }

    public static com.azure.core.util.Context getContextFromReactorOrNull(ContextView reactorContext) {
        Object context = reactorContext.getOrDefault((Object)REACTOR_TRACING_CONTEXT_KEY, null);
        if (context instanceof com.azure.core.util.Context) {
            return (com.azure.core.util.Context)context;
        }
        return null;
    }

    public long getDiagnosticHandlerFailuresSnapshot() {
        return this.diagnosticsHandlerFailures.get();
    }

    public static Context setContextInReactor(com.azure.core.util.Context traceContext) {
        return Context.of((Object)REACTOR_TRACING_CONTEXT_KEY, (Object)traceContext);
    }

    public com.azure.core.util.Context startSpan(String spanName, CosmosDiagnosticsContext cosmosCtx, com.azure.core.util.Context context, boolean isSampledOut) {
        Preconditions.checkNotNull(spanName, "Argument 'spanName' must not be null.");
        Preconditions.checkNotNull(cosmosCtx, "Argument 'cosmosCtx' must not be null.");
        ctxAccessor.startOperation(cosmosCtx);
        com.azure.core.util.Context local = Objects.requireNonNull(context, "'context' cannot be null.").addData((Object)COSMOS_DIAGNOSTICS_CONTEXT_KEY, (Object)cosmosCtx);
        if (this.cosmosTracer == null || isSampledOut) {
            return local;
        }
        return this.cosmosTracer.startSpan(spanName, cosmosCtx, local);
    }

    public <T> void endSpan(Signal<T> signal, CosmosDiagnosticsContext cosmosCtx, int statusCode, Integer actualItemCount, Double requestCharge, Long opCountPerEvaluation, Long opRetriedCountPerEvaluation, Long globalOpCount, Integer targetMaxMicroBatchSize, CosmosDiagnostics diagnostics, boolean isSampledOut) {
        try {
            this.endSpanCore(signal, cosmosCtx, statusCode, actualItemCount, requestCharge, opCountPerEvaluation, opRetriedCountPerEvaluation, globalOpCount, targetMaxMicroBatchSize, diagnostics, isSampledOut);
        }
        catch (Throwable error) {
            this.handleErrors(error, 9901);
        }
    }

    private <T> void endSpanCore(Signal<T> signal, CosmosDiagnosticsContext cosmosCtx, int statusCode, Integer actualItemCount, Double requestCharge, Long opCountPerEvaluation, Long opRetriedCountPerEvaluation, Long globalOpCount, Integer targetMaxMicroBatchSize, CosmosDiagnostics diagnostics, boolean isSampledOut) {
        Objects.requireNonNull(signal, "'signal' cannot be null.");
        com.azure.core.util.Context context = DiagnosticsProvider.getContextFromReactorOrNull(signal.getContextView());
        if (context == null) {
            return;
        }
        switch (signal.getType()) {
            case ON_COMPLETE: {
                this.end(cosmosCtx, statusCode, 0, actualItemCount, requestCharge, opCountPerEvaluation, opRetriedCountPerEvaluation, globalOpCount, targetMaxMicroBatchSize, diagnostics, null, context, ctxAccessor.isEmptyCompletion(cosmosCtx), isSampledOut);
                break;
            }
            case ON_NEXT: {
                this.end(cosmosCtx, statusCode, 0, actualItemCount, requestCharge, opCountPerEvaluation, opRetriedCountPerEvaluation, globalOpCount, targetMaxMicroBatchSize, diagnostics, null, context, false, isSampledOut);
                break;
            }
            case ON_ERROR: {
                Throwable throwable = null;
                int subStatusCode = 0;
                Double effectiveRequestCharge = requestCharge;
                CosmosDiagnostics effectiveDiagnostics = diagnostics;
                if (signal.hasError() && (throwable = signal.getThrowable()) instanceof CosmosException) {
                    CosmosException exception = (CosmosException)((Object)throwable);
                    statusCode = exception.getStatusCode();
                    subStatusCode = exception.getSubStatusCode();
                    effectiveRequestCharge = effectiveRequestCharge != null ? Double.valueOf(effectiveRequestCharge + exception.getRequestCharge()) : Double.valueOf(exception.getRequestCharge());
                    effectiveDiagnostics = exception.getDiagnostics();
                    if (effectiveDiagnostics != null) {
                        diagnosticsAccessor.isDiagnosticsCapturedInPagedFlux(effectiveDiagnostics).set(true);
                    }
                }
                this.end(cosmosCtx, statusCode, subStatusCode, actualItemCount, effectiveRequestCharge, opCountPerEvaluation, opRetriedCountPerEvaluation, globalOpCount, targetMaxMicroBatchSize, effectiveDiagnostics, throwable, context, false, isSampledOut);
                break;
            }
        }
    }

    public void endSpan(CosmosDiagnosticsContext cosmosCtx, com.azure.core.util.Context context, Throwable throwable, boolean isSampledOut) {
        try {
            int statusCode = 0;
            int subStatusCode = 0;
            Double effectiveRequestCharge = null;
            CosmosDiagnostics effectiveDiagnostics = null;
            if (throwable instanceof CosmosException) {
                CosmosException exception = (CosmosException)((Object)throwable);
                statusCode = exception.getStatusCode();
                subStatusCode = exception.getSubStatusCode();
                effectiveRequestCharge = exception.getRequestCharge();
                effectiveDiagnostics = exception.getDiagnostics();
            }
            this.end(cosmosCtx, statusCode, subStatusCode, null, effectiveRequestCharge, 0L, 0L, 0L, 0, effectiveDiagnostics, throwable, context, false, isSampledOut);
        }
        catch (Throwable error) {
            this.handleErrors(error, 9905);
        }
    }

    public void endSpan(CosmosDiagnosticsContext cosmosCtx, com.azure.core.util.Context context, boolean isForcedEmptyCompletion, boolean isSampledOut) {
        try {
            this.end(cosmosCtx, 200, 0, null, null, 0L, 0L, 0L, 0, null, null, context, isForcedEmptyCompletion, isSampledOut);
        }
        catch (Throwable error) {
            this.handleErrors(error, 9904);
        }
    }

    public void recordPage(CosmosDiagnosticsContext cosmosCtx, CosmosDiagnostics diagnostics, Integer actualItemCount, Double requestCharge) {
        try {
            this.recordPageCore(cosmosCtx, diagnostics, actualItemCount, requestCharge);
        }
        catch (Throwable error) {
            this.handleErrors(error, 9902);
        }
    }

    private void recordPageCore(CosmosDiagnosticsContext cosmosCtx, CosmosDiagnostics diagnostics, Integer actualItemCount, Double requestCharge) {
        ctxAccessor.recordOperation(cosmosCtx, 200, 0, actualItemCount, requestCharge, diagnostics, null);
    }

    public <T> void recordFeedResponseConsumerLatency(Signal<T> signal, CosmosDiagnosticsContext cosmosCtx, Duration feedResponseConsumerLatency) {
        try {
            Objects.requireNonNull(signal, "'signal' cannot be null.");
            Objects.requireNonNull(feedResponseConsumerLatency, "'feedResponseConsumerLatency' cannot be null.");
            Preconditions.checkArgument(signal.getType() == SignalType.ON_COMPLETE || signal.getType() == SignalType.ON_ERROR, "recordFeedResponseConsumerLatency should only be used for terminal signal");
            com.azure.core.util.Context context = DiagnosticsProvider.getContextFromReactorOrNull(signal.getContextView());
            if (context == null) {
                return;
            }
            this.recordFeedResponseConsumerLatencyCore(context, cosmosCtx, feedResponseConsumerLatency);
        }
        catch (Throwable error) {
            this.handleErrors(error, 9903);
        }
    }

    private void recordFeedResponseConsumerLatencyCore(com.azure.core.util.Context context, CosmosDiagnosticsContext cosmosCtx, Duration feedResponseConsumerLatency) {
        Objects.requireNonNull(cosmosCtx, "'cosmosCtx' cannot be null.");
        Objects.requireNonNull(feedResponseConsumerLatency, "'feedResponseConsumerLatency' cannot be null.");
        if (feedResponseConsumerLatency.compareTo(FEED_RESPONSE_CONSUMER_LATENCY_THRESHOLD) <= 0 && !LOGGER.isDebugEnabled()) {
            return;
        }
        if (feedResponseConsumerLatency.compareTo(FEED_RESPONSE_CONSUMER_LATENCY_THRESHOLD) <= 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Total duration spent in FeedResponseConsumer is {} but does not exceed threshold of {}, Diagnostics: {}", new Object[]{feedResponseConsumerLatency, FEED_RESPONSE_CONSUMER_LATENCY_THRESHOLD, cosmosCtx});
            return;
        }
        if (context != null && this.isRealTracer()) {
            HashMap attributes = new HashMap();
            String trigger = "SlowFeedResponse";
            DiagnosticsProvider.emitDiagnosticsEvents(this.tracer, cosmosCtx, trigger, context);
            return;
        }
        LOGGER.warn("Total duration spent in FeedResponseConsumer is {} and exceeds threshold of {}, Diagnostics: {}", new Object[]{feedResponseConsumerLatency, FEED_RESPONSE_CONSUMER_LATENCY_THRESHOLD, cosmosCtx});
    }

    private void handleDiagnostics(com.azure.core.util.Context context, CosmosDiagnosticsContext cosmosCtx) {
        if (this.diagnosticHandlers != null && this.diagnosticHandlers.size() > 0) {
            for (CosmosDiagnosticsHandler handler : this.diagnosticHandlers) {
                try {
                    handler.handleDiagnostics(cosmosCtx, context);
                }
                catch (Exception e) {
                    this.diagnosticsHandlerFailures.incrementAndGet();
                    LOGGER.error("HandledDiagnostics failed. ", (Throwable)e);
                }
            }
        }
    }

    public <T extends CosmosResponse<?>> Mono<T> traceEnabledCosmosResponsePublisher(Mono<T> resultPublisher, com.azure.core.util.Context context, String spanName, String databaseId, String containerId, CosmosAsyncClient client, ConsistencyLevel consistencyLevel, OperationType operationType, ResourceType resourceType, RequestOptions requestOptions) {
        Preconditions.checkNotNull(client, "Argument 'client' must not be null.");
        String accountName = clientAccessor.getAccountTagValue(client);
        return this.publisherWithDiagnostics(resultPublisher, context, spanName, containerId, databaseId, accountName, client, consistencyLevel, operationType, resourceType, null, null, r -> r.getStatusCode(), r -> null, r -> r.getRequestCharge(), (r, samplingRate) -> {
            CosmosDiagnostics diagnostics = r.getDiagnostics();
            if (diagnostics != null) {
                diagnosticsAccessor.setSamplingRateSnapshot(diagnostics, (double)samplingRate);
            }
            return diagnostics;
        }, r -> 0L, r -> 0L, r -> 0L, r -> 0, requestOptions, null);
    }

    public <T extends CosmosBatchResponse> Mono<T> traceEnabledBatchResponsePublisher(Mono<T> resultPublisher, com.azure.core.util.Context context, String spanName, String databaseId, String containerId, CosmosAsyncClient client, ConsistencyLevel consistencyLevel, OperationType operationType, ResourceType resourceType, RequestOptions requestOptions, Integer maxBatchSize) {
        Preconditions.checkNotNull(client, "Argument 'client' must not be null.");
        String accountName = clientAccessor.getAccountTagValue(client);
        return this.publisherWithDiagnostics(resultPublisher, context, spanName, containerId, databaseId, accountName, client, consistencyLevel, operationType, resourceType, null, maxBatchSize, CosmosBatchResponse::getStatusCode, CosmosBatchResponse::size, CosmosBatchResponse::getRequestCharge, (r, samplingRate) -> {
            CosmosDiagnostics diagnostics = r.getDiagnostics();
            if (diagnostics != null) {
                diagnosticsAccessor.setSamplingRateSnapshot(diagnostics, (double)samplingRate);
            }
            return diagnostics;
        }, cosmosBatchResponseAccessor::getOpCountPerEvaluation, cosmosBatchResponseAccessor::getRetriedOpCountPerEvaluation, cosmosBatchResponseAccessor::getGlobalOpCount, cosmosBatchResponseAccessor::getTargetMaxMicroBatchSize, requestOptions, null);
    }

    public <T> Mono<CosmosItemResponse<T>> traceEnabledCosmosItemResponsePublisher(Mono<CosmosItemResponse<T>> resultPublisher, com.azure.core.util.Context context, String spanName, String containerId, String databaseId, CosmosAsyncClient client, ConsistencyLevel consistencyLevel, OperationType operationType, ResourceType resourceType, RequestOptions requestOptions, String trackingId) {
        Preconditions.checkNotNull(requestOptions, "Argument 'requestOptions' must not be null.");
        Preconditions.checkNotNull(client, "Argument 'client' must not be null.");
        String accountName = clientAccessor.getAccountTagValue(client);
        return this.publisherWithDiagnostics(resultPublisher, context, spanName, containerId, databaseId, accountName, client, consistencyLevel, operationType, resourceType, trackingId, null, CosmosItemResponse::getStatusCode, r -> null, CosmosItemResponse::getRequestCharge, (r, samplingRate) -> {
            CosmosDiagnostics diagnostics = r.getDiagnostics();
            if (diagnostics != null) {
                diagnosticsAccessor.setSamplingRateSnapshot(diagnostics, (double)samplingRate);
            }
            return diagnostics;
        }, r -> 0L, r -> 0L, r -> 0L, r -> 0, requestOptions, null);
    }

    private <T> Mono<FeedResponse<T>> wrapReadManyFeedResponseWithTracingIfEnabled(CosmosAsyncClient client, List<CosmosItemIdentity> itemIdentityList, FeedOperationState state, Mono<FeedResponse<T>> publisher, RequestOptions requestOptions, com.azure.core.util.Context context) {
        double samplingRateSnapshot = this.samplingRateSnapshotSupplier.get();
        boolean isSampledOut = this.shouldSampleOutOperation(samplingRateSnapshot);
        CosmosDiagnosticsContext ctx = state.getDiagnosticsContextSnapshot();
        ctxAccessor.setSamplingRateSnapshot(ctx, samplingRateSnapshot, isSampledOut);
        if (ctx == null || isSampledOut) {
            return publisher.map(r -> {
                CosmosDiagnostics diagnostics = r.getCosmosDiagnostics();
                if (diagnostics != null) {
                    diagnosticsAccessor.setSamplingRateSnapshot(diagnostics, samplingRateSnapshot);
                }
                return r;
            });
        }
        return this.publisherWithDiagnostics(publisher, context, state.getSpanName(), ctx.getContainerName(), ctx.getDatabaseName(), ctx.getAccountName(), client, ctx.getEffectiveConsistencyLevel(), ctxAccessor.getOperationType(ctx), ctxAccessor.getResourceType(ctx), null, itemIdentityList.size(), r -> 200, r -> r.getResults().size(), r -> r.getRequestCharge(), (r, samplingRate) -> {
            CosmosDiagnostics diagnostics = r.getCosmosDiagnostics();
            if (diagnostics != null) {
                diagnosticsAccessor.setSamplingRateSnapshot(diagnostics, (double)samplingRate);
            }
            return diagnostics;
        }, r -> 0L, r -> 0L, r -> 0L, r -> 0, requestOptions, ctx);
    }

    private static boolean isTracerEnabled(DiagnosticsProvider tracerProvider) {
        return tracerProvider != null;
    }

    public static <T> void recordFeedResponse(Consumer<FeedResponse<T>> feedResponseConsumer, FeedOperationState state, Supplier<Double> samplingRateSnapshotSupplier, DiagnosticsProvider tracerProvider, FeedResponse<T> response, AtomicLong feedResponseConsumerLatencyInNanos) {
        Integer actualItemCount;
        CosmosDiagnostics diagnostics = response != null ? response.getCosmosDiagnostics() : null;
        Integer n = actualItemCount = response != null && response.getResults() != null ? Integer.valueOf(response.getResults().size()) : null;
        if (diagnostics != null && diagnosticsAccessor.isDiagnosticsCapturedInPagedFlux(diagnostics).compareAndSet(false, true)) {
            Double samplingRateSnapshot = samplingRateSnapshotSupplier.get();
            if (samplingRateSnapshot != null && samplingRateSnapshot < 1.0) {
                diagnosticsAccessor.setSamplingRateSnapshot(diagnostics, samplingRateSnapshot);
            }
            if (DiagnosticsProvider.isTracerEnabled(tracerProvider)) {
                tracerProvider.recordPage(state.getDiagnosticsContextSnapshot(), diagnostics, actualItemCount, response.getRequestCharge());
            }
            if (feedResponseConsumer != null) {
                Instant feedResponseConsumerStart = Instant.now();
                feedResponseConsumer.accept(response);
                feedResponseConsumerLatencyInNanos.addAndGet(Duration.between(Instant.now(), feedResponseConsumerStart).toNanos());
            }
        }
    }

    public <T> Mono<FeedResponse<T>> traceEnabledReadManyResponsePublisher(List<CosmosItemIdentity> identities, FeedOperationState state, Mono<FeedResponse<T>> resultPublisher, CosmosAsyncClient client, RequestOptions requestOptions, com.azure.core.util.Context context) {
        Preconditions.checkNotNull(resultPublisher, "Argument 'resultPublisher' must not be null.");
        Preconditions.checkNotNull(state, "Argument 'state' must not be null.");
        Preconditions.checkNotNull(requestOptions, "Argument 'requestOptions' must not be null.");
        Preconditions.checkNotNull(client, "Argument 'client' must not be null.");
        String accountName = clientAccessor.getAccountTagValue(client);
        return this.wrapReadManyFeedResponseWithTracingIfEnabled(client, identities, state, resultPublisher, requestOptions, context);
    }

    public <T> Flux<T> runUnderSpanInContext(Flux<T> publisher) {
        return this.propagatingFlux.flatMap(ignored -> publisher);
    }

    public boolean shouldSampleOutOperation(CosmosPagedFluxOptions options) {
        double samplingRateSnapshot = clientTelemetryConfigAccessor.getSamplingRate(this.telemetryConfig);
        boolean result = this.shouldSampleOutOperation(samplingRateSnapshot);
        options.setSamplingRateSnapshot(samplingRateSnapshot, result);
        return result;
    }

    private boolean shouldSampleOutOperation(double samplingRate) {
        if (samplingRate == 1.0) {
            return false;
        }
        if (samplingRate == 0.0) {
            return true;
        }
        return ThreadLocalRandom.current().nextDouble() >= samplingRate;
    }

    private <T> Mono<T> diagnosticsEnabledPublisher(CosmosDiagnosticsContext cosmosCtx, Mono<T> resultPublisher, com.azure.core.util.Context context, String spanName, Function<T, Integer> statusCodeFunc, Function<T, Integer> actualItemCountFunc, Function<T, Double> requestChargeFunc, BiFunction<T, Double, CosmosDiagnostics> diagnosticsFunc, Function<T, Long> opCountPerEvaluationPeriodFunc, Function<T, Long> opRetriedCountPerEvaluationPeriodFunc, Function<T, Long> globalOpCountPerEvaluationPeriodFunc, Function<T, Integer> targetMaxMicroBatchSizeFunc) {
        Optional callDepth;
        boolean isNestedCall;
        double samplingRateSnapshot = this.isEnabled() ? clientTelemetryConfigAccessor.getSamplingRate(this.telemetryConfig) : 0.0;
        boolean isSampledOut = this.shouldSampleOutOperation(samplingRateSnapshot);
        if (cosmosCtx != null) {
            ctxAccessor.setSamplingRateSnapshot(cosmosCtx, samplingRateSnapshot, isSampledOut);
        }
        if (isNestedCall = (callDepth = context.getData((Object)COSMOS_CALL_DEPTH)).isPresent()) {
            return resultPublisher;
        }
        return this.propagatingMono.flatMap(ignored -> resultPublisher).doOnEach(signal -> {
            switch (signal.getType()) {
                case ON_NEXT: {
                    Object response = signal.get();
                    this.endSpan((Signal)signal, cosmosCtx, (Integer)statusCodeFunc.apply(response), (Integer)actualItemCountFunc.apply(response), (Double)requestChargeFunc.apply(response), (Long)opCountPerEvaluationPeriodFunc.apply(response), (Long)opRetriedCountPerEvaluationPeriodFunc.apply(response), (Long)globalOpCountPerEvaluationPeriodFunc.apply(response), (Integer)targetMaxMicroBatchSizeFunc.apply(response), (CosmosDiagnostics)diagnosticsFunc.apply(response, samplingRateSnapshot), isSampledOut);
                    break;
                }
                case ON_ERROR: {
                    this.endSpan((Signal)signal, cosmosCtx, 0, null, null, null, null, null, null, null, isSampledOut);
                    break;
                }
            }
        }).contextWrite((ContextView)DiagnosticsProvider.setContextInReactor(this.startSpan(spanName, cosmosCtx, context, isSampledOut)));
    }

    private <T> Mono<T> publisherWithDiagnostics(Mono<T> resultPublisher, com.azure.core.util.Context context, String spanName, String containerId, String databaseId, String accountName, CosmosAsyncClient client, ConsistencyLevel consistencyLevel, OperationType operationType, ResourceType resourceType, String trackingId, Integer maxItemCount, Function<T, Integer> statusCodeFunc, Function<T, Integer> actualItemCountFunc, Function<T, Double> requestChargeFunc, BiFunction<T, Double, CosmosDiagnostics> diagnosticFunc, Function<T, Long> opCountPerEvaluationPeriodFunc, Function<T, Long> opRetriedCountPerEvaluationPeriodFunc, Function<T, Long> globalOpCountPerEvaluationPeriodFunc, Function<T, Integer> targetMaxMicroBatchSizeFunc, RequestOptions requestOptions, CosmosDiagnosticsContext cosmosCtxFromUpstream) {
        CosmosDiagnosticsContext cosmosCtx;
        CosmosDiagnosticsThresholds thresholds = requestOptions != null ? clientAccessor.getEffectiveDiagnosticsThresholds(client, requestOptions.getDiagnosticsThresholds()) : clientAccessor.getEffectiveDiagnosticsThresholds(client, null);
        ReadConsistencyStrategy requestLevelReadConsistencyStrategy = requestOptions != null ? requestOptions.getReadConsistencyStrategy() : null;
        CosmosDiagnosticsContext cosmosDiagnosticsContext = cosmosCtx = cosmosCtxFromUpstream != null ? cosmosCtxFromUpstream : ctxAccessor.create(spanName, accountName, BridgeInternal.getServiceEndpoint(client), databaseId, containerId, resourceType, operationType, null, clientAccessor.getEffectiveConsistencyLevel(client, operationType, consistencyLevel), clientAccessor.getEffectiveReadConsistencyStrategy(client, resourceType, operationType, requestLevelReadConsistencyStrategy), maxItemCount, thresholds, trackingId, clientAccessor.getConnectionMode(client), clientAccessor.getUserAgent(client), null, null, requestOptions);
        if (requestOptions != null) {
            requestOptions.setDiagnosticsContextSupplier(() -> cosmosCtx);
        }
        return this.diagnosticsEnabledPublisher(cosmosCtx, resultPublisher, context, spanName, statusCodeFunc, actualItemCountFunc, requestChargeFunc, diagnosticFunc, opCountPerEvaluationPeriodFunc, opRetriedCountPerEvaluationPeriodFunc, globalOpCountPerEvaluationPeriodFunc, targetMaxMicroBatchSizeFunc);
    }

    private void end(CosmosDiagnosticsContext cosmosCtx, int statusCode, int subStatusCode, Integer actualItemCount, Double requestCharge, Long opCountPerEvaluation, Long opRetriedCountPerEvaluation, Long globalOpCount, Integer targetMaxMicroBatchSize, CosmosDiagnostics diagnostics, Throwable throwable, com.azure.core.util.Context context, boolean isForcedEmptyCompletion, boolean isSampledOut) {
        Preconditions.checkNotNull(cosmosCtx, "Argument 'cosmosCtx' must not be null.");
        if (ctxAccessor.endOperation(cosmosCtx, statusCode, subStatusCode, actualItemCount, requestCharge, opCountPerEvaluation, opRetriedCountPerEvaluation, globalOpCount, targetMaxMicroBatchSize, diagnostics, throwable) && !isSampledOut) {
            if (!isForcedEmptyCompletion) {
                this.handleDiagnostics(context, cosmosCtx);
            }
            if (this.cosmosTracer != null) {
                this.cosmosTracer.endSpan(cosmosCtx, context, isForcedEmptyCompletion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void subscribe(Tracer tracer, CoreSubscriber<? super Object> actual) {
        com.azure.core.util.Context context = DiagnosticsProvider.getContextFromReactorOrNull((ContextView)actual.currentContext());
        if (context != null) {
            AutoCloseable scope = tracer.makeSpanCurrent(context);
            try {
                actual.onSubscribe(Operators.scalarSubscription(actual, (Object)DUMMY_VALUE));
            }
            finally {
                try {
                    scope.close();
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected failure closing tracer scope.", (Throwable)e);
                    throw new IllegalStateException("Unexpected failure closing tracer scope.", e);
                }
            }
        }
        actual.onSubscribe(Operators.scalarSubscription(actual, (Object)DUMMY_VALUE));
    }

    private static void emitDiagnosticsEvents(Tracer tracer, CosmosDiagnosticsContext cosmosCtx, String trigger, com.azure.core.util.Context context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String message = trigger + " - CTX: " + cosmosCtx.toJson();
        List<String> messageFragments = Splitter.fixedLength(Configs.getMaxTraceMessageLength()).splitToList(message);
        attributes.put("Trigger", trigger);
        for (int i = 0; i < messageFragments.size(); ++i) {
            attributes.put("SequenceNumber", String.format(Locale.ROOT, "%05d", i + 1));
            tracer.addEvent(messageFragments.get(i), attributes, OffsetDateTime.now(), context);
        }
    }

    public static String prettifyCallstack(Throwable e) {
        StringWriter stackWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackWriter);
        e.printStackTrace(printWriter);
        printWriter.flush();
        stackWriter.flush();
        String prettifiedCallstack = stackWriter.toString();
        String message = e.toString();
        if (prettifiedCallstack.length() > message.length()) {
            prettifiedCallstack = prettifiedCallstack.substring(message.length());
        }
        printWriter.close();
        try {
            stackWriter.close();
        }
        catch (IOException closeError) {
            LOGGER.warn("Error trying to close StringWriter.", (Throwable)closeError);
        }
        return prettifiedCallstack;
    }

    private void handleErrors(Throwable throwable, int systemExitCode) {
        if (!(throwable instanceof Error)) {
            this.diagnosticsHandlerFailures.incrementAndGet();
            LOGGER.error("Unexpected exception in DiagnosticsProvider.endSpan. ", throwable);
            throw new RuntimeException(throwable);
        }
        this.handleFatalError((Error)throwable, systemExitCode);
    }

    private void handleFatalError(Error error, int systemExitCode) {
        Exception exception = DiagnosticsProviderJvmFatalErrorMapper.getMapper().mapFatalError(error);
        if (exception != null) {
            String errorMessage = "Runtime exception mapped from fatal error " + error;
            throw new RuntimeException(errorMessage, exception);
        }
        if (!this.shouldSystemExitOnError) {
            throw error;
        }
        LOGGER.error("Unexpected error in DiagnosticsProvider.endSpan. Calling System.exit({})...", (Object)systemExitCode, (Object)error);
        System.err.printf("Unexpected error in DiagnosticsProvider.endSpan. Calling System.exit(%d)... %s%n", systemExitCode, error);
        System.exit(systemExitCode);
    }

    private static final class EnabledNoOpTracer
    implements Tracer {
        public static final Tracer INSTANCE = new EnabledNoOpTracer();

        private EnabledNoOpTracer() {
        }

        public com.azure.core.util.Context start(String methodName, com.azure.core.util.Context context) {
            return context;
        }

        public com.azure.core.util.Context start(String methodName, com.azure.core.util.Context context, ProcessKind processKind) {
            return context;
        }

        public void end(int responseCode, Throwable error, com.azure.core.util.Context context) {
        }

        public void end(String errorCondition, Throwable error, com.azure.core.util.Context context) {
        }

        public void setAttribute(String key, String value, com.azure.core.util.Context context) {
        }

        public com.azure.core.util.Context setSpanName(String spanName, com.azure.core.util.Context context) {
            return com.azure.core.util.Context.NONE;
        }

        public void addLink(com.azure.core.util.Context context) {
        }

        public com.azure.core.util.Context extractContext(String diagnosticId, com.azure.core.util.Context context) {
            return com.azure.core.util.Context.NONE;
        }

        public com.azure.core.util.Context getSharedSpanBuilder(String spanName, com.azure.core.util.Context context) {
            return com.azure.core.util.Context.NONE;
        }
    }

    private static final class LegacyCosmosTracer
    implements CosmosTracer {
        private static final String JSON_STRING = "JSON";
        private final Tracer tracer;

        public LegacyCosmosTracer(Tracer tracer) {
            Preconditions.checkNotNull(tracer, "Argument 'tracer' must not be null.");
            this.tracer = tracer;
        }

        @Override
        public com.azure.core.util.Context startSpan(String spanName, CosmosDiagnosticsContext cosmosCtx, com.azure.core.util.Context context) {
            Preconditions.checkNotNull(spanName, "Argument 'spanName' must not be null.");
            Preconditions.checkNotNull(cosmosCtx, "Argument 'cosmosCtx' must not be null.");
            StartSpanOptions spanOptions = this.startSpanOptions(spanName, cosmosCtx.getDatabaseName(), ctxAccessor.getEndpoint(cosmosCtx));
            return this.tracer.start(spanName, spanOptions, context);
        }

        private StartSpanOptions startSpanOptions(String methodName, String databaseId, String endpoint) {
            StartSpanOptions spanOptions = new StartSpanOptions(SpanKind.CLIENT).setAttribute(DiagnosticsProvider.DB_TYPE, (Object)DiagnosticsProvider.DB_TYPE_VALUE).setAttribute(DiagnosticsProvider.LEGACY_DB_URL, (Object)endpoint).setAttribute(DiagnosticsProvider.LEGACY_DB_STATEMENT, (Object)methodName);
            if (databaseId != null) {
                spanOptions.setAttribute(DiagnosticsProvider.LEGACY_DB_INSTANCE, (Object)databaseId);
            }
            return spanOptions;
        }

        @Override
        public void endSpan(CosmosDiagnosticsContext cosmosCtx, com.azure.core.util.Context context, boolean isEmptyCompletion) {
            try {
                Collection<CosmosDiagnostics> diagnostics;
                if (cosmosCtx != null && cosmosCtx.isThresholdViolated() && (diagnostics = cosmosCtx.getDiagnostics()) != null && diagnostics.size() > 0) {
                    for (CosmosDiagnostics d : diagnostics) {
                        this.addDiagnosticsOnTracerEvent(d, context);
                    }
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.warn("Error while serializing diagnostics for tracer.", (Throwable)ex);
            }
            if (cosmosCtx != null) {
                this.tracer.end(cosmosCtx.getStatusCode(), cosmosCtx.getFinalError(), context);
            }
        }

        private void addClientSideRequestStatisticsOnTracerEvent(ClientSideRequestStatistics clientSideRequestStatistics, com.azure.core.util.Context context) throws JsonProcessingException {
            String eventName;
            OffsetDateTime requestStartTime;
            HashMap<String, Object> attributes;
            if (clientSideRequestStatistics == null || context == null) {
                return;
            }
            int diagnosticsCounter = 1;
            for (ClientSideRequestStatistics.StoreResponseStatistics storeResponseStatistics : clientSideRequestStatistics.getResponseStatisticsList()) {
                attributes = new HashMap<String, Object>();
                attributes.put(JSON_STRING, mapper.writeValueAsString((Object)storeResponseStatistics));
                Iterator<RequestTimeline.Event> eventIterator = null;
                try {
                    if (storeResponseStatistics.getStoreResult() != null) {
                        eventIterator = storeResponseStatistics.getStoreResult().getStoreResponseDiagnostics().getRequestTimeline().iterator();
                    }
                }
                catch (CosmosException ex) {
                    eventIterator = BridgeInternal.getRequestTimeline(ex).iterator();
                }
                OffsetDateTime requestStartTime2 = OffsetDateTime.ofInstant(storeResponseStatistics.getRequestResponseTimeUTC(), ZoneOffset.UTC);
                if (eventIterator != null) {
                    while (eventIterator.hasNext()) {
                        RequestTimeline.Event event = eventIterator.next();
                        if (!event.getName().equals(RequestTimeline.EventName.CREATED.getEventName())) continue;
                        requestStartTime2 = OffsetDateTime.ofInstant(event.getStartTime(), ZoneOffset.UTC);
                        break;
                    }
                }
                this.addEvent("StoreResponse" + diagnosticsCounter++, attributes, requestStartTime2, context);
            }
            diagnosticsCounter = 1;
            for (ClientSideRequestStatistics.StoreResponseStatistics statistics : ClientSideRequestStatistics.getCappedSupplementalResponseStatisticsList(clientSideRequestStatistics.getSupplementalResponseStatisticsList())) {
                attributes = new HashMap();
                attributes.put(JSON_STRING, mapper.writeValueAsString((Object)statistics));
                requestStartTime = OffsetDateTime.ofInstant(statistics.getRequestResponseTimeUTC(), ZoneOffset.UTC);
                if (statistics.getStoreResult() != null) {
                    for (RequestTimeline.Event event : statistics.getStoreResult().getStoreResponseDiagnostics().getRequestTimeline()) {
                        if (!event.getName().equals(RequestTimeline.EventName.CREATED.getEventName())) continue;
                        requestStartTime = OffsetDateTime.ofInstant(event.getStartTime(), ZoneOffset.UTC);
                        break;
                    }
                }
                this.addEvent("Supplemental StoreResponse" + diagnosticsCounter++, attributes, requestStartTime, context);
            }
            for (ClientSideRequestStatistics.GatewayStatistics gatewayStats : clientSideRequestStatistics.getGatewayStatisticsList()) {
                attributes = new HashMap();
                attributes.put(JSON_STRING, mapper.writeValueAsString((Object)gatewayStats));
                requestStartTime = OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC);
                if (gatewayStats.getRequestTimeline() != null) {
                    for (RequestTimeline.Event event : gatewayStats.getRequestTimeline()) {
                        if (!event.getName().equals(RequestTimeline.EventName.CREATED.getEventName())) continue;
                        requestStartTime = OffsetDateTime.ofInstant(event.getStartTime(), ZoneOffset.UTC);
                        break;
                    }
                }
                this.addEvent("GatewayStatistics", attributes, requestStartTime, context);
            }
            if (clientSideRequestStatistics.getRetryContext().getRetryStartTime() != null) {
                attributes = new HashMap();
                attributes.put(JSON_STRING, mapper.writeValueAsString((Object)clientSideRequestStatistics.getRetryContext()));
                this.addEvent("Retry Context", attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRetryContext().getRetryStartTime(), ZoneOffset.UTC), context);
            }
            diagnosticsCounter = 1;
            for (ClientSideRequestStatistics.AddressResolutionStatistics addressResolutionStatistics : clientSideRequestStatistics.getAddressResolutionStatistics().values()) {
                attributes = new HashMap();
                attributes.put(JSON_STRING, mapper.writeValueAsString((Object)addressResolutionStatistics));
                this.addEvent("AddressResolutionStatistics" + diagnosticsCounter++, attributes, OffsetDateTime.ofInstant(addressResolutionStatistics.getStartTimeUTC(), ZoneOffset.UTC), context);
            }
            if (clientSideRequestStatistics.getSerializationDiagnosticsContext().serializationDiagnosticsList != null) {
                for (SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics : clientSideRequestStatistics.getSerializationDiagnosticsContext().serializationDiagnosticsList) {
                    attributes = new HashMap();
                    attributes.put(JSON_STRING, mapper.writeValueAsString((Object)serializationDiagnostics));
                    this.addEvent("SerializationDiagnostics " + (Object)((Object)serializationDiagnostics.serializationType), attributes, OffsetDateTime.ofInstant(serializationDiagnostics.startTimeUTC, ZoneOffset.UTC), context);
                }
            }
            attributes = new HashMap();
            attributes.put(JSON_STRING, mapper.writeValueAsString(clientSideRequestStatistics.getContactedRegionNames()));
            this.addEvent("RegionContacted", attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
            attributes = new HashMap();
            attributes.put(JSON_STRING, mapper.writeValueAsString((Object)ClientSideRequestStatistics.fetchSystemInformation()));
            this.addEvent("SystemInformation", attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
            attributes = new HashMap();
            attributes.put(JSON_STRING, mapper.writeValueAsString((Object)clientSideRequestStatistics.getDiagnosticsClientConfig()));
            this.addEvent("ClientCfgs", attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
            if (clientSideRequestStatistics.getResponseStatisticsList() != null && clientSideRequestStatistics.getResponseStatisticsList().size() > 0 && clientSideRequestStatistics.getResponseStatisticsList().iterator().next() != null) {
                eventName = "Diagnostics for PKRange " + clientSideRequestStatistics.getResponseStatisticsList().iterator().next().getStoreResult().getStoreResponseDiagnostics().getPartitionKeyRangeId();
                this.addEvent(eventName, attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
            } else if (clientSideRequestStatistics.getGatewayStatisticsList() != null && clientSideRequestStatistics.getGatewayStatisticsList().size() > 0) {
                eventName = "Diagnostics for PKRange " + clientSideRequestStatistics.getGatewayStatisticsList().get(0).getPartitionKeyRangeId();
                this.addEvent(eventName, attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
            } else {
                eventName = "Diagnostics ";
                this.addEvent(eventName, attributes, OffsetDateTime.ofInstant(clientSideRequestStatistics.getRequestStartTimeUTC(), ZoneOffset.UTC), context);
            }
        }

        private void addDiagnosticsOnTracerEvent(CosmosDiagnostics cosmosDiagnostics, com.azure.core.util.Context context) throws JsonProcessingException {
            if (cosmosDiagnostics == null || context == null) {
                return;
            }
            FeedResponseDiagnostics feedResponseDiagnostics = diagnosticsAccessor.getFeedResponseDiagnostics(cosmosDiagnostics);
            if (feedResponseDiagnostics != null) {
                Map<String, QueryMetrics> queryMetrics;
                HashMap<String, Object> attributes;
                QueryInfo.QueryPlanDiagnosticsContext queryPlanDiagnostics = feedResponseDiagnostics.getQueryPlanDiagnosticsContext();
                if (queryPlanDiagnostics != null) {
                    attributes = new HashMap<String, Object>();
                    attributes.put(JSON_STRING, mapper.writeValueAsString((Object)queryPlanDiagnostics));
                    this.addEvent("Query Plan Statistics", attributes, OffsetDateTime.ofInstant(queryPlanDiagnostics.getStartTimeUTC(), ZoneOffset.UTC), context);
                }
                if ((queryMetrics = feedResponseDiagnostics.getQueryMetricsMap()) != null && queryMetrics.size() > 0) {
                    for (Map.Entry entry : queryMetrics.entrySet()) {
                        attributes = new HashMap();
                        attributes.put("Query Metrics", ((QueryMetrics)entry.getValue()).toString());
                        this.addEvent("Query Metrics for PKRange " + (String)entry.getKey(), attributes, OffsetDateTime.now(), context);
                    }
                }
                for (ClientSideRequestStatistics clientSideRequestStatistics : feedResponseDiagnostics.getClientSideRequestStatistics()) {
                    this.addClientSideRequestStatisticsOnTracerEvent(clientSideRequestStatistics, context);
                }
            }
            this.addClientSideRequestStatisticsOnTracerEvent(BridgeInternal.getClientSideRequestStatics(cosmosDiagnostics), context);
        }

        void addEvent(String name, Map<String, Object> attributes, OffsetDateTime timestamp, com.azure.core.util.Context context) {
            this.tracer.addEvent(name, attributes, timestamp, context);
        }
    }

    private static interface CosmosTracer {
        public com.azure.core.util.Context startSpan(String var1, CosmosDiagnosticsContext var2, com.azure.core.util.Context var3);

        public void endSpan(CosmosDiagnosticsContext var1, com.azure.core.util.Context var2, boolean var3);
    }

    private static final class OpenTelemetryCosmosTracer
    implements CosmosTracer {
        private final Tracer tracer;
        private final CosmosClientTelemetryConfig config;
        private final String clientId;
        private final String connectionMode;
        private final String userAgent;

        public OpenTelemetryCosmosTracer(Tracer tracer, CosmosClientTelemetryConfig config, String clientId, String userAgent, String connectionMode) {
            Preconditions.checkNotNull(tracer, "Argument 'tracer' must not be null.");
            Preconditions.checkNotNull(config, "Argument 'config' must not be null.");
            Preconditions.checkNotNull(clientId, "Argument 'clientId' must not be null.");
            Preconditions.checkNotNull(userAgent, "Argument 'userAgent' must not be null.");
            Preconditions.checkNotNull(connectionMode, "Argument 'connectionMode' must not be null.");
            this.tracer = tracer;
            this.config = config;
            this.clientId = clientId;
            this.userAgent = userAgent;
            this.connectionMode = connectionMode;
        }

        private boolean isTransportLevelTracingEnabled() {
            return clientTelemetryConfigAccessor.isTransportLevelTracingEnabled(this.config);
        }

        private boolean showQueryStatement() {
            return ShowQueryMode.ALL.equals((Object)clientTelemetryConfigAccessor.showQueryMode(this.config)) || ShowQueryMode.PARAMETERIZED_ONLY.equals((Object)clientTelemetryConfigAccessor.showQueryMode(this.config));
        }

        @Override
        public com.azure.core.util.Context startSpan(String spanName, CosmosDiagnosticsContext cosmosCtx, com.azure.core.util.Context context) {
            Preconditions.checkNotNull(spanName, "Argument 'spanName' must not be null.");
            Preconditions.checkNotNull(cosmosCtx, "Argument 'cosmosCtx' must not be null.");
            com.azure.core.util.Context local = Objects.requireNonNull(context, "'context' cannot be null.").addData((Object)DiagnosticsProvider.COSMOS_DIAGNOSTICS_CONTEXT_KEY, (Object)cosmosCtx);
            StartSpanOptions spanOptions = this.startSpanOptions(spanName, cosmosCtx);
            return this.tracer.start(spanName, spanOptions, local);
        }

        private StartSpanOptions startSpanOptions(String spanName, CosmosDiagnosticsContext cosmosCtx) {
            StartSpanOptions spanOptions;
            if (this.tracer instanceof EnabledNoOpTracer) {
                spanOptions = new StartSpanOptions(SpanKind.INTERNAL);
            } else {
                String containerName;
                spanOptions = new StartSpanOptions(SpanKind.INTERNAL).setAttribute("db.system", (Object)"cosmosdb").setAttribute("db.operation", (Object)spanName).setAttribute("net.peer.name", (Object)cosmosCtx.getAccountName()).setAttribute("db.cosmosdb.operation_type", (Object)cosmosCtx.getOperationType()).setAttribute("db.cosmosdb.resource_type", (Object)cosmosCtx.getResourceType()).setAttribute("db.name", (Object)cosmosCtx.getDatabaseName()).setAttribute("db.cosmosdb.client_id", (Object)this.clientId).setAttribute("user_agent.original", (Object)this.userAgent).setAttribute("db.cosmosdb.connection_mode", (Object)this.connectionMode);
                if (!cosmosCtx.getOperationId().isEmpty() && !cosmosCtx.getOperationId().equals(ctxAccessor.getSpanName(cosmosCtx))) {
                    spanOptions.setAttribute("db.cosmosdb.operation_id", (Object)cosmosCtx.getOperationId());
                }
                if (this.showQueryStatement() && null != cosmosCtx.getQueryStatement()) {
                    spanOptions.setAttribute(DiagnosticsProvider.LEGACY_DB_STATEMENT, (Object)cosmosCtx.getQueryStatement());
                }
                if ((containerName = cosmosCtx.getContainerName()) != null) {
                    spanOptions.setAttribute("db.cosmosdb.container", (Object)containerName);
                }
            }
            return spanOptions;
        }

        @Override
        public void endSpan(CosmosDiagnosticsContext cosmosCtx, com.azure.core.util.Context context, boolean isEmptyCompletion) {
            if (cosmosCtx == null) {
                return;
            }
            if (!cosmosCtx.isCompleted()) {
                this.tracer.end("CosmosCtx not completed yet.", null, context);
                return;
            }
            String errorMessage = null;
            Throwable finalError = cosmosCtx.getFinalError();
            if (finalError != null && cosmosCtx.isFailure()) {
                if (finalError instanceof CosmosException) {
                    CosmosException cosmosException = (CosmosException)((Object)finalError);
                    errorMessage = cosmosException.getShortMessage();
                } else {
                    errorMessage = finalError.getMessage();
                }
            }
            if (this.tracer instanceof EnabledNoOpTracer) {
                this.tracer.end(errorMessage, finalError, context);
                return;
            }
            if (isEmptyCompletion) {
                this.tracer.setAttribute("db.cosmosdb.is_empty_completion", Boolean.toString(true), context);
                this.tracer.end(errorMessage, finalError, context);
                return;
            }
            if (cosmosCtx.isFailure() || cosmosCtx.isThresholdViolated()) {
                String trigger = cosmosCtx.isFailure() ? "Failure" : "ThresholdViolation";
                DiagnosticsProvider.emitDiagnosticsEvents(this.tracer, cosmosCtx, trigger, context);
            }
            if (finalError != null) {
                String exceptionType = finalError instanceof CosmosException ? CosmosException.class.getCanonicalName() : finalError.getClass().getCanonicalName();
                this.tracer.setAttribute("exception.escaped", Boolean.toString(cosmosCtx.isFailure()), context);
                this.tracer.setAttribute("exception.type", exceptionType, context);
                if (errorMessage != null) {
                    this.tracer.setAttribute("exception.message", errorMessage, context);
                }
                this.tracer.setAttribute("exception.stacktrace", DiagnosticsProvider.prettifyCallstack(finalError), context);
            }
            if (this.isTransportLevelTracingEnabled()) {
                this.traceTransportLevel(cosmosCtx, context);
            }
            this.tracer.setAttribute("db.cosmosdb.status_code", Integer.toString(cosmosCtx.getStatusCode()), context);
            this.tracer.setAttribute("db.cosmosdb.sub_status_code", Integer.toString(cosmosCtx.getSubStatusCode()), context);
            this.tracer.setAttribute("db.cosmosdb.request_charge", Float.toString(cosmosCtx.getTotalRequestCharge()), context);
            this.tracer.setAttribute("db.cosmosdb.request_content_length", (long)cosmosCtx.getMaxRequestPayloadSizeInBytes(), context);
            this.tracer.setAttribute("db.cosmosdb.max_response_content_length_bytes", (long)cosmosCtx.getMaxResponsePayloadSizeInBytes(), context);
            this.tracer.setAttribute("db.cosmosdb.retry_count", (long)cosmosCtx.getRetryCount(), context);
            Set<String> regionsContacted = cosmosCtx.getContactedRegionNames();
            if (!regionsContacted.isEmpty()) {
                this.tracer.setAttribute("db.cosmosdb.regions_contacted", String.join((CharSequence)", ", regionsContacted), context);
            }
            this.tracer.end(errorMessage, finalError, context);
        }

        private void recordStoreResponseStatistics(Collection<ClientSideRequestStatistics.StoreResponseStatistics> storeResponseStatistics, com.azure.core.util.Context context) {
            for (ClientSideRequestStatistics.StoreResponseStatistics responseStatistics : storeResponseStatistics) {
                Double backendLatency;
                String pkRangeId;
                String activityId;
                String requestSessionToken;
                String responseSessionToken;
                StoreResultDiagnostics storeResultDiagnostics = responseStatistics.getStoreResult();
                StoreResponseDiagnostics storeResponseDiagnostics = storeResultDiagnostics.getStoreResponseDiagnostics();
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("rntbd.url", storeResultDiagnostics.getStorePhysicalAddressAsString());
                attributes.put("rntbd.resource_type", responseStatistics.getRequestResourceType().toString());
                attributes.put("rntbd.operation_type", responseStatistics.getRequestOperationType().toString());
                attributes.put("rntbd.region", responseStatistics.getRegionName());
                if (storeResultDiagnostics.getLsn() > 0L) {
                    attributes.put("rntbd.lsn", Long.toString(storeResultDiagnostics.getLsn()));
                }
                if (storeResultDiagnostics.getGlobalCommittedLSN() > 0L) {
                    attributes.put("rntbd.gclsn", Long.toString(storeResultDiagnostics.getGlobalCommittedLSN()));
                }
                if ((responseSessionToken = responseStatistics.getRequestSessionToken()) != null && !responseSessionToken.isEmpty()) {
                    attributes.put("rntbd.session_token", responseSessionToken);
                }
                if ((requestSessionToken = responseStatistics.getRequestSessionToken()) != null && !requestSessionToken.isEmpty()) {
                    attributes.put("rntbd.request_session_token", requestSessionToken);
                }
                if ((activityId = storeResponseDiagnostics.getActivityId()) != null && !activityId.isEmpty()) {
                    attributes.put("rntbd.activity_id", activityId);
                }
                if ((pkRangeId = storeResponseDiagnostics.getPartitionKeyRangeId()) != null && !pkRangeId.isEmpty()) {
                    attributes.put("rntbd.partition_key_range_id", pkRangeId);
                }
                attributes.put("rntbd.status_code", Integer.toString(storeResponseDiagnostics.getStatusCode()));
                if (storeResponseDiagnostics.getSubStatusCode() != 0) {
                    attributes.put("rntbd.sub_status_code", Integer.toString(storeResponseDiagnostics.getSubStatusCode()));
                }
                if (storeResponseDiagnostics.getFaultInjectionRuleId() != null) {
                    attributes.put("rntbd.fault_injection_rule_id", storeResponseDiagnostics.getFaultInjectionRuleId());
                }
                if ((backendLatency = storeResultDiagnostics.getBackendLatencyInMs()) != null) {
                    attributes.put("rntbd.backend_latency", Double.toString(backendLatency));
                }
                double requestCharge = storeResponseDiagnostics.getRequestCharge();
                attributes.put("rntbd.request_charge", Double.toString(requestCharge));
                Duration latency = responseStatistics.getDuration();
                if (latency != null) {
                    attributes.put("rntbd.latency", latency.toString());
                }
                if (storeResponseDiagnostics.getRntbdChannelStatistics() != null) {
                    attributes.put("rntbd.is_new_channel", storeResponseDiagnostics.getRntbdChannelStatistics().isWaitForConnectionInit());
                }
                OffsetDateTime startTime = null;
                for (RequestTimeline.Event event : storeResponseDiagnostics.getRequestTimeline()) {
                    Duration duration;
                    OffsetDateTime eventTime;
                    OffsetDateTime offsetDateTime = eventTime = event.getStartTime() != null ? event.getStartTime().atOffset(ZoneOffset.UTC) : null;
                    if (eventTime != null && (startTime == null || startTime.isBefore(eventTime))) {
                        startTime = eventTime;
                    }
                    if ((duration = event.getDuration()) == null || duration == Duration.ZERO) continue;
                    attributes.put("rntbd.latency_" + event.getName().toLowerCase(Locale.ROOT), duration.toString());
                }
                attributes.put("rntbd.request_size_bytes", storeResponseDiagnostics.getRequestPayloadLength());
                attributes.put("rntbd.response_size_bytes", storeResponseDiagnostics.getResponsePayloadLength());
                this.tracer.addEvent("rntbd.request", attributes, startTime != null ? startTime : OffsetDateTime.now(), context);
            }
        }

        private void traceTransportLevelRequests(Collection<ClientSideRequestStatistics> clientSideRequestStatistics, com.azure.core.util.Context context) {
            if (clientSideRequestStatistics != null) {
                for (ClientSideRequestStatistics requestStatistics : clientSideRequestStatistics) {
                    this.recordStoreResponseStatistics(requestStatistics.getResponseStatisticsList(), context);
                    this.recordStoreResponseStatistics(requestStatistics.getSupplementalResponseStatisticsList(), context);
                }
            }
        }

        private void traceTransportLevel(CosmosDiagnosticsContext diagnosticsContext, com.azure.core.util.Context context) {
            Collection<ClientSideRequestStatistics> combinedClientSideRequestStatistics = ctxAccessor.getDistinctCombinedClientSideRequestStatistics(diagnosticsContext);
            this.traceTransportLevelRequests(combinedClientSideRequestStatistics, context);
        }
    }

    private final class PropagatingMono
    extends Mono<Object> {
        private PropagatingMono() {
        }

        public void subscribe(CoreSubscriber<? super Object> actual) {
            DiagnosticsProvider.subscribe(DiagnosticsProvider.this.tracer, (CoreSubscriber<? super Object>)actual);
        }
    }

    private final class PropagatingFlux
    extends Flux<Object> {
        private PropagatingFlux() {
        }

        public void subscribe(CoreSubscriber<? super Object> actual) {
            DiagnosticsProvider.subscribe(DiagnosticsProvider.this.tracer, (CoreSubscriber<? super Object>)actual);
        }
    }
}

