/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.meta;

import com.dbeaver.jdbc.salesforce.SalesForceUtils;
import com.sforce.soap.partner.sobject.ISObject;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SFStruct
implements Struct {
    private ISObject owner;
    private ISObject object;
    private final Map<String, Object> attrValues = new LinkedHashMap<String, Object>();

    public SFStruct(ISObject owner, ISObject object) {
        this.owner = owner;
        this.object = object;
        Object records = object.getSObjectField("records");
        if (records instanceof ISObject) {
            object = (ISObject)records;
        }
        if (object instanceof SObject) {
            Iterator fi = ((SObject)object).getChildren();
            while (fi.hasNext()) {
                XmlObject fieldXml = (XmlObject)fi.next();
                String fieldName = fieldXml.getName().getLocalPart();
                if (SalesForceUtils.isSystemField(object, fieldName)) continue;
                Object value = SalesForceUtils.makeJdbcValue(object, object.getSObjectField(fieldName));
                this.attrValues.put(fieldName, value);
            }
        }
    }

    @Override
    public String getSQLTypeName() {
        return this.object.getType();
    }

    @Override
    public Object[] getAttributes() {
        return this.attrValues.values().toArray(new Object[0]);
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        return new Object[0];
    }

    public String toString() {
        return this.getSQLTypeName() + "{ " + Arrays.toString(this.getAttributes()) + " }";
    }
}

