/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.ui.views;

import com.dbeaver.db.teradata.internal.TeradataActivator;
import com.dbeaver.db.teradata.ui.TeradataMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class TeradataConnectionPageAdvanced
extends ConnectionPageAbstract {
    private Button showAllDatabases;
    private Button hierarchyTree;
    private Button hideUsers;
    private Button useFormat;

    public TeradataConnectionPageAdvanced() {
        super.setTitle(TeradataMessages.connection_page_control_group_advanced_settings);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group advancedSettings = UIUtils.createControlGroup((Composite)composite, (String)TeradataMessages.connection_page_control_group_advanced_settings, (int)1, (int)32, (int)-1);
        this.showAllDatabases = UIUtils.createCheckbox((Composite)advancedSettings, (String)TeradataMessages.connection_page_checkbox_label_show_all_databases, (String)TeradataMessages.connection_page_checkbox_description_show_all_databases, (boolean)false, (int)1);
        this.hierarchyTree = UIUtils.createCheckbox((Composite)advancedSettings, (String)TeradataMessages.connection_page_checkbox_hierarchy_view_label, (String)TeradataMessages.connection_page_checkbox_hierarchy_view_tip, (boolean)true, (int)1);
        this.hierarchyTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = TeradataConnectionPageAdvanced.this.hierarchyTree.getSelection();
                if (checked) {
                    TeradataConnectionPageAdvanced.this.hideUsers.setSelection(false);
                    TeradataConnectionPageAdvanced.this.hideUsers.setEnabled(false);
                } else {
                    TeradataConnectionPageAdvanced.this.hideUsers.setEnabled(true);
                }
            }
        });
        this.hideUsers = UIUtils.createCheckbox((Composite)advancedSettings, (String)TeradataMessages.connection_page_checkbox_hide_users_label, (String)TeradataMessages.connection_page_checkbox_hide_users_tip, (boolean)false, (int)1);
        this.hideUsers.setEnabled(!this.hierarchyTree.getSelection());
        this.useFormat = UIUtils.createCheckbox((Composite)advancedSettings, (String)TeradataMessages.connection_page_checkbox_use_format_label, (String)TeradataMessages.connection_page_checkbox_use_format_tip, (boolean)true, (int)1);
        this.setControl((Control)composite);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        DBPPreferenceStore teradataPreferences = TeradataActivator.getDefault().getPreferences();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.showAllDatabases.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("show-all-databases")));
        this.hierarchyTree.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("show-db-hierarchically@")));
        this.hideUsers.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("hide-users@")));
        this.useFormat.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("data-format@"), (boolean)teradataPreferences.getBoolean("data-format@")));
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.showAllDatabases != null) {
            connectionInfo.setProviderProperty("show-all-databases", String.valueOf(this.showAllDatabases.getSelection()));
        }
        if (this.hierarchyTree != null) {
            connectionInfo.setProviderProperty("show-db-hierarchically@", String.valueOf(this.hierarchyTree.getSelection()));
        }
        if (this.hideUsers != null) {
            connectionInfo.setProviderProperty("hide-users@", String.valueOf(this.hideUsers.getSelection()));
        }
        if (this.useFormat != null) {
            connectionInfo.setProviderProperty("data-format@", String.valueOf(this.useFormat.getSelection()));
        }
        if (!"teradata_LDAP".equals(connectionInfo.getAuthModelId())) {
            connectionInfo.setProviderProperty("use_ldap_mechanism@", Boolean.FALSE.toString());
        }
        super.saveSettings(dataSource);
    }
}

