/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.csv;

import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.api.FFPropertyInfo;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.utils.csv.CSVReaderNullFieldIndicator;

public final class CsvProperties
extends FFProperties {
    public static final FFPropertyInfo<String> WILDCARD_PROPERTY = CsvProperties.buildWildcardProperty((String)FFIOUtils.wildcardForExtensions((Set)FFDataSourceFormat.CSV.fileExtensions()));
    public static final FFPropertyInfo<Character> SEPARATOR_PROPERTY = FFPropertyInfo.builder().withName("separator").withValue((Object)Character.valueOf(',')).withDescription("The delimiter to use for separating entries").withParser(s -> Character.valueOf(s.charAt(0))).build();
    public static final FFPropertyInfo<Character> ESCAPE_CHAR_PROPERTY = FFPropertyInfo.builder().withName("escapeChar").withValue((Object)Character.valueOf('\\')).withDescription("The character to use for escaping a separator or quote").withParser(s -> Character.valueOf(s.charAt(0))).build();
    public static final FFPropertyInfo<Character> QUOTE_CHAR_PROPERTY = FFPropertyInfo.builder().withName("quoteChar").withValue((Object)Character.valueOf('\"')).withDescription("The character to use for quoted elements").withParser(s -> Character.valueOf(s.charAt(0))).build();
    public static final FFPropertyInfo<Boolean> STRICT_QUOTES_PROPERTY = FFPropertyInfo.builder().withName("strictQuotes").withValue((Object)false).withDescription("Sets if characters outside the quotes are ignored").withChoices((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).withParser(Boolean::parseBoolean).build();
    public static final FFPropertyInfo<Boolean> IGNORE_LEADING_WHITESPACE_PROPERTY = FFPropertyInfo.builder().withName("ignoreLeadingWhitespace").withValue((Object)true).withDescription("If true, parser should ignore white space before a quote in a field").withChoices((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).withParser(Boolean::parseBoolean).build();
    public static final FFPropertyInfo<Boolean> IGNORE_QUOTATIONS_PROPERTY = FFPropertyInfo.builder().withName("ignoreQuotations").withValue((Object)false).withDescription("If true, treat quotations like any other character.").withChoices((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).withParser(Boolean::parseBoolean).build();
    public static final FFPropertyInfo<CSVReaderNullFieldIndicator> NULL_FIELD_INDICATOR_PROPERTY = FFPropertyInfo.builder().withName("nullFieldIndicator").withValue((Object)CSVReaderNullFieldIndicator.NEITHER).withDescription("Which field content will be returned as null").withChoices((Object[])CSVReaderNullFieldIndicator.values()).withParser(CSVReaderNullFieldIndicator::valueOf).build();
    public static final FFPropertyInfo<Boolean> TRIM_WHITESPACES_PROPERTY = FFPropertyInfo.builder().withName("trimWhitespaces").withValue((Object)Boolean.TRUE).withDescription("If true, parser should trim whitespaces from the beginning and end of the field").withChoices((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).withParser(Boolean::parseBoolean).build();
    public static final FFPropertyInfo<Boolean> HEADER_PROPERTY = FFPropertyInfo.builder().withName("header").withValue((Object)Boolean.TRUE).withDescription("Header").withChoices((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).withParser(Boolean::parseBoolean).build();
    public static final FFPropertyInfo<Integer> SAMPLE_ROWS_PROPERTY = CsvProperties.buildSampleRowsProperty((int)5);

    public CsvProperties() {
        super(Map.of());
    }

    public CsvProperties(@NotNull Map<String, String> properties) {
        super(properties);
    }

    public CsvProperties(@NotNull Properties properties) {
        super(properties);
    }

    public String wildcard() {
        return (String)this.getProperty(WILDCARD_PROPERTY);
    }

    @NotNull
    public List<FFPropertyInfo<?>> implementationProperties() {
        return List.of(WILDCARD_PROPERTY, SEPARATOR_PROPERTY, ESCAPE_CHAR_PROPERTY, QUOTE_CHAR_PROPERTY, STRICT_QUOTES_PROPERTY, IGNORE_LEADING_WHITESPACE_PROPERTY, IGNORE_QUOTATIONS_PROPERTY, NULL_FIELD_INDICATOR_PROPERTY, TRIM_WHITESPACES_PROPERTY, HEADER_PROPERTY, SAMPLE_ROWS_PROPERTY);
    }

    public char escapeChar() {
        return ((Character)this.getProperty(ESCAPE_CHAR_PROPERTY)).charValue();
    }

    public char quoteChar() {
        return ((Character)this.getProperty(QUOTE_CHAR_PROPERTY)).charValue();
    }

    public char separator() {
        return ((Character)this.getProperty(SEPARATOR_PROPERTY)).charValue();
    }

    public boolean strictQuotes() {
        return (Boolean)this.getProperty(STRICT_QUOTES_PROPERTY);
    }

    public boolean ignoreLeadingWhitespace() {
        return (Boolean)this.getProperty(IGNORE_LEADING_WHITESPACE_PROPERTY);
    }

    public boolean ignoreQuotations() {
        return (Boolean)this.getProperty(IGNORE_QUOTATIONS_PROPERTY);
    }

    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return (CSVReaderNullFieldIndicator)this.getProperty(NULL_FIELD_INDICATOR_PROPERTY);
    }

    public boolean trimWhitespaces() {
        return (Boolean)this.getProperty(TRIM_WHITESPACES_PROPERTY);
    }

    public boolean header() {
        return (Boolean)this.getProperty(HEADER_PROPERTY);
    }

    public int sampleRows() {
        return (Integer)this.getProperty(SAMPLE_ROWS_PROPERTY);
    }
}

