/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.csv;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.csv.CsvCustomReader;
import com.dbeaver.jdbc.files.csv.CsvProperties;
import com.dbeaver.jdbc.files.csv.CsvReaderFactory;
import com.dbeaver.jdbc.files.csv.CsvTableProperties;
import com.dbeaver.jdbc.files.database.FFSQLType;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.utils.FFDataTypeUtils;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import com.dbeaver.jdbc.files.utils.FFMetadataUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;

public class CsvMetadataReader
implements FFDataFileMetadataReader<Object, CsvTableProperties> {
    @NotNull
    private final CsvProperties properties;
    @NotNull
    private final CsvReaderFactory csvReaderFactory;

    public CsvMetadataReader(@NotNull CsvProperties properties, @NotNull CsvReaderFactory csvReaderFactory) {
        this.properties = properties;
        this.csvReaderFactory = csvReaderFactory;
    }

    @NotNull
    public FFTableStructure<Object, CsvTableProperties> getTableStructure(@NotNull FFSchemaName schemaName, @NotNull Path dataPath, @NotNull String tableSourceName) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (CsvCustomReader csvReader = this.csvReaderFactory.createReader(dataPath, this.properties);){
            return new FFTableStructure(this.extractColumns(new FFTableName(schemaName, tableSourceName), csvReader), (FFTableProperties)CsvTableProperties.EMPTY);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public List<String> getTableSourceNames(@NotNull Path dataPath) throws IOException {
        return List.of(FFIOUtils.truncateFileExtension((Path)dataPath));
    }

    @NotNull
    private List<ColumnInfo<Object>> extractColumns(FFTableName tableQualifier, CsvCustomReader csvReader) throws IOException {
        String[] header;
        String[] firstRow = csvReader.readRow();
        if (firstRow == null) {
            return List.of();
        }
        ArrayList<String[]> sampleRows = new ArrayList<String[]>();
        if (this.properties.header()) {
            header = FFMetadataUtils.normalizeColumnNames((String[])firstRow);
        } else {
            header = FFMetadataUtils.generateColumnNames((int)firstRow.length);
            sampleRows.add(firstRow);
        }
        while (sampleRows.size() < this.properties.sampleRows()) {
            String[] values = csvReader.readRow();
            if (values == null) break;
            sampleRows.add(values);
        }
        SQLType[] dataTypes = this.inferDataTypes(sampleRows, header.length);
        ArrayList<ColumnInfo<Object>> columns = new ArrayList<ColumnInfo<Object>>(header.length);
        int i = 0;
        while (i < header.length) {
            columns.add(i, (ColumnInfo<Object>)new ColumnInfo(tableQualifier.schema().name(), tableQualifier.name(), header[i], header[i], (SQLType)(dataTypes[i] == null ? FFSQLType.VARCHAR : dataTypes[i]), value -> value));
            ++i;
        }
        return columns;
    }

    @NotNull
    private SQLType[] inferDataTypes(List<String[]> sampleRows, int columnCount) {
        SQLType[] dataTypes = new SQLType[columnCount];
        block0: for (String[] row : sampleRows) {
            SQLType[] rowTypes = this.defineDataTypes(row);
            int j = 0;
            while (j < rowTypes.length) {
                if (j >= dataTypes.length) continue block0;
                dataTypes[j] = dataTypes[j] == null ? rowTypes[j] : FFDataTypeUtils.determineCommonDataType((SQLType)dataTypes[j], (SQLType)rowTypes[j]);
                ++j;
            }
        }
        return dataTypes;
    }

    @NotNull
    private SQLType[] defineDataTypes(@NotNull String[] values) {
        SQLType[] dataTypes = new SQLType[values.length];
        int i = 0;
        while (i < values.length) {
            dataTypes[i] = FFDataTypeUtils.determineDataType((String)values[i]);
            ++i;
        }
        return dataTypes;
    }
}

