/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.csv;

import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.FFDataSourceScanner;
import com.dbeaver.jdbc.files.FFDataSourceScannerFactory;
import com.dbeaver.jdbc.files.FFDataSourceScannerImpl;
import com.dbeaver.jdbc.files.FFExternalMetadataReader;
import com.dbeaver.jdbc.files.FFExternalMetadataReaderImpl;
import com.dbeaver.jdbc.files.FFFileScannerFactory;
import com.dbeaver.jdbc.files.FFFileScannerImpl;
import com.dbeaver.jdbc.files.FFOrderMappingStrategy;
import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.FFStructureMappingStrategy;
import com.dbeaver.jdbc.files.FFTableNameFactory;
import com.dbeaver.jdbc.files.FFTablePropertiesParser;
import com.dbeaver.jdbc.files.FFTableReaderFactory;
import com.dbeaver.jdbc.files.GenericTableNameFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.api.FFDatabaseMetaData;
import com.dbeaver.jdbc.files.api.FFJdbcDriver;
import com.dbeaver.jdbc.files.csv.CsvDatabaseMetaData;
import com.dbeaver.jdbc.files.csv.CsvMetadataReader;
import com.dbeaver.jdbc.files.csv.CsvProperties;
import com.dbeaver.jdbc.files.csv.CsvReaderFactory;
import com.dbeaver.jdbc.files.csv.CsvTableProperties;
import com.dbeaver.jdbc.files.csv.CsvTablePropertiesParser;
import com.dbeaver.jdbc.files.csv.CsvTableReaderFactory;
import com.dbeaver.jdbc.files.database.FFDatabase;
import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.jkiss.code.NotNull;

public class CsvJdbcDriver
extends FFJdbcDriver<Object, CsvTableProperties, CsvProperties> {
    public static final String DRIVER_NAME = "DBeaver CSV JDBC Driver";
    public static final String DRIVER_PREFIX = "jdbc:dbeaver:file:csv:";
    public static final int DRIVER_VERSION_MAJOR = 1;
    public static final int DRIVER_VERSION_MINOR = 0;

    static {
        try {
            DriverManager.registerDriver((Driver)((Object)new CsvJdbcDriver()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error registering driver", e);
        }
    }

    public CsvJdbcDriver() {
        super(DRIVER_PREFIX, 1, 0);
    }

    @NotNull
    public String getDriverIdentifier() {
        return DRIVER_NAME;
    }

    @NotNull
    protected FFDatabaseMetaData createDatabaseMetaData(@NotNull FFConnection connection, @NotNull String url, @NotNull FFDatabase database) {
        return new CsvDatabaseMetaData(connection, url, database, this.getPropertiesFactory());
    }

    @NotNull
    public FFDataSourceFormat getSupportedDataSourceFormat() {
        return FFDataSourceFormat.CSV;
    }

    @NotNull
    public FFFileScannerFactory<Object, CsvTableProperties, CsvProperties> getFileScannerFactory() {
        return (dataSource, connectionClosedFuture) -> {
            CsvReaderFactory csvReaderFactory = new CsvReaderFactory();
            return new FFFileScannerImpl((FFTableNameFactory)new GenericTableNameFactory(dataSource), (FFDataFileMetadataReader)new CsvMetadataReader((CsvProperties)dataSource.properties(), csvReaderFactory), (FFExternalMetadataReader)new FFExternalMetadataReaderImpl((FFTablePropertiesParser)new CsvTablePropertiesParser()), (FFTableReaderFactory)new CsvTableReaderFactory(csvReaderFactory, (CsvProperties)dataSource.properties()), (FFStructureMappingStrategy)new FFOrderMappingStrategy());
        };
    }

    @NotNull
    public FFDataSourceScannerFactory<Object, CsvTableProperties, CsvProperties> getDataSourceScannerFactory() {
        return new FFDataSourceScannerFactory<Object, CsvTableProperties, CsvProperties>(){

            @NotNull
            public FFDataSourceScanner<Object, CsvTableProperties, CsvProperties> createDataSourceScanner(@NotNull FFDataSource<CsvProperties> dataSource, @NotNull CompletableFuture<Void> connectionClosedFuture) throws IOException {
                return new FFDataSourceScannerImpl(CsvJdbcDriver.this.getFileScannerFactory().createScanner(dataSource, connectionClosedFuture));
            }
        };
    }

    @NotNull
    public FFPropertiesFactory<CsvProperties> getPropertiesFactory() {
        return new FFPropertiesFactory<CsvProperties>(){

            public CsvProperties createProperties(Properties properties) {
                return new CsvProperties(properties);
            }

            public CsvProperties createProperties(Map<String, String> properties) {
                return new CsvProperties(properties);
            }
        };
    }
}

