/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import java.io.IOException;

class UTF16State {
    int current = 0;
    int left = 0;
    byte[] tmp = new byte[3];
    char[] carr;

    UTF16State(char[] carr) {
        this.carr = carr;
    }

    UTF16State(char c) {
        this.carr = new char[1];
        this.carr[0] = c;
    }

    boolean more() {
        return this.current < this.carr.length || this.left > 0;
    }

    private char nextChar() throws IOException {
        if (this.current < this.carr.length) {
            return this.carr[this.current++];
        }
        throw new IOException("invalid UTF16");
    }

    private int nextUTF32Char() throws IOException {
        char sp1 = this.nextChar();
        if (sp1 < '\ud800' || sp1 >= '\ue000') {
            return sp1;
        }
        if (sp1 >= '\udc00') {
            throw new IOException("invalid surrogate pair value, first missing");
        }
        char sp2 = this.nextChar();
        if (sp2 < '\udc00' || sp2 >= '\ue000') {
            throw new IOException("invalid surrogate pair value, second missing");
        }
        return 65536 + ((sp1 & 0x3FF) << 10) + (sp2 & 0x3FF);
    }

    private byte push(int n, int c) {
        for (int ii = 0; ii < n; ++ii) {
            this.tmp[this.left++] = (byte)(0x80 | c & 0x3F);
            c >>= 6;
        }
        return (byte)c;
    }

    byte nextByte() throws IOException {
        if (this.left > 0) {
            return this.tmp[--this.left];
        }
        int i = this.nextUTF32Char();
        if (i < 128) {
            return (byte)i;
        }
        if (i < 2048) {
            return (byte)(0xC0 | this.push(1, i));
        }
        if (i < 65536) {
            return (byte)(0xE0 | this.push(2, i));
        }
        if (i < 0x110000) {
            return (byte)(0xF0 | this.push(3, i));
        }
        throw new IOException("invalid character");
    }
}

