/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.DecimalConverter;
import com.raima.rdm.util.RDMConversionException;
import com.raima.rdm.util.RDMHostInfo;
import com.raima.rdm.util.UTF8;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.UUID;

public class RPC {
    Socket socket;
    DataInputStream in;
    DataOutputStream out;

    public RPC(RDMHostInfo hostinfo) throws UnknownHostException, IOException {
        this.socket = new Socket(hostinfo.host, hostinfo.port);
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        this.in = null;
        this.out = null;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public byte getInt8() throws IOException {
        return this.in.readByte();
    }

    public short getInt16() throws IOException {
        return this.in.readShort();
    }

    public int getInt32() throws IOException {
        return this.in.readInt();
    }

    public long getInt64() throws IOException {
        return this.in.readLong();
    }

    public float getFloat() throws IOException {
        return this.in.readFloat();
    }

    public double getDouble() throws IOException {
        return this.in.readDouble();
    }

    public BigDecimal getDecimal() throws IOException {
        try {
            return DecimalConverter.bcdToDecimal(this.getByteArray(37));
        }
        catch (RDMConversionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public UUID getGuid() throws IOException {
        byte[] barr = this.getByteArray(16);
        long hival = 0L;
        long loval = 0L;
        for (int ii = 0; ii < 8; ++ii) {
            hival <<= 8;
            hival |= (long)(barr[ii] & 0xFF);
            loval <<= 8;
            loval |= (long)(barr[ii + 8] & 0xFF);
        }
        return new UUID(hival, loval);
    }

    public byte[] getByteArray(int len) throws IOException {
        byte[] barr = new byte[len];
        if (this.in.read(barr, 0, len) != len) {
            throw new IOException("Insufficient data available");
        }
        return barr;
    }

    public byte[] getBytes() throws IOException {
        return this.getByteArray(this.in.readInt());
    }

    public int getBytes(byte[] barr) throws IOException {
        int len = this.in.readInt();
        if (len > barr.length) {
            throw new IOException("Insufficient buffer supplied");
        }
        if (this.in.read(barr, 0, len) != len) {
            throw new IOException("Insufficient data available");
        }
        return len;
    }

    public String getString() throws IOException {
        return UTF8.convertFromUTF8(this.getBytes());
    }

    public void sendInt8(byte b) throws IOException {
        this.out.writeByte(b);
    }

    public void sendInt16(short s) throws IOException {
        this.out.writeShort(s);
    }

    public void sendInt32(int i) throws IOException {
        this.out.writeInt(i);
    }

    public void sendInt64(long l) throws IOException {
        this.out.writeLong(l);
    }

    public void sendFloat(float f) throws IOException {
        this.out.writeFloat(f);
    }

    public void sendDouble(double d) throws IOException {
        this.out.writeDouble(d);
    }

    public void sendBytes(byte[] b) throws IOException {
        this.out.writeInt(b.length);
        this.out.write(b, 0, b.length);
    }

    public void sendDecimal(BigDecimal bd) throws IOException {
        try {
            byte[] barr = DecimalConverter.decimalToBCD(bd);
            this.out.write(barr, 0, barr.length);
        }
        catch (RDMConversionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void sendGuid(UUID uuid) throws IOException {
        byte[] barr = new byte[16];
        long hival = uuid.getMostSignificantBits();
        long loval = uuid.getLeastSignificantBits();
        barr[0] = (byte)(hival >> 56 & 0xFFL);
        barr[1] = (byte)(hival >> 48 & 0xFFL);
        barr[2] = (byte)(hival >> 40 & 0xFFL);
        barr[3] = (byte)(hival >> 32 & 0xFFL);
        barr[4] = (byte)(hival >> 24 & 0xFFL);
        barr[5] = (byte)(hival >> 16 & 0xFFL);
        barr[6] = (byte)(hival >> 8 & 0xFFL);
        barr[7] = (byte)(hival & 0xFFL);
        barr[8] = (byte)(loval >> 56 & 0xFFL);
        barr[9] = (byte)(loval >> 48 & 0xFFL);
        barr[10] = (byte)(loval >> 40 & 0xFFL);
        barr[11] = (byte)(loval >> 32 & 0xFFL);
        barr[12] = (byte)(loval >> 24 & 0xFFL);
        barr[13] = (byte)(loval >> 16 & 0xFFL);
        barr[14] = (byte)(loval >> 8 & 0xFFL);
        barr[15] = (byte)(loval & 0xFFL);
        this.out.write(barr, 0, barr.length);
    }

    public void sendFcnID(String s) throws IOException {
        this.out.writeBytes(s);
        this.out.writeByte(13);
        this.out.writeByte(10);
    }

    public void sendString(String s) throws IOException {
        this.sendBytes(UTF8.convertToUTF8(s));
    }
}

