/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.RDMConversionException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalConverter {
    public static byte[] decimalToBCD(BigDecimal bd) throws RDMConversionException {
        int scale;
        int sign = bd.signum();
        if (sign == 0) {
            byte[] barr = new byte[37];
            barr[3] = 1;
            return barr;
        }
        if (sign == -1) {
            bd = bd.negate();
        }
        if (bd.scale() > 32) {
            bd = bd.setScale(32, 4);
        }
        BigInteger bi = bd.unscaledValue();
        for (scale = bd.scale(); scale < 0; ++scale) {
            bi = bi.multiply(BigInteger.TEN);
        }
        char[] chars = bi.toString().toCharArray();
        if (chars.length > 32) {
            throw new RDMConversionException("Invalid BCD value: Precision too large");
        }
        if (scale > 32) {
            throw new RDMConversionException("Invalid BCD value: Scale too large");
        }
        byte[] barr = new byte[37];
        barr[0] = (byte)chars.length;
        barr[1] = (byte)(chars.length - scale);
        barr[3] = (byte)sign;
        for (int ii = 0; ii < chars.length; ++ii) {
            barr[5 + ii] = (byte)(chars[ii] - 48);
        }
        return barr;
    }

    public static BigDecimal bcdToDecimal(byte[] barr) throws RDMConversionException {
        if (barr.length != 37) {
            throw new RDMConversionException("Invalid BCD value: invalid length");
        }
        int prec = barr[0];
        if (prec == 0) {
            return BigDecimal.ZERO;
        }
        int exp = barr[1];
        StringBuilder sb = new StringBuilder();
        if (barr[3] == -1) {
            sb.append('-');
        }
        if (exp < 0) {
            sb.append("0.");
            for (int ii = exp; ii < 0; ++ii) {
                sb.append('0');
            }
        }
        boolean nonzero = false;
        for (int ii = 0; ii <= prec; ++ii) {
            if (nonzero || barr[ii + 4] != 0) {
                sb.append((char)(48 + barr[ii + 4]));
                nonzero = true;
            }
            if (ii != exp || ii >= prec) continue;
            if (!nonzero) {
                sb.append('0');
                nonzero = true;
            }
            sb.append('.');
        }
        return new BigDecimal(sb.toString());
    }
}

