/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.ClobCache;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class ClobHandler {
    private static final int PAGESIZE = 4096;
    private long clobSize;
    private ClobCache cache;

    public ClobHandler() throws IOException {
        this._init();
    }

    public ClobHandler(char[] data) throws IOException {
        this._init();
        this.write(0L, data, 0, data.length);
    }

    public ClobHandler(Reader reader) throws IOException {
        int len;
        this._init();
        long pos = 0L;
        char[] page = new char[4096];
        while ((len = reader.read(page)) > 0) {
            this.write(pos, page, 0, len);
            pos += (long)len;
        }
    }

    private void _init() throws IOException {
        this.cache = new ClobCache(4096);
        this.clobSize = 0L;
    }

    public void close() {
        this.cache.close();
        this.cache = null;
    }

    private int read_chars_from_page(long pageno, int page_offset, char[] data, int data_off, int data_len) throws IOException {
        int chars = Math.min(data_len, 4096 - page_offset);
        char[] page = this.cache.readPage(pageno);
        System.arraycopy(page, page_offset, data, data_off, chars);
        return chars;
    }

    private void validate(long pos, char[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (pos < 0L || len < 0 || off + len < 0 || off + len > b.length || this.cache == null) {
            throw new IOException();
        }
    }

    public int read(long pos, char[] b, int off, int len) throws IOException {
        int chars;
        this.validate(pos, b, off, len);
        if (pos >= this.clobSize) {
            return -1;
        }
        if (pos + (long)len > this.clobSize) {
            len = (int)(this.clobSize - pos);
        }
        int page_offset = (int)(pos % 4096L);
        long pageno = pos / 4096L;
        for (int ii = 0; ii < len; ii += chars) {
            chars = this.read_chars_from_page(pageno, page_offset, b, off, len - ii);
            off += chars;
            ++pageno;
            page_offset = 0;
        }
        return len;
    }

    public int read(long pos, char[] b) throws IOException {
        return this.read(pos, b, 0, b.length);
    }

    public int read(long pos) throws IOException {
        char[] buff = new char[1];
        int chars = this.read(pos, buff, 0, 1);
        if (chars != 1) {
            return -1;
        }
        return buff[0];
    }

    public long size() throws IOException {
        if (this.cache == null) {
            throw new IOException();
        }
        return this.clobSize;
    }

    public void truncate(long pos) throws IOException {
        if (pos < 0L || this.cache == null) {
            throw new IOException();
        }
        int page_offset = (int)(pos % 4096L);
        long pageno = pos / 4096L;
        if (page_offset > 0 && this.cache.exists(pageno)) {
            char[] page = this.cache.readPage(pageno);
            Arrays.fill(page, page_offset, 4096, ' ');
            this.cache.writePage(pageno, page);
        }
        this.cache.truncate(pageno + 1L);
        this.clobSize = pos;
    }

    private int write_chunk_to_page(long pageno, int page_offset, char[] data, int data_off, int data_len) throws IOException {
        int chars = (int)Math.min((long)data_len, (long)(4096 - page_offset));
        char[] page = this.cache.readPage(pageno);
        System.arraycopy(data, data_off, page, page_offset, chars);
        this.cache.writePage(pageno, page);
        return chars;
    }

    public void write(long pos, char[] data, int off, int len) throws IOException {
        int chars;
        this.validate(pos, data, off, len);
        int page_offset = (int)(pos % 4096L);
        long pageno = pos / 4096L;
        pageno = pos / 4096L;
        page_offset = (int)(pos % 4096L);
        for (int ii = 0; ii < len; ii += chars) {
            chars = this.write_chunk_to_page(pageno, page_offset, data, off, len - ii);
            off += chars;
            ++pageno;
            page_offset = 0;
        }
        if (pos + (long)len > this.clobSize) {
            this.clobSize = pos + (long)len;
        }
    }

    public void write(long pos, char data) throws IOException {
        char[] carr = new char[]{data};
        this.write(pos, carr, 0, 1);
    }

    public void write(long pos, char[] data) throws IOException {
        this.write(pos, data, 0, data.length);
    }
}

