/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.DateTimeConverter;
import com.raima.rdm.sql.RSQLColumn;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMInvalidColumnTypeException;
import com.raima.rdm.util.RPC;
import com.raima.rdm.util.StringInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public class RSQLTimeColumn
implements RSQLColumn {
    int time;

    public RSQLTimeColumn(int tm) {
        this.time = tm;
    }

    public RSQLTimeColumn(Time tm) throws RDMException {
        this.time = DateTimeConverter.RTimeFromTime(Calendar.getInstance(TimeZone.getDefault()), tm);
    }

    public RSQLTimeColumn(Time tm, Calendar cal) throws RDMException {
        this.time = DateTimeConverter.RTimeFromTime(cal, tm);
    }

    @Override
    public boolean isNull() throws RDMException {
        return false;
    }

    @Override
    public String getString() throws RDMException {
        return this.getTime().toString();
    }

    @Override
    public byte[] getBytes() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public boolean getBoolean() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public byte getByte() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public short getShort() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public int getInt() throws RDMException {
        return this.time;
    }

    @Override
    public long getLong() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public float getFloat() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public double getDouble() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public BigDecimal getBigDecimal() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Date getDate() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Date getDate(Calendar cal) throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Time getTime() throws RDMException {
        return this.getTime(Calendar.getInstance(TimeZone.getDefault()));
    }

    @Override
    public Time getTime(Calendar cal) throws RDMException {
        return DateTimeConverter.TimeFromRTime(cal, this.time);
    }

    @Override
    public Timestamp getTimestamp() throws RDMException {
        return this.getTimestamp(Calendar.getInstance(TimeZone.getDefault()));
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws RDMException {
        return DateTimeConverter.TimestampFromRTimestamp(cal, 1, this.time);
    }

    @Override
    public UUID getUUID() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public InputStream getAsciiStream() throws RDMException {
        return new StringInputStream(this.getString());
    }

    @Override
    public InputStream getBinaryStream() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Reader getCharacterStream() throws RDMException {
        return new StringReader(this.getString());
    }

    @Override
    public Object getObject() throws RDMException {
        return this.getTime();
    }

    public int getInternalTime() {
        return this.time;
    }

    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(516);
        rpc.sendInt32(this.time);
    }
}

