/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQLRowArray;
import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.sql.RSQLTCPRowSet;
import com.raima.rdm.sql.RSQLTCPStatement;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMNoMoreDataException;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.sql.SQLWarning;

public class RSQLTCPRowArray
implements RSQLRowArray {
    private RSQLTCPStatement stmt;
    private long handle;
    private RPC rpc;
    private RSQLRowSet[] rowsets = null;
    private int fetchedRows = 0;
    private int objIdSize;
    private long objId = 0L;
    private byte[] objIdLong = null;

    public RSQLTCPRowArray(RSQLTCPStatement stmt, int fetchOrientation, int rowNumber, int fetchSize, int maxFieldSize) throws RDMException {
        this.stmt = stmt;
        if (stmt == null) {
            throw new RDMSQLException();
        }
        this.rpc = stmt.getRPC();
        this.handle = stmt.getStmtHandle();
        int ret = this.rdmStmtFetchScroll(fetchOrientation, rowNumber, fetchSize, maxFieldSize);
        if (ret == 10012) {
            stmt.addWarning(new SQLWarning("a column was truncated"));
        } else {
            if (ret == 10009) {
                throw new RDMNoMoreDataException();
            }
            if (ret != 0) {
                throw new RDMSQLException(stmt, "rdmStmtFetchScroll()");
            }
        }
    }

    private RSQLRowSet createRow(int row, int maxFieldSize) throws RDMException {
        try {
            short status = this.rpc.getInt16();
            short uno = this.rpc.getInt8();
            if (uno != -1) {
                this.objIdSize = this.rpc.getInt32();
                if (this.objIdSize <= 8) {
                    this.objId = this.rpc.getInt64();
                } else {
                    this.objIdLong = this.rpc.getByteArray(this.objIdSize);
                }
            }
            this.rpc.getInt16();
            if (this.objIdSize <= 8) {
                return new RSQLTCPRowSet(this.stmt, row, uno, this.objId, this.objIdSize, maxFieldSize);
            }
            return new RSQLTCPRowSet(this.stmt, row, uno, this.objIdLong, this.objIdSize, maxFieldSize);
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmStmtFetchScroll(int fetchOrientation, int rowNumber, int fetchSize, int maxFieldSize) throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL FetchScroll");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt16((short)fetchOrientation);
                this.rpc.sendInt32(rowNumber);
                this.rpc.sendInt32(fetchSize);
                this.rpc.sendInt16((short)0);
                this.rpc.flush();
                ret = this.rpc.getInt32();
                if (ret == 0) {
                    this.fetchedRows = this.rpc.getInt32();
                    this.rowsets = new RSQLRowSet[this.fetchedRows];
                    for (int ii = 0; ii < this.fetchedRows; ++ii) {
                        this.rowsets[ii] = this.createRow(ii, maxFieldSize);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O Error: " + e.getMessage());
        }
        return ret;
    }

    @Override
    public RSQLRowSet getRowSet(int index) {
        return this.rowsets[index];
    }

    @Override
    public int getFetchedRows() {
        return this.fetchedRows;
    }
}

