/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQLColumn;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RPC;
import com.raima.rdm.util.StringInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;

public class RSQLStringColumn
implements RSQLColumn {
    private String str;

    public RSQLStringColumn(String str, int max) {
        this.str = max > 0 && str.length() > max ? str.substring(0, max) : str;
    }

    @Override
    public boolean isNull() throws RDMException {
        return false;
    }

    @Override
    public String getString() throws RDMException {
        return this.str;
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromString(this.str);
    }

    @Override
    public boolean getBoolean() throws RDMException {
        return Boolean.parseBoolean(this.str);
    }

    @Override
    public byte getByte() throws RDMException {
        return Byte.parseByte(this.str);
    }

    @Override
    public short getShort() throws RDMException {
        return Short.parseShort(this.str);
    }

    @Override
    public int getInt() throws RDMException {
        return Integer.parseInt(this.str);
    }

    @Override
    public long getLong() throws RDMException {
        return Long.parseLong(this.str);
    }

    @Override
    public float getFloat() throws RDMException {
        return Float.parseFloat(this.str);
    }

    @Override
    public double getDouble() throws RDMException {
        return Double.parseDouble(this.str);
    }

    @Override
    public BigDecimal getBigDecimal() throws RDMException {
        return new BigDecimal(this.str);
    }

    @Override
    public Date getDate() throws RDMException {
        return Date.valueOf(this.str);
    }

    @Override
    public Date getDate(Calendar cal) throws RDMException {
        return Date.valueOf(this.str);
    }

    @Override
    public Time getTime() throws RDMException {
        return Time.valueOf(this.str);
    }

    @Override
    public Time getTime(Calendar cal) throws RDMException {
        return Time.valueOf(this.str);
    }

    @Override
    public Timestamp getTimestamp() throws RDMException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws RDMException {
        return Timestamp.valueOf(this.str);
    }

    @Override
    public UUID getUUID() throws RDMException {
        return UUID.fromString(this.str);
    }

    @Override
    public InputStream getAsciiStream() throws RDMException {
        return new StringInputStream(this.str);
    }

    @Override
    public InputStream getBinaryStream() throws RDMException {
        return new ByteArrayInputStream(this.str.getBytes(Charset.forName("UTF-8")));
    }

    @Override
    public Reader getCharacterStream() throws RDMException {
        return new StringReader(this.str);
    }

    @Override
    public Object getObject() throws RDMException {
        return this.str;
    }

    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(8);
        rpc.sendString(this.str);
    }
}

