/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.DateTimeConverter;
import com.raima.rdm.sql.RSQLColumn;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMInvalidColumnTypeException;
import com.raima.rdm.util.RPC;
import com.raima.rdm.util.StringInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public class RSQLIntColumn
implements RSQLColumn {
    int i;

    public RSQLIntColumn(int i) {
        this.i = i;
    }

    @Override
    public boolean isNull() throws RDMException {
        return false;
    }

    @Override
    public String getString() throws RDMException {
        return Integer.toString(this.i);
    }

    @Override
    public byte[] getBytes() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public boolean getBoolean() throws RDMException {
        return this.i != 0;
    }

    @Override
    public byte getByte() throws RDMException {
        return (byte)this.i;
    }

    @Override
    public short getShort() throws RDMException {
        return (short)this.i;
    }

    @Override
    public int getInt() throws RDMException {
        return this.i;
    }

    @Override
    public long getLong() throws RDMException {
        return this.i;
    }

    @Override
    public float getFloat() throws RDMException {
        return this.i;
    }

    @Override
    public double getDouble() throws RDMException {
        return this.i;
    }

    @Override
    public BigDecimal getBigDecimal() throws RDMException {
        return new BigDecimal(this.i);
    }

    @Override
    public Date getDate() throws RDMException {
        return this.getDate(Calendar.getInstance(TimeZone.getDefault()));
    }

    @Override
    public Date getDate(Calendar cal) throws RDMException {
        return DateTimeConverter.DateFromRDate(cal, this.i);
    }

    @Override
    public Time getTime() throws RDMException {
        return this.getTime(Calendar.getInstance(TimeZone.getDefault()));
    }

    @Override
    public Time getTime(Calendar cal) throws RDMException {
        return DateTimeConverter.TimeFromRTime(cal, this.i);
    }

    @Override
    public Timestamp getTimestamp() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public UUID getUUID() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public InputStream getAsciiStream() throws RDMException {
        return new StringInputStream(this.getString());
    }

    @Override
    public InputStream getBinaryStream() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Reader getCharacterStream() throws RDMException {
        return new StringReader(this.getString());
    }

    @Override
    public Object getObject() throws RDMException {
        return this.i;
    }

    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(514);
        rpc.sendInt32(this.i);
    }
}

