/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLError;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.RDMException;
import java.util.Hashtable;

public class RSQLErrors {
    private static Hashtable<Integer, RSQLError> errorTable = new Hashtable(254, 1.0f);

    private static synchronized RSQLError findError(int err) {
        return errorTable.get(err);
    }

    private static synchronized void addError(int err, RSQLError error) {
        errorTable.put(err, error);
    }

    protected static RSQLError getNotConnectedError() {
        return RSQLErrors.findError(-10001);
    }

    public static RSQLError getCannotConnectError() {
        return RSQLErrors.findError(-18004);
    }

    protected static RSQLError getError(int err) {
        RSQLError error = RSQLErrors.findError(err);
        if (error == null) {
            error = RSQLErrors.findError(-15006);
        }
        return error;
    }

    protected static RSQLError getError(RSQL rsql, int err) throws RDMException {
        RSQLError error = RSQLErrors.findError(err);
        if (error == null) {
            error = rsql.getErrorMsg(err);
            if (error != null) {
                RSQLErrors.addError(err, error);
            } else {
                error = RSQLErrors.findError(-15006);
            }
        }
        return error;
    }

    protected static RSQLError getError(RSQLStatement rsqlStmt, int err) throws RDMException {
        RSQLError error = RSQLErrors.findError(err);
        if (error == null) {
            error = rsqlStmt.getErrorMsg(err);
            if (error != null) {
                RSQLErrors.addError(err, error);
            } else {
                error = RSQLErrors.findError(-15006);
            }
        }
        return error;
    }

    static {
        errorTable.put(29000, new RSQLError("sQA_RDBC_SUCCESS_WITH_INFO", null, "A placeholder for 'SQL_SUCCESS_WITH_INFO'"));
        errorTable.put(10000, new RSQLError("sNOTFOUND", "02000", "Requested item not found"));
        errorTable.put(10001, new RSQLError("sDUPLICATE", "23000", "Duplicate unique key value"));
        errorTable.put(10002, new RSQLError("sTIMEOUT", "HYT00", "Request timed out"));
        errorTable.put(10003, new RSQLError("sUPDATEDPOSITION", null, "Row was updated and is no longer positioned at the exact same position"));
        errorTable.put(10004, new RSQLError("sNOTINCURSOR", null, "Row was updated (unlinked) and is no longer in this cursor"));
        errorTable.put(10005, new RSQLError("sTRABORTED", null, "Transaction was aborted by system"));
        errorTable.put(10006, new RSQLError("sIGNORE", "HY000", "Error can be ignored"));
        errorTable.put(10007, new RSQLError("sOKAYWITHINFO", "00001", "Successful return with info"));
        errorTable.put(10008, new RSQLError("sNEEDDATA", "01000", "Function requires data to be supplied"));
        errorTable.put(10009, new RSQLError("sNODATA", "02000", "No data is available"));
        errorTable.put(10010, new RSQLError("sENDOFCURSOR", "02000", "Reached the end of the cursor collection"));
        errorTable.put(10011, new RSQLError("sEOF", null, "Reached the end of the file or input string"));
        errorTable.put(10012, new RSQLError("sTRUNCATE", "01004", "Result is truncated"));
        errorTable.put(10013, new RSQLError("sREFERENCING", null, "File can be read locally"));
        errorTable.put(10014, new RSQLError("sFILECHANGED", null, "Cached file data is out of date"));
        errorTable.put(10015, new RSQLError("sSKIPTRANS", null, "Transaction should be skipped"));
        errorTable.put(10016, new RSQLError("sNOMOREPAGE", null, "No more page to obtain"));
        errorTable.put(10017, new RSQLError("sSETCLASH", null, "Set pointers invalidated by another user"));
        errorTable.put(10018, new RSQLError("sUPDATEABORTED", null, "An update transaction was aborted when closing the database"));
        errorTable.put(10019, new RSQLError("sSNAPSHOTENDED", null, "A snapshot was closed when closing the database"));
        errorTable.put(10020, new RSQLError("sREADENDED", null, "Read locks were freed when closing the database"));
        errorTable.put(10021, new RSQLError("sTFS_SHUTDOWN", null, "TFS is shutting down"));
        errorTable.put(10022, new RSQLError("sOPTCHANGED", null, "option value changed to default"));
        errorTable.put(10023, new RSQLError("sCMD_USAGE", null, "command usage option"));
        errorTable.put(10024, new RSQLError("sCMD_VERSION", null, "command version option"));
        errorTable.put(10025, new RSQLError("sNULLVAL", null, "The specified column is NULL"));
        errorTable.put(10026, new RSQLError("sEOS", null, "End of set"));
        errorTable.put(10029, new RSQLError("sSCHEMACHANGE", null, "A schema change was detected but the current operation succeeded"));
        errorTable.put(10030, new RSQLError("sUNDERFLOW", null, "Value underflow"));
        errorTable.put(10031, new RSQLError("sPRECISIONLOSS", "22000", "Lost precision for BCD calculation"));
        errorTable.put(10032, new RSQLError("sNOMORERESULTS", "02001", "No additional result sets returned"));
        errorTable.put(10033, new RSQLError("sFETCHBEYOND", "01S06", "Attempt to fetch before the result set returned the first rowset"));
        errorTable.put(10034, new RSQLError("sTRIGGERSREADONLY", null, "The database contains triggers and rdm_dbTriggersOn() or rdm_dbTriggersOff() has not been called so the database is in read-only mode"));
        errorTable.put(10035, new RSQLError("sNODB", "42000", "Database does not exist"));
        errorTable.put(10036, new RSQLError("sKVNOVALUE", null, "The key/value pair does not have a value"));
        errorTable.put(10037, new RSQLError("sOPTIONIGNORED", null, "The option key is valid, but is ignored for a remote TFS"));
        errorTable.put(10038, new RSQLError("sCHILD", null, "The child process is returned from psp_serviceDaemonStart"));
        errorTable.put(10039, new RSQLError("sBASE_QUEUE_CLOSED", null, "No more messages and the queue is closed"));
        errorTable.put(10040, new RSQLError("sBASE_QUEUE_EMPTY", null, "Timed out. Queue is empty, try again later"));
        errorTable.put(10042, new RSQLError("sINDETERMINATE", null, "The comparison result is indeterminate"));
        errorTable.put(10043, new RSQLError("sBASE_DONE", null, "Parsing done"));
        errorTable.put(10044, new RSQLError("sPACK_FILE_NOT_OPEN", null, "The pack file is not open on the client side"));
        errorTable.put(10045, new RSQLError("sFILE_CONSOLE_UTF8", null, "The file is a Windows Console using UTF-8. Use psp_fileConsoleRead and psp_fileConsoleWrite"));
        errorTable.put(10046, new RSQLError("sFILE_CONSOLE_UTF16", null, "The file is a Windows Console using UTF-16. Use psp_fileConsoleRead and psp_fileConsoleWrite"));
        errorTable.put(10047, new RSQLError("sREPLICATEDONE", null, "The replication target has caught up with the replication source"));
        errorTable.put(10048, new RSQLError("sREPLICATECOMMIT", null, "The replication target has committed a transaction that now is available to its clients"));
        errorTable.put(10049, new RSQLError("sREPLICATEUNSAFE", null, "The replication target is to fare behind for the replication to be entirely safe"));
        errorTable.put(0, new RSQLError("sOKAY", null, "Normal, successful return"));
        errorTable.put(-1, new RSQLError("eFAIL", null, "General failure"));
        errorTable.put(-10000, new RSQLError("eNOMEMORY", "HY001", "Out of memory"));
        errorTable.put(-10001, new RSQLError("eDBNOTOPEN", "3D000", "Database not open"));
        errorTable.put(-10002, new RSQLError("eDBOPEN", "82117", "Database already opened in this task"));
        errorTable.put(-10003, new RSQLError("eEXCLUSIVE", null, "Exclusive access required"));
        errorTable.put(-10004, new RSQLError("eBADCAT", "42000", "Bad catalog (error trying to read catalog file)"));
        errorTable.put(-10005, new RSQLError("eSQLRESERVED", null, "Can't use a SQL reserved word as identifier"));
        errorTable.put(-10006, new RSQLError("eTRACTIVE", "25001", "Transaction is active"));
        errorTable.put(-10007, new RSQLError("eTRNOTACT", "25000", "Transaction not active"));
        errorTable.put(-10008, new RSQLError("eNOSTART", "25005", "No rdm_dbStartRead(), rdm_dbStartSnapshot(), or rdm_dbStartUpdate() is active"));
        errorTable.put(-10009, new RSQLError("eNOSTARTUPDATE", "25005", "An update operation was attempted when no rdm_dbStartUpdate() is active"));
        errorTable.put(-10010, new RSQLError("eNOSTARTREAD", "25005", "A read operation was attempted when no rdm_dbStartSnapshot(), rdm_dbStartRead(), or rdm_dbStartUpdate() is active"));
        errorTable.put(-10011, new RSQLError("eNOTLOCKED", "25000", "Attempt to access a table for reading or update without proper locks"));
        errorTable.put(-10012, new RSQLError("eNOTFREE", "25000", "Attempt to lock already locked table"));
        errorTable.put(-10013, new RSQLError("eDUPLICATE", "40002", "Attempt to insert a duplicate value as a unique/primary key"));
        errorTable.put(-10014, new RSQLError("eREFINTEGRITY", "40002", "Integrity constraint violation"));
        errorTable.put(-10015, new RSQLError("eCHECK", "40002", "Check clause violation"));
        errorTable.put(-10016, new RSQLError("eNODB", "42000", "Database not found"));
        errorTable.put(-10017, new RSQLError("eSNAPSHOTACTIVE", "25006", "Snapshot is active"));
        errorTable.put(-10018, new RSQLError("eSNAPSHOTNOTACTIVE", "25005", "Snapshot is not active"));
        errorTable.put(-10019, new RSQLError("eOPENMODE", "42000", "Invalid db open mode"));
        errorTable.put(-10020, new RSQLError("eNOTIMPLEMENTED", "HYC00", "Function/feature not implemented"));
        errorTable.put(-10021, new RSQLError("eINVFCNARG", null, "Invalid function argument"));
        errorTable.put(-10022, new RSQLError("eINVNULLARG", "HY009", "Function argument cannot be NULL"));
        errorTable.put(-10023, new RSQLError("eINVFCNSEQ", "HY010", "Function sequence error"));
        errorTable.put(-10024, new RSQLError("eINVLITERAL", "22005", "Invalid literal constant specification"));
        errorTable.put(-10025, new RSQLError("eMISSINGLITERAL", null, "Syntax error where we expected a literal constant specification"));
        errorTable.put(-10026, new RSQLError("eCIRTABDELETE", null, "Cannot delete rows from a circular table"));
        errorTable.put(-10027, new RSQLError("eNOTNULL", "42000", "Must specify value for column"));
        errorTable.put(-10028, new RSQLError("eFILEIO", null, "File I/O error"));
        errorTable.put(-10029, new RSQLError("eFILEOPEN", null, "Unable to open file"));
        errorTable.put(-10030, new RSQLError("eUNOMISMATCH", null, "Unions mismatch "));
        errorTable.put(-10031, new RSQLError("eNOSPACE", null, "Out of disk space"));
        errorTable.put(-10032, new RSQLError("ePRECOMMITTED", null, "A precommitted transaction must be committed or rolled back before further operations on this database are allowed"));
        errorTable.put(-10033, new RSQLError("eINVDBNAMESPEC", null, "Invalid database name specification"));
        errorTable.put(-10034, new RSQLError("eINVTFSSPEC", null, "Invalid TFS specification"));
        errorTable.put(-10035, new RSQLError("eFILEINUSE", null, "File in use"));
        errorTable.put(-10036, new RSQLError("eTRUNCATED", null, "Date truncated"));
        errorTable.put(-10037, new RSQLError("eBADREAD", null, "Error reading from a file"));
        errorTable.put(-10038, new RSQLError("eBADWRITE", null, "Error writing to a file"));
        errorTable.put(-10039, new RSQLError("eRANGE", "22003", "Numeric value out of range"));
        errorTable.put(-10040, new RSQLError("eINVKEYVALUE", null, "Invalid key/value pair"));
        errorTable.put(-10041, new RSQLError("eINVBCD", null, "Invalid BCD value"));
        errorTable.put(-10043, new RSQLError("eDUPUSERID", null, "DBUSERID is already in use"));
        errorTable.put(-10044, new RSQLError("eREADONLY", "42000", "Database is read-only and cannot be updated"));
        errorTable.put(-10045, new RSQLError("eMKDIR", null, "Unable to create directory"));
        errorTable.put(-10046, new RSQLError("eRECOVERYFAILED", null, "Recovery failed"));
        errorTable.put(-10047, new RSQLError("eNOTFOUND", null, "Not found"));
        errorTable.put(-10048, new RSQLError("eSYNTAX", "42000", "Syntax error"));
        errorTable.put(-10049, new RSQLError("eBADDATALEN", "HY090", "Invalid string or buffer length"));
        errorTable.put(-10050, new RSQLError("eINVROWIDVAL", null, "Invalid rowid value"));
        errorTable.put(-10051, new RSQLError("eVALUEISLIST", null, "Attempted to retrieve a single value where the actual value is a list"));
        errorTable.put(-10052, new RSQLError("eINVVARINT", null, "Invalid variable integer value"));
        errorTable.put(-10053, new RSQLError("eDATALOST", null, "Significant data lost due to truncation"));
        errorTable.put(-10054, new RSQLError("eINVBINLITERAL", null, "Invalid binary literal specification"));
        errorTable.put(-10055, new RSQLError("eTYPEMISMATCH", "42000", "Data type mismatch"));
        errorTable.put(-10056, new RSQLError("eROWIDRANGE", null, "RowId value out of range"));
        errorTable.put(-10057, new RSQLError("eROWIDMISMATCH", null, "The specified RowId does not match the Primary Key RowId value"));
        errorTable.put(-10058, new RSQLError("eROWLIMIT", null, "Table row limit reached"));
        errorTable.put(-10059, new RSQLError("eINVCONVERT", "HYC00", "Invalid data type conversion"));
        errorTable.put(-10060, new RSQLError("eINVUTF", null, "Invalid UTF string"));
        errorTable.put(-10061, new RSQLError("eINVOPTION", "HY092", "Invalid option identifier is specified"));
        errorTable.put(-10062, new RSQLError("eINVOPTIONVALUE", null, "Invalid option value"));
        errorTable.put(-10063, new RSQLError("eDBNOTCLOSED", null, "Option requires database to be closed"));
        errorTable.put(-10064, new RSQLError("eINVARG", "22000", "Invalid argument"));
        errorTable.put(-10065, new RSQLError("eINVARGTYPE", "22000", "Invalid argument type"));
        errorTable.put(-10066, new RSQLError("eINVTRID", "25000", "Invalid transaction id"));
        errorTable.put(-10067, new RSQLError("eNOTSUPPORTED", "IM001", "Function not supported"));
        errorTable.put(-10068, new RSQLError("eNOTROOTUPDATETRANS", null, "You can only precommit the root update transaction"));
        errorTable.put(-10069, new RSQLError("eESCAPE", "42000", "Escape clause syntax error"));
        errorTable.put(-10071, new RSQLError("eDBEXISTS", "42000", "Database already exists"));
        errorTable.put(-10072, new RSQLError("eEOD", null, "Insufficient data"));
        errorTable.put(-10073, new RSQLError("eINVID", null, "Invalid 'internals' id"));
        errorTable.put(-10074, new RSQLError("eINVUNICODE", null, "Invalid Unicode string"));
        errorTable.put(-10075, new RSQLError("eCOLCOUNTMISMATCH", null, "Invalid number column values provided for the table"));
        errorTable.put(-10076, new RSQLError("eKEYCOLCOUNTMISMATCH", null, "Invalid number column values provided for the key"));
        errorTable.put(-10077, new RSQLError("eHASMEMBERS", "23000", "Referential Integrity error - row is referenced by other rows"));
        errorTable.put(-10078, new RSQLError("eDEPRECATED", null, "This feature is deprecated"));
        errorTable.put(-10079, new RSQLError("eINVTIMEOUT", null, "Invalid timeout value"));
        errorTable.put(-10080, new RSQLError("eLEGACYAPI", null, "Call to a legacy API from a database handle not opened in legacy mode"));
        errorTable.put(-10081, new RSQLError("eLEGACYDB", null, "Call non-legacy API from a database handle opened in legacy mode"));
        errorTable.put(-10082, new RSQLError("eINMEMMISMATCH", null, "Attempting to open a database that is already open with differing in-memory options"));
        errorTable.put(-10083, new RSQLError("eBADWILDALL", "42000", "Bad wild all character (must be '%' or '*')"));
        errorTable.put(-10084, new RSQLError("eBADWILDONE", "42000", "Bad wild one character (must be '_', '.', or '?')"));
        errorTable.put(-10085, new RSQLError("eBADSNAPSHOTMODE", "25S01", "Invalid snapshot mode"));
        errorTable.put(-10086, new RSQLError("eINVHANDLE", "02002", "Invalid handle"));
        errorTable.put(-10087, new RSQLError("eINVSQLTYPE", "HY004", "Invalid SQL data type"));
        errorTable.put(-10088, new RSQLError("eCONNNOTOPEN", "08003", "Connection is not open"));
        errorTable.put(-10089, new RSQLError("eDIVBY0", "22012", "Division by zero"));
        errorTable.put(-10090, new RSQLError("eNOTANUMBER", null, "A calculation returned not a number"));
        errorTable.put(-10091, new RSQLError("eINVALID", null, "Invalid encoding"));
        errorTable.put(-10092, new RSQLError("eUNAVAIL", "HYT00", "Requested resource not available"));
        errorTable.put(-10093, new RSQLError("eTABNOTFOUND", "42S02", "Table not declared"));
        errorTable.put(-10094, new RSQLError("eCOLNOTFOUND", "42S22", "Column not declared"));
        errorTable.put(-10096, new RSQLError("eINSERTVALS", "21S01", "Insert value list does not match column list"));
        errorTable.put(-10097, new RSQLError("eINVTRIGSTMT", "0W000", "Prohibited statement encountered during trigger execution"));
        errorTable.put(-10098, new RSQLError("eNOSTATS", null, "No statistics is associated with this database"));
        errorTable.put(-10099, new RSQLError("eDROPONLYCOL", "42000", "Illegal attempt to drop the only column of the table"));
        errorTable.put(-10100, new RSQLError("eTFSOPTIONINIT", null, "Option specified can only be specified before initializing a TFS handle"));
        errorTable.put(-10102, new RSQLError("eINVINFOKEY", null, "Invalid information key value"));
        errorTable.put(-10103, new RSQLError("eDBCORRUPTED", "42000", "Database corruption"));
        errorTable.put(-10104, new RSQLError("eDROPTRIGCOL", "42000", "Illegal attempt to drop a column referenced by trigger"));
        errorTable.put(-10105, new RSQLError("eREALLOCMEMORY", "HY001", "Reallocation of huge memory buffers not supported"));
        errorTable.put(-10106, new RSQLError("eNOUPDATE", null, "Transaction handle does not refer to an update transaction"));
        errorTable.put(-10107, new RSQLError("eFILEACCESS", null, "Unable to open file due to access restrictions"));
        errorTable.put(-10108, new RSQLError("eFILEEXIST", null, "Unable to create file due to an already existing file"));
        errorTable.put(-10109, new RSQLError("eFILENOENTRY", null, "Unable to open file since it does not exist"));
        errorTable.put(-10110, new RSQLError("eFILEISDIR", null, "File is a directory"));
        errorTable.put(-10111, new RSQLError("eEOF", null, "Reached the end of the file or input string"));
        errorTable.put(-10112, new RSQLError("eBROKENPIPE", null, "Failed to read or write since the other end have closed the connection"));
        errorTable.put(-10114, new RSQLError("eBADCATVER", "42000", "Bad catalog version (catalog version incompatible with the runtime)"));
        errorTable.put(-10115, new RSQLError("eALREADYLOCKED", null, "The table is already locked. This is only being returned to the inline vacuumer when user already has the table locked"));
        errorTable.put(-10116, new RSQLError("eWRITEPANIC", null, "The database engine have shut down updates due to a severe error"));
        errorTable.put(-10117, new RSQLError("eTABLENOROWID", null, "Table does not contain a rowid value"));
        errorTable.put(-10118, new RSQLError("eUPDPRIKEY", null, "UPDATE of a column in a primary key is not allowed"));
        errorTable.put(-10119, new RSQLError("eINVRTREEVALUE", null, "Invalid column value for a RTREE index"));
        errorTable.put(-11000, new RSQLError("eBASE_INVDATE", null, "Invalid date value"));
        errorTable.put(-11001, new RSQLError("eBASE_INVTIMEZONE", null, "Invalid time zone value"));
        errorTable.put(-11002, new RSQLError("eBASE_COMMAND", null, "Command line argument processor error"));
        errorTable.put(-11003, new RSQLError("eBASE_QUEUE_CLOSED", null, "No more messages can be written since the queue is closed"));
        errorTable.put(-12000, new RSQLError("eDEFUNCT", null, "Function no longer supported/defunct"));
        errorTable.put(-12001, new RSQLError("eINVTASKID", null, "Invalid task id"));
        errorTable.put(-12002, new RSQLError("eINVDBID", null, "Invalid db id"));
        errorTable.put(-12003, new RSQLError("eINVCURSORID", null, "Invalid cursor id"));
        errorTable.put(-12004, new RSQLError("eINVTRANSID", null, "Invalid transaction id"));
        errorTable.put(-12005, new RSQLError("eNOTRANSID", null, "No transaction id specified"));
        errorTable.put(-12006, new RSQLError("eCURSORDB", null, "Cursor is associated with a different database"));
        errorTable.put(-12007, new RSQLError("eINVTFSID", null, "Invalid TFS id"));
        errorTable.put(-12008, new RSQLError("eINVFORUNION", null, "Invalid operation on unioned db"));
        errorTable.put(-12009, new RSQLError("eNOTKEY", null, "Column is not a key"));
        errorTable.put(-12010, new RSQLError("eNOTBLOB", null, "Column is not a BLOB or CLOB"));
        errorTable.put(-12011, new RSQLError("eINVLOCKTYPE", null, "Invalid lock type"));
        errorTable.put(-12012, new RSQLError("eINVKEYID", null, "Invalid key id"));
        errorTable.put(-12013, new RSQLError("eKEYREQD", null, "Key value required"));
        errorTable.put(-12014, new RSQLError("eINVCOLID", null, "Invalid column id"));
        errorTable.put(-12015, new RSQLError("eINVTABID", null, "Invalid table id"));
        errorTable.put(-12016, new RSQLError("eINVREFID", null, "Invalid reference (set) id number"));
        errorTable.put(-12017, new RSQLError("eINVIDENTIFIER", null, "Invalid id value"));
        errorTable.put(-12018, new RSQLError("eINVCURSOROP", null, "Invalid operation for this cursor"));
        errorTable.put(-12019, new RSQLError("eDELETED", null, "The current row has been deleted"));
        errorTable.put(-12020, new RSQLError("eOWNERDELETED", null, "The owner row for a set cursor has been deleted"));
        errorTable.put(-12021, new RSQLError("eSINGLETONDELETED", null, "The row for a singleton cursor has been deleted"));
        errorTable.put(-12022, new RSQLError("eNOTOWNER", null, "The cursor's rows are not owners of the specified set"));
        errorTable.put(-12023, new RSQLError("eNOTMEMBER", null, "The cursor's rows are not members of the specified set"));
        errorTable.put(-12024, new RSQLError("eNOTRELATED", null, "Items are not related"));
        errorTable.put(-12025, new RSQLError("eNOCURRENTROW", null, "The cursor is not positioned to a valid row"));
        errorTable.put(-12026, new RSQLError("eNOCURRENTOWNER", null, "No current owner row"));
        errorTable.put(-12027, new RSQLError("eNOCURRENTMEMBER", null, "No current member row"));
        errorTable.put(-12028, new RSQLError("eNOTLINKED", null, "The cursor is positioned to a row that is not linked to the specified reference id"));
        errorTable.put(-12029, new RSQLError("eINVITERATION", null, "Invalid attempt to move cursor before 'BeforeFirst' or past 'AfterLast'"));
        errorTable.put(-12030, new RSQLError("eLOSTPOSITION", null, "Cursor position was lost and must be reset"));
        errorTable.put(-12031, new RSQLError("eINVCURSORCOL", null, "The specified column is not in the table the cursor is associated with"));
        errorTable.put(-12032, new RSQLError("eINVCURSORKEY", null, "The specified key is not in the table the cursor is associated with"));
        errorTable.put(-12033, new RSQLError("eNOTINCURSOR", null, "The row is not in the cursor"));
        errorTable.put(-12034, new RSQLError("eBLOBBADSIZE", null, "Not enough data in the blob to satisfy the read request"));
        errorTable.put(-12035, new RSQLError("eBLOBBADPOSITION", null, "Invalid blob offset position"));
        errorTable.put(-12036, new RSQLError("eHASOWNER", null, "The row references other rows"));
        errorTable.put(-12037, new RSQLError("eISOWNED", null, "The member row is already owned"));
        errorTable.put(-12038, new RSQLError("eEOS", null, "End of set"));
        errorTable.put(-12039, new RSQLError("eISCOMPOUNDKEY", null, "Column is a compound key"));
        errorTable.put(-12040, new RSQLError("eCOMPOUNDKEY", null, "Column is in a compound key"));
        errorTable.put(-12041, new RSQLError("eKEYERR", null, "Key inconsistency detected"));
        errorTable.put(-12042, new RSQLError("eKEYSEQ", null, "Field type used out of sequence in d_keynext"));
        errorTable.put(-12043, new RSQLError("eVARDATALEN", null, "Vardata length inconsistency"));
        errorTable.put(-12044, new RSQLError("eVARDATAPTR", null, "Vardata pointer inconsistency"));
        errorTable.put(-12045, new RSQLError("eTRFREE", null, "Attempt to free a lock inside a transaction"));
        errorTable.put(-12046, new RSQLError("eBADLOCKS", null, "Inconsistent database locks"));
        errorTable.put(-12049, new RSQLError("eINVKEYSPEC", null, "Invalid key specification"));
        errorTable.put(-12051, new RSQLError("eSLAVEREADONLY", null, "Attempted to open a slave database in non-readonly mode"));
        errorTable.put(-12052, new RSQLError("eDEBUG", null, "Debugging check interrupt"));
        errorTable.put(-12053, new RSQLError("eINVENCRYPT", "28000", "Invalid encryption key"));
        errorTable.put(-12054, new RSQLError("eENCRYPTMISMATCH", null, "Encryption passcodes do not match"));
        errorTable.put(-12055, new RSQLError("eSETPAGES", null, "Error in d_setpages (database open or bad param)"));
        errorTable.put(-12056, new RSQLError("eINVFILE", null, "Invalid file type for operation"));
        errorTable.put(-12057, new RSQLError("eREP_INVOP", null, "Invalid operation during replication"));
        errorTable.put(-12058, new RSQLError("eDBDREAD", null, "Error reading dbd file"));
        errorTable.put(-12059, new RSQLError("eINVENDIAN", null, "Invalid endian format"));
        errorTable.put(-12060, new RSQLError("eINVSTRING", null, "Invalid string format"));
        errorTable.put(-12061, new RSQLError("eINVDBA", null, "Invalid dba format"));
        errorTable.put(-12062, new RSQLError("eCATMISMATCH", null, "Catalog in memory does not match Catalog on disk"));
        errorTable.put(-12063, new RSQLError("eSCHEMACHANGE", null, "A schema change was detected and the current operation was not successful"));
        errorTable.put(-12064, new RSQLError("eDBD_NONAMES", null, "Incompatible legacy DBD file - does not contain record/field/set name"));
        errorTable.put(-12065, new RSQLError("eNOT_ENCRYPTED", null, "The database is not encrypted"));
        errorTable.put(-12066, new RSQLError("eREPLOG_ERROR", null, "Error processing/reading/creating/writing the replication log"));
        errorTable.put(-12067, new RSQLError("eREPLOG_EOF", null, "EOF for replication log file"));
        errorTable.put(-12068, new RSQLError("eINVDB", null, "Invalid database"));
        errorTable.put(-12069, new RSQLError("eIMPBADXML", null, "Bad xml"));
        errorTable.put(-12070, new RSQLError("eIMPBADDATA", null, "Bad data"));
        errorTable.put(-12071, new RSQLError("eMULTIPLE_DBS", null, "Open multiple dbs in one call is not supported by this API, Use multiple calls"));
        errorTable.put(-12072, new RSQLError("eUNIONCATMISMATCH", null, "Unioned databases do not have compatible Catalog structures"));
        errorTable.put(-12073, new RSQLError("eINCOMPAT", null, "Incompatible dictionary file"));
        errorTable.put(-12074, new RSQLError("eINVOPFORBLOB", null, "Invalid operation for a BLOB column"));
        errorTable.put(-12075, new RSQLError("eINVOPENMODE", "42000", "Invalid database open mode"));
        errorTable.put(-12076, new RSQLError("eDBOPENED", null, "Operation not completed because database is open"));
        errorTable.put(-12077, new RSQLError("eNOCURRTYPE", null, "No current table type"));
        errorTable.put(-12078, new RSQLError("eTABLEISINREF", null, "Cannot quick initialize the table because the table is involved in a reference"));
        errorTable.put(-12079, new RSQLError("eNOCOLUMNVALUE", null, "No column value was specified, the column does not have a default, and cannot be null"));
        errorTable.put(-12080, new RSQLError("eNULLCOLUMNVALUE", "HY000", "NULL column value was specified, and the column cannot be null"));
        errorTable.put(-12081, new RSQLError("eINVDATEFMT", "22007", "Invalid date format"));
        errorTable.put(-12082, new RSQLError("eINVDATESEP", "22007", "Invalid date separator"));
        errorTable.put(-12083, new RSQLError("eINVTIMEFMT", null, "Invalid time format"));
        errorTable.put(-12084, new RSQLError("eVTNOTREGISTERED", "HY000", "Reference to unregistered Virtual Table"));
        errorTable.put(-12085, new RSQLError("eMIXEDTRANS", "42000", "DDL and DML transactions cannot be mixed"));
        errorTable.put(-12086, new RSQLError("eINVLOCALE", null, "Invalid collation locale"));
        errorTable.put(-12087, new RSQLError("eLOCALEMISMATCH", "HY000", "Attempt to open database with incorrect (or no) locale"));
        errorTable.put(-12088, new RSQLError("eNOTRTREE", null, "The key specified is not an rtree index"));
        errorTable.put(-12089, new RSQLError("eISRTREE", null, "The key specified is an rtree index"));
        errorTable.put(-12090, new RSQLError("eDROPPED", null, "Attempt to access a cursor based on an item that has been dropped"));
        errorTable.put(-12091, new RSQLError("eINVSTORAGETYPE", "HY092", "Only INMEMORY_LOAD or INMEMORY_PERSIST databases can be persisted"));
        errorTable.put(-12092, new RSQLError("eINNESTEDUPDATE", null, "Function is not allowed from a nested update transaction, it can only be called from the root update transaction"));
        errorTable.put(-12093, new RSQLError("eVACUUMAMOUNT", null, "The amount of data allowed to be vacuumed in one transaction is set to low"));
        errorTable.put(-12094, new RSQLError("eNOREPLICATE", null, "Replication have not been enabled for this DB handle and replication functions can therefore not be called"));
        errorTable.put(-12095, new RSQLError("eREPLICATE", null, "Replication has been enabled for this DB handle and other functions can therefore not be called"));
        errorTable.put(-12096, new RSQLError("eREPLICATESOURCE", null, "Replication source has been enabled for this DB handle and functions for the replication target cannot be called"));
        errorTable.put(-12097, new RSQLError("eREPLICATETARGET", null, "Replication target has been enabled for this DB handle and functions for the replication source cannot be called"));
        errorTable.put(-12098, new RSQLError("eREPLICATEBEHIND", null, "Replication source is behind the replication target"));
        errorTable.put(-12099, new RSQLError("eREPLICATEREADONLY", null, "A database serving as a replication target can only be opened in read only mode"));
        errorTable.put(-12100, new RSQLError("eREPLICATEALREADY", null, "Database is already being served as a replication target"));
        errorTable.put(-12101, new RSQLError("eREPLICATEMISSMATCH", null, "Replication target does not match replication source"));
        errorTable.put(-12102, new RSQLError("eREPLICATESNAPSHOT", null, "A database serving as a replication target can only start snapshots"));
        errorTable.put(-12103, new RSQLError("eDBCORRUPTIONMISSINGFILE", null, "A database file is missing"));
        errorTable.put(-12104, new RSQLError("eDBCORRUPTIONTRUNCATEDFILE", null, "A database file has been truncated from its required size"));
        errorTable.put(-13000, new RSQLError("eTFS_INVHANDLE", null, "Invalid TFS handle"));
        errorTable.put(-13001, new RSQLError("eTFS_INVTYPE", "42000", "Invalid TFS type"));
        errorTable.put(-13002, new RSQLError("eTFS_NOTINITIALIZED", null, "The RDM Transaction File Server (TFS) is not initialized"));
        errorTable.put(-13003, new RSQLError("eTFS_DUPUSER", null, "Duplicate user ID"));
        errorTable.put(-13004, new RSQLError("eTFS_FCNSEQ", null, "Function sequence error"));
        errorTable.put(-13005, new RSQLError("eTFS_ILLEGALMOD", null, "Illegal attempt to modify file(s) on read-only device"));
        errorTable.put(-13006, new RSQLError("eTFS_ILLEGALACCESS", null, "Illegal attempt to access file(s) on diskless system"));
        errorTable.put(-13007, new RSQLError("eTFS_INVDBID", null, "Invalid db id"));
        errorTable.put(-13008, new RSQLError("eTFS_INVUSERID", null, "Invalid user id"));
        errorTable.put(-13012, new RSQLError("eTFS_DOCROOTUSED", null, "The specified docroot is already in use"));
        errorTable.put(-13013, new RSQLError("eTFS_DOCROOTNOTFOUND", null, "The specified docroot location is not found"));
        errorTable.put(-13014, new RSQLError("eTFS_DOCROOTINVALID", null, "The specified docroot location is invalid"));
        errorTable.put(-13016, new RSQLError("eTFS_WRITEFAIL", null, "Failed to write to a file"));
        errorTable.put(-13017, new RSQLError("eTFS_INVFILE", null, "File not found in file table"));
        errorTable.put(-13018, new RSQLError("eTFS_IASYNC_ON", null, "Internal asynchronous mode is enabled"));
        errorTable.put(-13019, new RSQLError("eTFS_BLOCKED", null, "Mirroring is blocking transactions"));
        errorTable.put(-13020, new RSQLError("eTFS_INVOPERATION", null, "Invalid operation for this type of TFS"));
        errorTable.put(-13021, new RSQLError("eTFS_NOTRANS", null, "Transaction not active"));
        errorTable.put(-13022, new RSQLError("eTFS_DBOPEN", null, "Cannot destroy a database that is open by others"));
        errorTable.put(-13023, new RSQLError("eTFS_NOPAGE", null, "Requested page doesn't exist"));
        errorTable.put(-13024, new RSQLError("eTFS_COMMITFAILED", null, "Commit failed due to prelog file rename failure"));
        errorTable.put(-13025, new RSQLError("eTFS_DBINUSE", "3D000", "Database is currently in use"));
        errorTable.put(-13026, new RSQLError("eTFS_INIEDITED", null, "Attempted to edit an INI when it is already being edited"));
        errorTable.put(-13027, new RSQLError("eTFS_ININOTEDITED", null, "Attempted to edit an INI that was not held for editing"));
        errorTable.put(-13028, new RSQLError("eTFS_NAMEINUSE", null, "Name or port already in use"));
        errorTable.put(-13029, new RSQLError("eTFS_NOMIR", null, "Replication/mirroring is not enabled for this TFS library"));
        errorTable.put(-13030, new RSQLError("eTFS_NOSQL", null, "SQL is not enabled for this TFS library"));
        errorTable.put(-13031, new RSQLError("eTFS_NOTFS", null, "TFS is not enabled for this TFS library"));
        errorTable.put(-13032, new RSQLError("eTFS_CONNECT", null, "Failed to connect to TFS"));
        errorTable.put(-13033, new RSQLError("eTFS_ENCNOTINIT", null, "Encryption subsystem is not initialized on the TFS"));
        errorTable.put(-13034, new RSQLError("eTFS_NOREST", null, "RDM REST API is not enabled for this TFS library"));
        errorTable.put(-13036, new RSQLError("eTFS_PACKFILELIMIT", "64000", "The upper limit of the number of pack files allowed reached"));
        errorTable.put(-14000, new RSQLError("ePSP_FAILURE", null, "General failure in the PSP library"));
        errorTable.put(-14001, new RSQLError("ePSP_MUTEX_FAILURE", null, "Mutex failure in the PSP library"));
        errorTable.put(-14003, new RSQLError("ePSP_PRIV", null, "Insufficient privilege"));
        errorTable.put(-14004, new RSQLError("ePSP_INVUSER", null, "Invalid user"));
        errorTable.put(-14005, new RSQLError("ePSP_INVPASS", null, "Invalid password"));
        errorTable.put(-14006, new RSQLError("ePSP_NOSOURCE", null, "Invalid source"));
        errorTable.put(-14007, new RSQLError("ePSP_NODEST", null, "Invalid destination"));
        errorTable.put(-14008, new RSQLError("ePSP_INVUUID", null, "Invalid UUID in the PSP library"));
        errorTable.put(-14009, new RSQLError("ePSP_DEADLOCK", null, "Mutex deadlock in the PSP library"));
        errorTable.put(-14010, new RSQLError("ePSP_TERMINATE", null, "Signal received for termination"));
        errorTable.put(-14501, new RSQLError("eDDL_CRDBACTIVE", "RD001", "A CREATE/ALTER DATABASE is already active"));
        errorTable.put(-14502, new RSQLError("eDDL_WRONGDB", "RD002", "Table must be created in the active database"));
        errorTable.put(-14503, new RSQLError("eDDL_DUPCOLUMN", "42S21", "Column with same name already declared in table"));
        errorTable.put(-14504, new RSQLError("eDDL_NOTWITHDOMAIN", "42000", "Not allowed with columns declared with domain"));
        errorTable.put(-14505, new RSQLError("eDDL_DOMNOTFOUND", "42000", "Domain not declared"));
        errorTable.put(-14506, new RSQLError("eDDL_BADDATATYPE", "42000", "Invalid data type"));
        errorTable.put(-14507, new RSQLError("eDDL_DUPTABNAME", "42S01", "Duplicate table name"));
        errorTable.put(-14508, new RSQLError("eDDL_DUPCOLNAME", "42S21", "Duplicate column name"));
        errorTable.put(-14509, new RSQLError("eDDL_FKMISMATCH", "42000", "Foreign/primary key columns do not match"));
        errorTable.put(-14510, new RSQLError("eDDL_REFNULL", "42000", "A referenced key must have at least one NOT NULL column"));
        errorTable.put(-14511, new RSQLError("eDDL_NOPRIKEY", "42S12", "Referenced table does not have referenced primary key"));
        errorTable.put(-14512, new RSQLError("eDDL_DEFAUTO", "42000", "DEFAULT AUTO is not allowed (only with guid/rowid type)"));
        errorTable.put(-14513, new RSQLError("eDDL_DEFCURRENT", "42000", "DEFAULT CURRENT is not allowed (only with date/time types)"));
        errorTable.put(-14514, new RSQLError("eDDL_BADVARPREC", "22000", "Invalid variable length column precision"));
        errorTable.put(-14515, new RSQLError("eDDL_VARCHARLEN", "22000", "Must specify '(length)' with variable size columns"));
        errorTable.put(-14516, new RSQLError("eDDL_BINLEN", "22000", "Must specify '(length)' with binary columns"));
        errorTable.put(-14517, new RSQLError("eDDL_NOMAXROWS", "42000", "Must specify 'MAXROWS=value' with circular tables"));
        errorTable.put(-14518, new RSQLError("eDDL_MAXROWSVALUE", "22000", "MAXROWS value must be >0"));
        errorTable.put(-14519, new RSQLError("eDDL_CONSTRNAME", "42000", "Constraint name used more than once"));
        errorTable.put(-14520, new RSQLError("eDDL_NULLCONFLICT", "42000", "NOT NULL constraint specified for a column that has NULL values or a NULL default value"));
        errorTable.put(-14521, new RSQLError("eDDL_DROPCOLUMN", "0A000", "Cannot DROP COLUMN: column is used in constraint--drop constraint first"));
        errorTable.put(-14522, new RSQLError("eDDL_DROPNOTNULL", "0A000", "Cannot DROP NOT NULL: column is not defined as NOT NULL"));
        errorTable.put(-14523, new RSQLError("eDDL_ALTERCHECK", "0A000", "CHECK constraint not allowed in ALTER COLUMN"));
        errorTable.put(-14524, new RSQLError("eDDL_CONSTRNOTFOUND", "42000", "Constraint not found"));
        errorTable.put(-14525, new RSQLError("eDDL_NOREFDTABLE", "42S02", "Referenced table not found"));
        errorTable.put(-14526, new RSQLError("eDDL_COLDOMCONSTR", "42000", "Column constraint defined in domain"));
        errorTable.put(-14527, new RSQLError("eDDL_DROPREFDKEY", "0A000", "Cannot drop a referenced unique/primary key"));
        errorTable.put(-14528, new RSQLError("eDDL_FKCOLINFK", "0A000", "A column can only be used in one foreign key"));
        errorTable.put(-14529, new RSQLError("eDDL_ALTERTYPE", "0A000", "Cannot change column to specified data type"));
        errorTable.put(-14530, new RSQLError("eDDL_NEEDTABLE", "42000", "Table name must be specified"));
        errorTable.put(-14531, new RSQLError("eDDL_DROPTABLE", "0A000", "Cannot drop table referenced by a foreign key"));
        errorTable.put(-14532, new RSQLError("eDDL_DROPFKCOL", "0A000", "Cannot drop a foreign key on a column used in a key--drop key first"));
        errorTable.put(-14533, new RSQLError("eDDL_DROPDOMAIN", "0A000", "Cannot drop a domain that is being used by a column"));
        errorTable.put(-14534, new RSQLError("eDDL_DOMAINCHECK", "0A000", "Cannot specify a CHECK clause for a column declared as domain type"));
        errorTable.put(-14535, new RSQLError("eDDL_DBEXISTS", "3D000", "Database already exists"));
        errorTable.put(-14536, new RSQLError("eDDL_CONDEXPR", "42000", "Invalid conditional expression spec"));
        errorTable.put(-14537, new RSQLError("eDDL_DISPLAY", "42000", "Invalid DISPLAY clause spec"));
        errorTable.put(-14538, new RSQLError("eDDL_COLTYPE", "42000", "Column declarations must begin with name followed by type"));
        errorTable.put(-14539, new RSQLError("eDDL_COLDECL", "42000", "Invalid column declaration spec"));
        errorTable.put(-14540, new RSQLError("eDDL_COLCONSTRAINT", "42000", "Invalid column constraint spec"));
        errorTable.put(-14541, new RSQLError("eDDL_TABCONSTRAINT", "42000", "Invalid table constraint spec"));
        errorTable.put(-14542, new RSQLError("eDDL_INDEXMETHOD", "42000", "Invalid USING index method"));
        errorTable.put(-14543, new RSQLError("eDDL_ORDERBY", "42000", "Invalid ORDER BY spec"));
        errorTable.put(-14544, new RSQLError("eDDL_ONACTION", "42000", "Invalid ON UPDATE/DELETE action spec"));
        errorTable.put(-14545, new RSQLError("eDDL_KEYSPEC", "42000", "Invalid key spec"));
        errorTable.put(-14546, new RSQLError("eDDL_FORKEYSPEC", "42000", "Invalid foreign key/references spec"));
        errorTable.put(-14547, new RSQLError("eDDL_ERRORS", "42000", "DDL errors were found"));
        errorTable.put(-14548, new RSQLError("eDDL_ALTERCOL", "42000", "Invalid ALTER COLUMN spec"));
        errorTable.put(-14549, new RSQLError("eDDL_NOARRAYS", "0A000", "Arrays are not allowed with this data type"));
        errorTable.put(-14550, new RSQLError("eDDL_NOBLOBS", "0A000", "Blobs not allowed in virtual tables"));
        errorTable.put(-14551, new RSQLError("eDDL_ALTERACT", "42000", "Invalid ALTER action spec"));
        errorTable.put(-14552, new RSQLError("eDDL_HASPRIKEY", "42000", "Table already has a primary key defined"));
        errorTable.put(-14553, new RSQLError("eDDL_NOLOBKEYS", "0A000", "Large object columns cannot be keyed"));
        errorTable.put(-14554, new RSQLError("eDDL_NODBNAME", "42000", "Default database name not provided"));
        errorTable.put(-14555, new RSQLError("eDDL_INVDEF", "42000", "Invalid default specification for the type"));
        errorTable.put(-14556, new RSQLError("eDDL_NOHASHORDER", "0A000", "Column orders are not allowed on a hash index"));
        errorTable.put(-14557, new RSQLError("eDDL_BADRTREECOLS", "0A000", "Only one array column allowed for a R-tree index"));
        errorTable.put(-14558, new RSQLError("eDDL_BADRTREELEN", "0A000", "The array size for an R-tree index must be 2, 4, or 6"));
        errorTable.put(-14559, new RSQLError("eDDL_NONUNIQUEHASH", "42000", "Hash index must be unique"));
        errorTable.put(-14560, new RSQLError("eDDL_TABREFFEDINPL", "0A000", "Cannot drop a table referenced in a procedure or trigger on another table"));
        errorTable.put(-14561, new RSQLError("eDDL_COLWITHDEFVAL", "42000", "Cannot add a column with the default value to a table that has rows"));
        errorTable.put(-14562, new RSQLError("eDDL_INVCHGFORKEY", "42000", "Cannot change a foreign key constaint when the key columns have non-null values"));
        errorTable.put(-14563, new RSQLError("eDDL_DBNAMEINTABLE", "42000", "Database name may not be specified with a table name in DDL"));
        errorTable.put(-15000, new RSQLError("eSQL_SQLERROR", "HY000", "Internal SQL error"));
        errorTable.put(-15001, new RSQLError("eSQL_DUPCURSOR", "3C000", "Duplicate cursor name"));
        errorTable.put(-15002, new RSQLError("eSQL_GENFILE", "HY000", "Unable to open file"));
        errorTable.put(-15003, new RSQLError("eSQL_BADFORMAT", "22000", "Bad formatting specification"));
        errorTable.put(-15004, new RSQLError("eSQL_COLNUMBER", "07009", "Invalid descriptor index (column number)"));
        errorTable.put(-15005, new RSQLError("eSQL_PARNUMBER", "07009", "Invalid descriptor index (parameter number)"));
        errorTable.put(-15006, new RSQLError("eSQL_RDMERROR", "HY000", "RDM runtime error"));
        errorTable.put(-15007, new RSQLError("eSQL_SELECTCOLS", "21S02", "SELECT result columns do not match column list"));
        errorTable.put(-15008, new RSQLError("eSQL_NOCOLUMN", "42S22", "Column not found"));
        errorTable.put(-15009, new RSQLError("eSQL_NUMPAR", "21000", "Insufficient number of parameters specified"));
        errorTable.put(-15010, new RSQLError("eSQL_FETCHTYPE", "HY106", "Fetch type out of range"));
        errorTable.put(-15011, new RSQLError("eSQL_ROWVALUE", "HY107", "Row value out of range"));
        errorTable.put(-15012, new RSQLError("eSQL_CURPOS", "HY109", "Invalid cursor position"));
        errorTable.put(-15013, new RSQLError("eSQL_NOSETATTR", "HY110", "Attribute cannot be set now"));
        errorTable.put(-15014, new RSQLError("eSQL_CURSTATE", "24000", "Invalid cursor state"));
        errorTable.put(-15015, new RSQLError("eSQL_NOTSELECT", "24000", "Current/cursor's statement is not SELECT"));
        errorTable.put(-15016, new RSQLError("eSQL_ESCAPECHAR", "22019", "Invalid escape character"));
        errorTable.put(-15017, new RSQLError("eSQL_INVSTATE", "HY000", "Invalid statement state"));
        errorTable.put(-15018, new RSQLError("eSQL_WHERECALCS", "42000", "Aggregate functions not allowed in WHERE"));
        errorTable.put(-15019, new RSQLError("eSQL_INVPARAM", "42000", "Invalid use of parameter marker"));
        errorTable.put(-15020, new RSQLError("eSQL_DUPPROC", "42000", "Duplicate stored procedure name"));
        errorTable.put(-15021, new RSQLError("eSQL_NOPROC", "HY000", "Stored procedure/function not found"));
        errorTable.put(-15022, new RSQLError("eSQL_NUMARGS", "21000", "Invalid number of arguments specified"));
        errorTable.put(-15023, new RSQLError("eSQL_BADOUTERJOIN", "HY000", "No access path between outer joined tables"));
        errorTable.put(-15024, new RSQLError("eSQL_HDBCINUSE", "08002", "Connection already in use"));
        errorTable.put(-15025, new RSQLError("eSQL_UDF", "38000", "User-defined function error"));
        errorTable.put(-15026, new RSQLError("eSQL_NORETURNVAL", "2F005", "No result value returned from function"));
        errorTable.put(-15027, new RSQLError("eSQL_UDFDEFN", "HY000", "UDFLOADTABLE entry definition error"));
        errorTable.put(-15028, new RSQLError("eSQL_UDFARG", "22023", "Invalid function argument type"));
        errorTable.put(-15029, new RSQLError("eSQL_UDFNOARGS", "21000", "Incorrect number of function arguments"));
        errorTable.put(-15030, new RSQLError("eSQL_INSERTCOLREF", "42000", "Invalid column reference in INSERT expression"));
        errorTable.put(-15031, new RSQLError("eSQL_DUPJOINCOL", "42000", "Duplicate join column"));
        errorTable.put(-15032, new RSQLError("eSQL_NOJOINCOLMATCH", "42000", "No matching join columns"));
        errorTable.put(-15033, new RSQLError("eSQL_SORTCOLREF", "42000", "Invalid order/group by column reference"));
        errorTable.put(-15034, new RSQLError("eSQL_FCNARG", "21000", "Invalid function argument"));
        errorTable.put(-15035, new RSQLError("eSQL_NUMFCNARGS", "21000", "Invalid number of specified function arguments"));
        errorTable.put(-15036, new RSQLError("eSQL_INVSTMT", "HY010", "Invalid statement type"));
        errorTable.put(-15037, new RSQLError("eSQL_CANCELLED", "HY008", "Statement execution cancelled by user"));
        errorTable.put(-15038, new RSQLError("eSQL_GROUPBYAGGFN", "42000", "Aggregate functions not allowed in GROUP BY"));
        errorTable.put(-15039, new RSQLError("eSQL_TXUNKNOWN", "25S01", "Transaction state unknown"));
        errorTable.put(-15040, new RSQLError("eSQL_NOTPREPARED", "HY007", "Associated statement is not prepared"));
        errorTable.put(-15041, new RSQLError("eSQL_INVTXTYPE", "HY012", "Invalid transaction operation code"));
        errorTable.put(-15042, new RSQLError("eSQL_PARMTYPE", "HY105", "Invalid parameter type"));
        errorTable.put(-15043, new RSQLError("eSQL_TIMEOUT", "HYT00", "Timeout expired"));
        errorTable.put(-15044, new RSQLError("eSQL_IEF", "HY000", "Import/export error"));
        errorTable.put(-15045, new RSQLError("eSQL_REMOTEERROR", "08S01", "JNI/ADO.Net system error"));
        errorTable.put(-15046, new RSQLError("eSQL_COMERROR", "08S01", "RPC communication error"));
        errorTable.put(-15047, new RSQLError("eSQL_LOCKSACTIVE", "HY000", "Operation not allowed due to active read locks"));
        errorTable.put(-15048, new RSQLError("eSQL_MULTIDBTRANS", "HY000", "Multiple database transactions are not allowed"));
        errorTable.put(-15049, new RSQLError("eSQL_NOTUPDATEABLE", "0U000", "SELECT or column is not updateable"));
        errorTable.put(-15050, new RSQLError("eSQL_BLOBEXPR", "HY000", "Blobs cannot be referenced in expressions"));
        errorTable.put(-15051, new RSQLError("eSQL_DATAATEXEC", "HY000", "Data-at-exec parameters only allowed with INSERT VALUES/UPDATE"));
        errorTable.put(-15052, new RSQLError("eSQL_BLOBPARSONLY", "HY000", "Data-at-exec parameters only allowed for blob (long var...) columns"));
        errorTable.put(-15053, new RSQLError("eSQL_BADBLOBPAR", "HY000", "Data-at-exec paramater type not compatible with blob (long var...) column"));
        errorTable.put(-15054, new RSQLError("eSQL_LOCKMODE", "HY000", "Illegal locking mode"));
        errorTable.put(-15055, new RSQLError("eSQL_NOUPDCOLS", "42000", "No columns have been updated"));
        errorTable.put(-15056, new RSQLError("eSQL_AUTOCOMMIT", "HY000", "Operation not allowed when autocommit is enabled"));
        errorTable.put(-15057, new RSQLError("eSQL_CURSORTABLE", "0T000", "Positioned UPDATE/DELETE table does not match cursor's"));
        errorTable.put(-15058, new RSQLError("eSQL_RDONLYFLAG", "25000", "Inconsistent read-only transaction commit/rollback/end call"));
        errorTable.put(-15059, new RSQLError("eSQL_TABLEREF", "42000", "Duplicate table reference in FROM clause"));
        errorTable.put(-15060, new RSQLError("eSQL_NESTEDAGGS", "42000", "Cannot call an aggregate function within an aggregate function"));
        errorTable.put(-15061, new RSQLError("eSQL_CHARREQD", "2200G", "CHAR type is required"));
        errorTable.put(-15062, new RSQLError("eSQL_CONNECT", "08001", "Unable to connect"));
        errorTable.put(-15063, new RSQLError("eSQL_UNIONOPEN", "HY000", "Database union open invalid when other database is open"));
        errorTable.put(-15064, new RSQLError("eSQL_NOBLOBSORT", "42000", "Sorting on a blob column is not allowed"));
        errorTable.put(-15065, new RSQLError("eSQL_NOBLOBGROUP", "42000", "Blob columns cannot be referenced in a SELECT with GROUP BY"));
        errorTable.put(-15066, new RSQLError("eSQL_DIFFCONNS", "HY000", "Statements from different connections"));
        errorTable.put(-15067, new RSQLError("eSQL_OUTERJOIN", "HY000", "Unable to process outer join specification"));
        errorTable.put(-15068, new RSQLError("eSQL_NOWHEREBLOB", "42000", "Blob columns cannot be used in WHERE clause of a SELECT with ORDER BY"));
        errorTable.put(-15069, new RSQLError("eSQL_NAMEDPARAM", "HY000", "Named parameter not found"));
        errorTable.put(-15070, new RSQLError("eSQL_NOTINUDF", "HY000", "Function cannot be called from a UDF"));
        errorTable.put(-15071, new RSQLError("eSQL_GROUPRESULT", "42000", "Result column must have aggregate function call"));
        errorTable.put(-15072, new RSQLError("eSQL_INVCURSOR", "34000", "Invalid cursor name"));
        errorTable.put(-15073, new RSQLError("eSQL_CURSORTAB", "0T000", "Target table does not match cursor specification"));
        errorTable.put(-15074, new RSQLError("eSQL_FORUPDCOL", "42000", "FOR UPDATE column not in SELECT list"));
        errorTable.put(-15075, new RSQLError("eSQL_INVPROC", "HY000", "Stored procedure has an invalid version"));
        errorTable.put(-15076, new RSQLError("eSQL_NOTUDFAGG", "42000", "DISTINCT can only be specified with aggregate UDF"));
        errorTable.put(-15078, new RSQLError("eSQL_INVROWIDVAL", "22000", "Invalid rowid value"));
        errorTable.put(-15079, new RSQLError("eSQL_NOINSERTID", "HY000", "No last_insert_id is available"));
        errorTable.put(-15080, new RSQLError("eSQL_INVSELECT", "42000", "SELECT cannot have ORDER/GROUP BY clause"));
        errorTable.put(-15082, new RSQLError("eSQL_GROUPBYPARMS", "42000", "GROUP BY column expressions cannot have parameter markers"));
        errorTable.put(-15083, new RSQLError("eSQL_INVARMISMATCH", "42000", "Variant argument value in INVAR aggregate function"));
        errorTable.put(-15084, new RSQLError("eSQL_SORTCOST", "22003", "Sort cost factor must be > 0.0 and < 1.0"));
        errorTable.put(-15086, new RSQLError("eSQL_DEBUGMODE", "22003", "Valid debug mode values are 0,1,2,3"));
        errorTable.put(-15087, new RSQLError("eSQL_BADSCALE", "HY104", "Invalid DECIMAL scale. Must be >= 0 and <= prec"));
        errorTable.put(-15088, new RSQLError("eSQL_TOOMANYROWS", "21000", "Subquery returns more than 1 row"));
        errorTable.put(-15089, new RSQLError("eSQL_AMBIGUOUSCOLREF", "42000", "Column with this name declared in more than one of the referenced tables"));
        errorTable.put(-15090, new RSQLError("eSQL_NOHIDDENCOLS", "42000", "Hidden columns not allowed in this context"));
        errorTable.put(-15091, new RSQLError("eSQL_ROWNUMBER", "42000", "ROWNUMBER() can only be used with a SELECT statement"));
        errorTable.put(-15092, new RSQLError("eSQL_LABELMISMATCH", "42000", "END label missing or doesn't match block label"));
        errorTable.put(-15093, new RSQLError("eSQL_UNDECLAREDVARREF", "42000", "Reference to undeclared variable"));
        errorTable.put(-15094, new RSQLError("eSQL_NOAGGINASGT", "42000", "Aggregate functions not allowed in assignment statement"));
        errorTable.put(-15095, new RSQLError("eSQL_PROCGLOBALREF", "42000", "Stored procedure references an undeclared global variable"));
        errorTable.put(-15096, new RSQLError("eSQL_NOVALGLOBAL", "42000", "No value assigned to the global variable"));
        errorTable.put(-15097, new RSQLError("eSQL_INARGASGT", "42000", "Assignment to input only argument or condition"));
        errorTable.put(-15098, new RSQLError("eSQL_OUTARGCALL", "42000", "Output argument must map to a variable"));
        errorTable.put(-15099, new RSQLError("eSQL_NOOERRCODE", "42000", "Sqlstate/error/condition code not defined"));
        errorTable.put(-15100, new RSQLError("eSQL_CASENOTFOUND", "20000", "Case not found for CASE statement"));
        errorTable.put(-15101, new RSQLError("eSQL_OUTARGS", "42000", "INOUT/OUT arguments are not allowed in functions"));
        errorTable.put(-15102, new RSQLError("eSQL_INVRETURN", "42000", "RETURN statements are not allowed in procedures"));
        errorTable.put(-15103, new RSQLError("eSQL_RESULTSET", "42000", "Cursors/SELECTs that return result sets are not allowed in handlers, functions or triggers"));
        errorTable.put(-15104, new RSQLError("eSQL_RETURNTYPE", "2200G", "Data type of RETURN expression is not compatible with function"));
        errorTable.put(-15105, new RSQLError("eSQL_ALIASEDCOLSREQD", "42000", "All result column expressions must be aliased in DECLARE CURSOR's SELECT"));
        errorTable.put(-15106, new RSQLError("eSQL_CURNOTDECLARED", "42000", "Cursor not declared"));
        errorTable.put(-15107, new RSQLError("eSQL_USEINPROCONLY", "42000", "FOUND test can only be used in stored procedure/function"));
        errorTable.put(-15108, new RSQLError("eSQL_FETCHVARS", "OT000", "FETCH INTO variable list cursor column count mismatch"));
        errorTable.put(-15109, new RSQLError("eSQL_FETCHVARDATATYPE", "2200G", "FETCH INTO variable data type incompatible with corresponding result column type"));
        errorTable.put(-15110, new RSQLError("eSQL_NORESULTSETS", "42000", "WITH RETURN cursor not allowed with this procedure (DYNAMIC RESULT SETS = 0)"));
        errorTable.put(-15111, new RSQLError("eSQL_DUPVARREF", "42000", "Variable is already declared"));
        errorTable.put(-15112, new RSQLError("eSQL_NOTROWVAR", "42000", "Identifier is not a declared row variable or BEGIN label"));
        errorTable.put(-15113, new RSQLError("eSQL_ROWVARREF", "42000", "Illegal row variable reference"));
        errorTable.put(-15114, new RSQLError("eSQL_GLOBALVARREF", "42000", "Illegal global variable reference"));
        errorTable.put(-15115, new RSQLError("eSQL_NOTROWVARCOL", "42000", "Identifier is not a column of the specified row variable"));
        errorTable.put(-15116, new RSQLError("eSQL_NOTBLOCKVAR", "42000", "Identifier is not declared in specified block"));
        errorTable.put(-15117, new RSQLError("eSQL_TOOMANYROWVARS", "42000", "Only one row variable can be declared for a cursor"));
        errorTable.put(-15118, new RSQLError("eSQL_WRONGROWVAR", "42000", "Row variable is not declared for this cursor"));
        errorTable.put(-15119, new RSQLError("eSQL_LABELNOTFOUND", "42000", "Statement with specified label not found"));
        errorTable.put(-15120, new RSQLError("eSQL_FORCURSOR", "42000", "Statement not allowed on FOR cursor name"));
        errorTable.put(-15121, new RSQLError("eSQL_ARGREF", "42000", "Procedure/function argument not found"));
        errorTable.put(-15122, new RSQLError("eSQL_BADARGFORM", "42000", "Invalid procedure/function argument specification"));
        errorTable.put(-15123, new RSQLError("eSQL_PREPVAROUT", "42000", "PREPARE statement variable cannot be an OUT variable"));
        errorTable.put(-15124, new RSQLError("eSQL_PREPVARROW", "42000", "PREPARE statement variable cannot be a ROW variable"));
        errorTable.put(-15125, new RSQLError("eSQL_PREPVARTYPE", "42000", "PREPARE statement variable must be a CHAR type"));
        errorTable.put(-15126, new RSQLError("eSQL_BADINTOVARTYPE", "42000", "EXECUTE INTO variable type is not assignable"));
        errorTable.put(-15127, new RSQLError("eSQL_DUPPREPNAME", "42000", "Duplicate PREPARE statement name"));
        errorTable.put(-15128, new RSQLError("eSQL_PREPNOTFOUND", "42000", "PREPARE statement not found"));
        errorTable.put(-15129, new RSQLError("eSQL_PREPNOPARAMS", "42000", "Parameter markers are not allowed in PREPARE statement"));
        errorTable.put(-15130, new RSQLError("eSQL_PREPNOTSELECT", "42000", "PREPARE statement must be a SELECT for EXECUTE INTO"));
        errorTable.put(-15131, new RSQLError("eSQL_EXECNEEDSINTO", "42000", "EXECUTE must have INTO clause for a PREPARE of SELECT statement"));
        errorTable.put(-15132, new RSQLError("eSQL_PREPUNALLOWABLE", "42000", "Statement type not allowed in PREPARE"));
        errorTable.put(-15133, new RSQLError("eSQL_PREPNOCOLS", "0T000", "PREPARE SELECT number of result columns does not match EXECUTE INTO"));
        errorTable.put(-15134, new RSQLError("eSQL_NOTCONDITION", "42000", "Referenced variable is not a named condition"));
        errorTable.put(-15135, new RSQLError("eSQL_GENEXCEPTION", "42000", "Cannot mix general and specific conditions in one handler"));
        errorTable.put(-15136, new RSQLError("eSQL_DUPCONDITION", "42000", "Duplicate condition spec'd in same handler or other handler in same scope"));
        errorTable.put(-15137, new RSQLError("eSQL_UNDONOTATOMIC", "42000", "BEGIN must specify ATOMIC within an UNDO handler"));
        errorTable.put(-15138, new RSQLError("eSQL_HANDLERNOTFOUND", "45000", "Handler not found for condition"));
        errorTable.put(-15139, new RSQLError("eSQL_RESIGNAL", "0K000", "Resignal when handler not active"));
        errorTable.put(-15140, new RSQLError("eSQL_INVDIAGITEM", "42000", "Invalid diagnostics item info name"));
        errorTable.put(-15141, new RSQLError("eSQL_MSGTEXT", "42000", "MESSAGE_TEXT expected"));
        errorTable.put(-15142, new RSQLError("eSQL_NODIAGSINFO", "0Z000", "No diagnostics info is available"));
        errorTable.put(-15143, new RSQLError("eSQL_INVCONDNUM", "35000", "Invalid condition number"));
        errorTable.put(-15144, new RSQLError("eSQL_MAXDIAGSAREA", "0Z001", "Maximum number of stacked diagnostics areas exceeded"));
        errorTable.put(-15145, new RSQLError("eSQL_DIAGNOTSTACKED", "0Z002", "Stacked diagnostics accessed without active handler"));
        errorTable.put(-15146, new RSQLError("eSQL_PROCEXISTS", "HY000", "Another stored procedure/function with same name has been created"));
        errorTable.put(-15147, new RSQLError("eSQL_TRMODE", "42000", "Transaction mode can be specified only once"));
        errorTable.put(-15148, new RSQLError("eSQL_BEGINTRANS", "42000", "BEGIN TRANSACTION can only be specified with first BEGIN"));
        errorTable.put(-15149, new RSQLError("eSQL_ATOMIC", "42000", "Statement cannot be used in a BEGIN ATOMIC/TRANSACTION block"));
        errorTable.put(-15150, new RSQLError("eSQL_MODIFIES", "2F002", "Read only stored proc/func contains modification statements"));
        errorTable.put(-15151, new RSQLError("eSQL_SYSCAT", "42000", "Invalid operation on SYSTEM CATALOG"));
        errorTable.put(-15152, new RSQLError("eSQL_SQLSTATESIGNAL", "HY000", "Unhandled signaled SQLSTATE condition"));
        errorTable.put(-15153, new RSQLError("eSQL_NOTDETERMINISTIC", "42000", "Simple CASE expression cannot call a non-deterministic function"));
        errorTable.put(-15154, new RSQLError("eSQL_LEAVEHANDLER", "42000", "LEAVE to a block outside of a condition handler is not allowed"));
        errorTable.put(-15155, new RSQLError("eSQL_ASGTEXPRCOUNT", "42000", "Number of variables in multiple SET assignment does not match number of expressions"));
        errorTable.put(-15156, new RSQLError("eSQL_NOTINFORLOOP", "42000", "COMMIT/ROLLBACK not allowed in FOR loop"));
        errorTable.put(-15157, new RSQLError("eSQL_DUPLICATELABEL", "42000", "Duplicate block or loop label"));
        errorTable.put(-15158, new RSQLError("eSQL_CALLFUNCTION", "42000", "Functions cannot be called using the CALL statement"));
        errorTable.put(-15159, new RSQLError("eSQL_TRIGDBMISMATCH", "42000", "Table's database name does not match trigger's"));
        errorTable.put(-15160, new RSQLError("eSQL_TRIGCOLLIST", "42000", "Column list can only be used with UPDATE triggers"));
        errorTable.put(-15161, new RSQLError("eSQL_BEGINATOMIC", "42000", "A compound trigger action must be BEGIN ATOMIC"));
        errorTable.put(-15162, new RSQLError("eSQL_TRIGEXISTS", "HY000", "Another trigger with same name has been created"));
        errorTable.put(-15163, new RSQLError("eSQL_WHENFCN", "42000", "Functions ref'd in WHEN clause cannot be MODIFIES SQL"));
        errorTable.put(-15164, new RSQLError("eSQL_NOTINTRIGGER", "42000", "Transactions cannot be used in a trigger"));
        errorTable.put(-15165, new RSQLError("eSQL_NOTRIG", "42000", "Trigger not found"));
        errorTable.put(-15167, new RSQLError("eSQL_NOINSERTVALS", "42000", "Syntax error where no columns are present after the keyword 'VALUES'"));
        errorTable.put(-15168, new RSQLError("eSQL_DEFINSERTVALS", "42000", "Syntax error where columns are present after 'DEFAULT VALUES'"));
        errorTable.put(-15169, new RSQLError("eSQL_INVARRAYTYPE", "22000", "Invalid array element value"));
        errorTable.put(-15170, new RSQLError("eSQL_NOTARRAY", "42000", "Not an array value/column/variable"));
        errorTable.put(-15171, new RSQLError("eSQL_BADSUBSCRIPT", "42000", "Subscript value is out of range"));
        errorTable.put(-15172, new RSQLError("eSQL_INVARRAYOP", "42000", "Invalid array operation"));
        errorTable.put(-15173, new RSQLError("eSQL_RECURSIVEPROC", "HY000", "Recursive stored procedures and triggers are not allowed"));
        errorTable.put(-15174, new RSQLError("eSQL_TBD", "0A000", "Yet to be implemented feature"));
        errorTable.put(-15175, new RSQLError("eSQL_SYSTEM", "HY000", "System error"));
        errorTable.put(-15176, new RSQLError("eSQL_NOTFSSQL", "08001", "Server doesn't have the SQL capability"));
        errorTable.put(-15177, new RSQLError("eSQL_NODBOPEN", "3D000", "No databases are open"));
        errorTable.put(-16000, new RSQLError("eMIR_SYNC_GENERROR", null, "Generic synchronous mirroring error"));
        errorTable.put(-16001, new RSQLError("eMIR_SYNC_TIMEOUT", null, "Synchronous mirroring timeout"));
        errorTable.put(-16002, new RSQLError("eMIR_INVLOGFILE", null, "Invalid log file format"));
        errorTable.put(-17000, new RSQLError("eRDBC_BADCTYPE", "HY004", "Invalid C data type"));
        errorTable.put(-17001, new RSQLError("eRDBC_BADSTYPE", "HY004", "Invalid SQL data type"));
        errorTable.put(-17002, new RSQLError("eRDBC_NOMEMORY", "HY013", "Driver out of memory"));
        errorTable.put(-17003, new RSQLError("eRDBC_TYPEATTR", "HY024", "Data type attribute violation"));
        errorTable.put(-17004, new RSQLError("eRDBC_NOTCAPABLE", "IM001", "Driver not capable"));
        errorTable.put(-17005, new RSQLError("eRDBC_DESCRANGE", "HY091", "Invalid descriptor field identifier"));
        errorTable.put(-17006, new RSQLError("eRDBC_INVDESCIDX", "07009", "Invalid descriptor index"));
        errorTable.put(-17007, new RSQLError("eRDBC_NOTCURSOR", "07005", "Prepared statement is not a valid cursor"));
        errorTable.put(-17008, new RSQLError("eRDBC_INVIRDMOD", "HY016", "Cannot modify an implementation row descriptor"));
        errorTable.put(-17009, new RSQLError("eRDBC_INVOPENMODE", "01S00", "Invalid database open mode"));
        errorTable.put(-17011, new RSQLError("eRDBC_NOINDVAR", "22002", "Indicator variable required but not supplied"));
        errorTable.put(-17012, new RSQLError("eRDBC_CLOSEHDBC", "01002", "Connection not closed"));
        errorTable.put(-17013, new RSQLError("eRDBC_OPENHDBCS", "01002", "Must free all connection handles first"));
        errorTable.put(-17014, new RSQLError("eRDBC_AUTODESCR", "HY017", "Invalid use of implicit descriptor handle"));
        errorTable.put(-17015, new RSQLError("eRDBC_ATTRVALUE", "HY024", "Invalid attribute value"));
        errorTable.put(-17016, new RSQLError("eRDBC_FCNRANGE", "HY095", "Function type out of range"));
        errorTable.put(-17017, new RSQLError("eRDBC_INVOPNOW", "HY010", "Invalid operation at this time"));
        errorTable.put(-17018, new RSQLError("eRDBC_BADDESCINFO", "HY021", "Inconsistent descriptor information"));
        errorTable.put(-17019, new RSQLError("eRDBC_CONCATNULL", "HY020", "Attempt to concatenate a null value"));
        errorTable.put(-17020, new RSQLError("eRDBC_COLRANGE", "HY097", "Column type out of range"));
        errorTable.put(-17021, new RSQLError("eRDBC_SCOPERANGE", "HY098", "Scope out of range"));
        errorTable.put(-17022, new RSQLError("eRDBC_NULLRANGE", "HY099", "Nullable type out of range"));
        errorTable.put(-17023, new RSQLError("eRDBC_UNIQUERANGE", "HY100", "Uniqueness option type out of range"));
        errorTable.put(-17024, new RSQLError("eRDBC_ACCURANGE", "HY101", "Accuracy option type out of range"));
        errorTable.put(-18000, new RSQLError("eTX_DISABLED", null, "HTTP listener is disabled"));
        errorTable.put(-18001, new RSQLError("eTX_TRUNCATED", null, "Data retrieved had to be truncated"));
        errorTable.put(-18002, new RSQLError("eTX_NETREAD", null, "Failure to read data from network"));
        errorTable.put(-18003, new RSQLError("eTX_NETWRITE", null, "Failure to write data to network"));
        errorTable.put(-18004, new RSQLError("eTX_CONNECT", "08S01", "Failed to connect to server"));
        errorTable.put(-18005, new RSQLError("eTX_HOSTNAME", "08S01", "Host name not found"));
        errorTable.put(-18006, new RSQLError("eTX_ACCEPT", null, "TCP/IP accept failure"));
        errorTable.put(-18007, new RSQLError("eTX_LISTEN", null, "TCP/IP listen failure"));
        errorTable.put(-18008, new RSQLError("eTX_NO_REMOTE", null, "Remote connections not allowed"));
        errorTable.put(-18009, new RSQLError("eTX_GENERROR", null, "Generic TX error"));
        errorTable.put(-20000, new RSQLError("eSYS_BADERRCODE", "HY000", "Invalid RDM_ RETCODE value"));
        errorTable.put(-20001, new RSQLError("eSYS_ERRACTIVE", null, "Error function call not allowed when another error is active"));
        errorTable.put(-20003, new RSQLError("eSYS_DCHAIN", null, "Bad dchain"));
        errorTable.put(-20004, new RSQLError("eSYS_BADTREE", null, "B-tree malformed"));
        errorTable.put(-20005, new RSQLError("eSYS_BADHASH", null, "Hash malformed"));
        errorTable.put(-20006, new RSQLError("eSYS_KEYEXIST", null, "Key value already exists"));
        errorTable.put(-20007, new RSQLError("eSYS_BADOPTKEY", null, "Calculating optkey index"));
        errorTable.put(-20008, new RSQLError("eSYS_BADFREE", null, "Attempt to free empty table"));
        errorTable.put(-20009, new RSQLError("eSYS_ERROR", null, "Unexpected system error"));
        errorTable.put(-20010, new RSQLError("eSYS_NOSQLSTATE", "HY000", "Unexpected empty SQL state"));
        errorTable.put(-21000, new RSQLError("eHTTP_BADREQUEST", null, "Bad HTTP request"));
        errorTable.put(-21001, new RSQLError("eHTTP_URITOOLONG", null, "URI too long"));
        errorTable.put(-21002, new RSQLError("eHTTP_ENTTOOLARGE", null, "Entity too large"));
        errorTable.put(-21003, new RSQLError("eHTTP_NOLENGTH", null, "No length was specified"));
        errorTable.put(-21004, new RSQLError("eHTTP_INVHANDLE", null, "Invalid HTTP handle"));
        errorTable.put(-21006, new RSQLError("eHTTP_BADUSERID", null, "Invalid user id - not alphanumeric"));
        errorTable.put(-21007, new RSQLError("eHTTP_UNSUPPORTEDTYPE", null, "Unsupported content type"));
        errorTable.put(-29000, new RSQLError("eQA_ILLEGAL_TFS_COMBINATION", null, "Illegal combination of options for different tfs types"));
        errorTable.put(-29001, new RSQLError("eQA_TEST_TIMEOUT", null, "Test timed out"));
        errorTable.put(-29002, new RSQLError("eQA_ILLEGAL_FILENAME", null, "Illegal filename"));
        errorTable.put(-29003, new RSQLError("eQA_ILLEGAL_NAMESPACE", null, "Illegal namespace"));
        errorTable.put(-29004, new RSQLError("eQA_FEATURE_NOTIMPLEMENTED", null, "Feature have not been implemented"));
        errorTable.put(-29005, new RSQLError("eQA_ILLEGAL_USE_OF_STOP_WATCH", null, "Illegal use of stop watch"));
        errorTable.put(-29006, new RSQLError("eQA_HAS_FLOAT_REQUIRED", null, "Illegal use of floating point"));
        errorTable.put(-29007, new RSQLError("eQA_CASE_FAILED", null, "A test case failed"));
        errorTable.put(-29008, new RSQLError("eQA_NEED_DESCRIPTION", null, "A description is missing for a case"));
        errorTable.put(-29009, new RSQLError("eQA_HELP", null, "Help text returned"));
        errorTable.put(-29011, new RSQLError("eQA_NO_TESTS_SELECTED", null, "No tests was selected by the command line options given"));
        errorTable.put(-29012, new RSQLError("eQA_CASE_DESCRIBED", null, "T test case have been described"));
        errorTable.put(-29013, new RSQLError("eQA_LOG_BAD_READ", null, "Reading from test log failed"));
        errorTable.put(-29014, new RSQLError("eQA_LOG_BAD_WRITE", null, "Writing to test log failed"));
        errorTable.put(-29015, new RSQLError("eQA_LOG_OPEN", null, "Opening test log failed"));
        errorTable.put(-29016, new RSQLError("eQA_TFS_PROPERTY_CONFLICT", null, "TFS property have not been set"));
        errorTable.put(-29017, new RSQLError("eQA_TFS_PROPERTY_UNSET", null, "TFS property set inconsistently"));
        errorTable.put(-29018, new RSQLError("eQA_NO_GLOBAL_ENC", null, "There is no global encryption support for legacy"));
        errorTable.put(-29019, new RSQLError("eQA_FORK", null, "Failed to fork child process"));
        errorTable.put(-29020, new RSQLError("eQA_MMAP", null, "Failed to create shared memory"));
        errorTable.put(-29021, new RSQLError("eQA_KILL", null, "The QA Framework detected termination upon a signal while running a test in a child process"));
        errorTable.put(-29022, new RSQLError("eQA_CHILD_EXIT", null, "A forked child is done, now we need to cleanup and exit.  No summary output."));
        errorTable.put(-29023, new RSQLError("eQA_END_OF_LIST", null, "Used internally to end a list of error or status codes to the QA_S macro"));
        errorTable.put(-29024, new RSQLError("eQA_RDBC_INVHANDLE", null, "A placeholder for 'SQL_INVALID_HANDLE'"));
        errorTable.put(-29025, new RSQLError("eQA_RDBC_ERROR", null, "A placeholder for 'SQL_ERROR'"));
        errorTable.put(-29026, new RSQLError("eQA_INVALID_ARGUMENT", null, "Invalid command line argument"));
        errorTable.put(-29027, new RSQLError("eQA_LONG_ARGUMENT", null, "Command line argument is too long"));
        errorTable.put(-29028, new RSQLError("eQA_TEST_FAILED", null, "Some tests failed"));
        errorTable.put(-29029, new RSQLError("eQA_MEM", null, "Simulating memory failure had errors"));
        errorTable.put(-29030, new RSQLError("eQA_FAIL_NOTIMPLEMENTED", null, "Failure simulation not implemeded (compile with -DRDM_TAG_FAIL)"));
        errorTable.put(-30000, new RSQLError("eEMBED_FILE_NOT_FOUND", null, "File not found by the embedder"));
        errorTable.put(-30001, new RSQLError("eEMBED_UNKNOWN_COMMAND", null, "Command not supported by the embedder"));
        errorTable.put(-30002, new RSQLError("eEMBED_ILLEGAL_NAMESPACE", null, "Illegal namespace provided to the embedder"));
        errorTable.put(-30003, new RSQLError("eEMBED_CONTENT_MISMATCH", null, "Content doesn't match the embedded hash for the file"));
    }
}

