/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.RPC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.UUID;

public class RSQLBlobParam
extends RSQLParam {
    InputStream is;
    long maxlen;

    public RSQLBlobParam() {
        super(4102, (short)2);
    }

    public RSQLBlobParam(InputStream is) {
        super(4102);
        this.is = is;
        this.maxlen = -1L;
    }

    public RSQLBlobParam(short t, InputStream is) {
        super(4102, t);
        this.is = is;
        this.maxlen = -1L;
    }

    public RSQLBlobParam(InputStream is, long maxlen) throws SQLException {
        super(4102);
        if (maxlen < 0L) {
            throw new RDMUnexpectedException("Invalid maximum length specified").createSQLException();
        }
        this.is = is;
        this.maxlen = maxlen;
    }

    public RSQLBlobParam(short t, InputStream is, long maxlen) throws SQLException {
        super(4102, t);
        if (maxlen < 0L) {
            throw new RDMUnexpectedException("Invalid maximum length specified").createSQLException();
        }
        this.is = is;
        this.maxlen = maxlen;
    }

    public RSQLBlobParam(Blob blob) throws SQLException {
        super(4102);
        this.is = blob.getBinaryStream();
        this.maxlen = -1L;
    }

    public RSQLBlobParam(short t, Blob blob) throws SQLException {
        super(4102, t);
        this.is = blob.getBinaryStream();
        this.maxlen = -1L;
    }

    @Override
    public String getString() throws RDMException {
        return BinaryConverter.convertToString(this.getBytes());
    }

    @Override
    public byte[] getBytes() throws RDMException {
        try {
            int b;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int ii = 0;
            while ((long)ii != this.maxlen && (b = this.is.read()) != -1) {
                os.write(b);
                ++ii;
            }
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMUnexpectedException(e.getMessage());
        }
    }

    @Override
    public boolean getBoolean() throws RDMException {
        return BinaryConverter.convertToBoolean(this.getBytes());
    }

    @Override
    public byte getByte() throws RDMException {
        return BinaryConverter.convertToByte(this.getBytes());
    }

    @Override
    public short getShort() throws RDMException {
        return BinaryConverter.convertToShort(this.getBytes());
    }

    @Override
    public int getInt() throws RDMException {
        return BinaryConverter.convertToInt(this.getBytes());
    }

    @Override
    public long getLong() throws RDMException {
        return BinaryConverter.convertToLong(this.getBytes());
    }

    @Override
    public float getFloat() throws RDMException {
        return BinaryConverter.convertToFloat(this.getBytes());
    }

    @Override
    public double getDouble() throws RDMException {
        return BinaryConverter.convertToDouble(this.getBytes());
    }

    @Override
    public int getDate() throws RDMException {
        return BinaryConverter.convertToDate(this.getBytes());
    }

    @Override
    public int getTime() throws RDMException {
        return BinaryConverter.convertToTime(this.getBytes());
    }

    @Override
    public int[] getTimestamp() throws RDMException {
        return BinaryConverter.convertToTimestamp(this.getBytes());
    }

    @Override
    public UUID getGuid() throws RDMException {
        return BinaryConverter.convertToGuid(this.getBytes());
    }

    @Override
    public void send(RPC rpc) throws IOException {
        try {
            rpc.sendInt32(6);
            rpc.sendBytes(this.getBytes());
        }
        catch (RDMException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.is = new ByteArrayInputStream(rpc.getBytes());
    }

    private byte[] getNextChunk(int max) throws IOException {
        int data;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int ii = 0; ii < max && (data = this.is.read()) != -1; ++ii) {
            baos.write(data);
        }
        return baos.toByteArray();
    }

    @Override
    public void sendDataAtExec(RSQLStatement stmt) throws RDMException {
        try {
            byte[] barr;
            while ((barr = this.getNextChunk(1024)).length != 0) {
                stmt.putData(4102, barr);
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException(e.getMessage());
        }
    }
}

