/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMPooledConnection;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public class RDMLogicalConnection
implements Connection {
    private Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    Connection con;
    RDMPooledConnection pool;
    private static final String className = "RDMLogicalConnection";

    public RDMLogicalConnection(RDMPooledConnection logicalConnection, Connection physicalConnection) throws SQLException {
        this.pool = logicalConnection;
        this.con = physicalConnection;
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodName = "clearWarnings";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            this.con.clearWarnings();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void close() throws SQLException {
        String methodName = "close";
        this.logger.entering(className, methodName);
        if (this.con != null) {
            this.pool.connNotify(0, null);
            this.con = null;
            this.pool = null;
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void commit() throws SQLException {
        String methodName = "commit";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void abort(Executor exec) throws SQLException {
        String methodName = "clearWarnings";
        this.logger.entering(className, "clearWarnings");
        throw this.createSQLFeatureNotSupportedException("clearWarnings", "not supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Array x;
        String methodName = "createArrayOf";
        this.logger.entering(className, methodName, new Object[]{typeName, elements});
        this._validate(methodName);
        try {
            x = this.con.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, x);
        return x;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Blob x;
        String methodName = "createBlob";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            x = this.con.createBlob();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, x);
        return x;
    }

    @Override
    public Clob createClob() throws SQLException {
        Clob x;
        String methodName = "createClob";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            x = this.con.createClob();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, x);
        return x;
    }

    @Override
    public NClob createNClob() throws SQLException {
        NClob x;
        String methodName = "createNClob";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            x = this.con.createNClob();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, x);
        return x;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        SQLXML x;
        String methodName = "createSQLXML";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            x = this.con.createSQLXML();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, x);
        return x;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt;
        String methodName = "createStatement";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            stmt = this.con.createStatement();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt;
        String methodName = "createStatement";
        this.logger.entering(className, methodName, new Object[]{resultSetType, resultSetConcurrency});
        this._validate(methodName);
        try {
            stmt = this.con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt;
        String methodName = "createStatement";
        this.logger.entering(className, methodName, new Object[]{resultSetType, resultSetConcurrency, resultSetHoldability});
        this._validate(methodName);
        try {
            stmt = this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Struct x;
        String methodName = "createStruct";
        this.logger.entering(className, methodName, new Object[]{typeName, attributes});
        this._validate(methodName);
        try {
            x = this.con.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, x);
        return x;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean flag;
        String methodName = "getAutoCommit";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            flag = this.con.getAutoCommit();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public String getCatalog() throws SQLException {
        String catalog;
        String methodName = "getCatalog";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            catalog = this.con.getCatalog();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, catalog);
        return catalog;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String str;
        String methodName = "getClientInfo";
        this.logger.entering(className, methodName, name);
        this._validate(methodName);
        try {
            str = this.con.getClientInfo(name);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, str);
        return str;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties;
        String methodName = "getClientInfo";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            properties = this.con.getClientInfo();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, properties);
        return properties;
    }

    @Override
    public int getHoldability() throws SQLException {
        int ret;
        String methodName = "getHoldability";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            ret = this.con.getHoldability();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData meta;
        String methodName = "getMetaData";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            meta = this.con.getMetaData();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, meta);
        return meta;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        String methodName = "getNetworkTimeout";
        this.logger.entering(className, "getNetworkTimeout");
        throw this.createSQLFeatureNotSupportedException("getNetworkTimeout", "not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        String methodName = "getSchema";
        this.logger.entering(className, "getSchema");
        throw this.createSQLFeatureNotSupportedException("getSchema", "not supported");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        int ret;
        String methodName = "getTransactionIsolation";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            ret = this.con.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Map<String, Class<?>> map;
        String methodName = "getMapType";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            map = this.con.getTypeMap();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, map);
        return map;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning warning;
        String methodName = "getWarnings";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            warning = this.con.getWarnings();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, warning);
        return warning;
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodName = "getWarnings";
        this.logger.entering(className, methodName);
        boolean flag = this.con == null || this.con.isClosed();
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean flag;
        String methodName = "isReadOnly";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            flag = this.con.isReadOnly();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        String methodName = "isValid";
        this.logger.entering(className, methodName);
        boolean flag = this.con != null && !this.con.isClosed();
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, methodName, iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String str;
        String methodName = "nativeSQL";
        this.logger.entering(className, methodName, sql);
        this._validate(methodName);
        try {
            str = this.con.nativeSQL(sql);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, str);
        return str;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt;
        String methodName = "prepareCall";
        this.logger.entering(className, methodName, sql);
        this._validate(methodName);
        try {
            stmt = this.con.prepareCall(sql);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt;
        String methodName = "prepareCall";
        this.logger.entering(className, methodName, new Object[]{sql, resultSetType, resultSetConcurrency});
        this._validate(methodName);
        try {
            stmt = this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt;
        String methodName = "prepareCall";
        this.logger.entering(className, methodName, new Object[]{sql, resultSetType, resultSetConcurrency, resultSetHoldability});
        this._validate(methodName);
        try {
            stmt = this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt;
        String methodName = "prepareStatement";
        this.logger.entering(className, methodName, sql);
        this._validate(methodName);
        try {
            stmt = this.con.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String methodName = "prepareStatement";
        this.logger.entering(className, methodName, new Object[]{sql, autoGeneratedKeys});
        this._validate(methodName);
        throw this.createSQLFeatureNotSupportedException(methodName, "returning generated keys not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt;
        String methodName = "prepareStatement";
        this.logger.entering(className, methodName, new Object[]{sql, columnIndexes});
        this._validate(methodName);
        try {
            stmt = this.con.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        String methodName = "prepareStatement";
        this.logger.entering(className, methodName, new Object[]{sql, resultSetType, resultSetConcurrency});
        this._validate(methodName);
        try {
            stmt = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt;
        String methodName = "prepareStatement";
        this.logger.entering(className, methodName, new Object[]{sql, resultSetType, resultSetConcurrency, resultSetHoldability});
        this._validate(methodName);
        try {
            stmt = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt;
        String methodName = "prepareStatement";
        this.logger.entering(className, methodName, new Object[]{sql, columnNames});
        this._validate(methodName);
        try {
            stmt = this.con.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, stmt);
        return stmt;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String methodName = "releaseSavepoint";
        this.logger.entering(className, methodName, savepoint);
        this._validate(methodName);
        try {
            this.con.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void rollback() throws SQLException {
        String methodName = "rollback";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        String methodName = "rollback";
        this.logger.entering(className, methodName, savepoint);
        this._validate(methodName);
        try {
            this.con.rollback(savepoint);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        String methodName = "setAutoCommit";
        this.logger.entering(className, methodName, autoCommit);
        this._validate(methodName);
        try {
            this.con.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setNetworkTimeout(Executor exec, int milisecs) throws SQLException {
        String methodName = "setNetworkTimeout";
        this.logger.entering(className, "setNetworkTimeout");
        throw this.createSQLFeatureNotSupportedException("setNetworkTimeout", "not supported");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String methodName = "setCatalog";
        this.logger.entering(className, methodName, catalog);
        this._validate(methodName);
        try {
            this.con.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        String methodName = "setClientInfo";
        this.logger.entering(className, methodName, new Object[]{name, value});
        this._validateCI(methodName);
        try {
            this.con.setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            throw this._handleErrorCI(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        String methodName = "setClientInfo";
        this.logger.entering(className, methodName, properties);
        this._validateCI(methodName);
        try {
            this.con.setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            throw this._handleErrorCI(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        String methodName = "setHoldablity";
        this.logger.entering(className, methodName, holdability);
        this._validate(methodName);
        try {
            this.con.setHoldability(holdability);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        String methodName = "setReadOnlay";
        this.logger.entering(className, methodName, readOnly);
        this._validate(methodName);
        try {
            this.con.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Savepoint sp;
        String methodName = "setSavepoint";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        try {
            sp = this.con.setSavepoint();
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, sp);
        return sp;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Savepoint sp;
        String methodName = "setSavepoint";
        this.logger.entering(className, methodName, name);
        this._validate(methodName);
        try {
            sp = this.con.setSavepoint(name);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName, sp);
        return sp;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        String methodName = "setSchema";
        this.logger.entering(className, "setSchema", schema);
        throw this.createSQLFeatureNotSupportedException("setSchema", "not supported");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String methodName = "setTransactionIsolation";
        this.logger.entering(className, methodName, level);
        this._validate(methodName);
        try {
            this.con.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        String methodName = "setTypeMap";
        this.logger.entering(className, methodName, map);
        this._validate(methodName);
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException e) {
            throw this._handleError(methodName, e);
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, methodName, iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException(methodName, "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    private SQLException createSQLException(String methodName, String error) throws SQLException {
        SQLException sqlex = new SQLException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private SQLException createSQLFeatureNotSupportedException(String methodName, String error) throws SQLException {
        SQLFeatureNotSupportedException sqlex = new SQLFeatureNotSupportedException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private void _validate(String methodName) throws SQLException {
        if (this.con == null) {
            throw this.createSQLException(methodName, "invalid connection");
        }
    }

    private void _validateCI(String methodName) throws SQLClientInfoException {
        if (this.con == null) {
            SQLClientInfoException sqlex = new SQLClientInfoException("Invalid connection", null);
            this.logger.throwing(className, methodName, sqlex);
            throw sqlex;
        }
    }

    private SQLException _handleError(String methodName, SQLException sqlex) throws SQLException {
        this.pool.connNotify(1, sqlex);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private SQLClientInfoException _handleErrorCI(String methodName, SQLClientInfoException sqlex) throws SQLClientInfoException {
        this.pool.connNotify(1, sqlex);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

