/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMClobInputStream;
import com.raima.rdm.jdbc.RDMClobOutputStream;
import com.raima.rdm.jdbc.RDMClobReader;
import com.raima.rdm.jdbc.RDMClobWriter;
import com.raima.rdm.util.ClobHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Logger;

public class RDMClob
implements Clob {
    private boolean freed = false;
    private ClobHandler clobHandler;
    private Logger logger;
    private static final String className = "RDMClob";
    private static final String errorAccessingClob = "error accessing Clob";
    private static final String clobAlreadyFreed = "Clob already freed";
    private static final String invalidParameter = "invalid parameter";
    private static final int PARTLENGTH = 256;

    public RDMClob() throws SQLException {
        try {
            this.clobHandler = new ClobHandler();
        }
        catch (IOException e) {
            throw new SQLException(errorAccessingClob, e);
        }
        this.logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    }

    public RDMClob(char[] carr) throws SQLException {
        try {
            this.clobHandler = new ClobHandler(carr);
        }
        catch (IOException e) {
            throw new SQLException(errorAccessingClob, e);
        }
        this.logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    }

    public RDMClob(String str) throws SQLException {
        try {
            this.clobHandler = new ClobHandler(str.toCharArray());
        }
        catch (IOException e) {
            throw new SQLException(errorAccessingClob, e);
        }
        this.logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    }

    public RDMClob(Reader reader) throws SQLException {
        try {
            this.clobHandler = new ClobHandler(reader);
        }
        catch (IOException e) {
            throw new SQLException(errorAccessingClob, e);
        }
        this.logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    }

    @Override
    public void free() throws SQLException {
        String methodName = "free";
        this.logger.entering(className, methodName);
        if (!this.freed) {
            this.clobHandler = null;
            this.freed = true;
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    @Deprecated
    public InputStream getAsciiStream() throws SQLException {
        String methodName = "getAsciiStream";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        RDMClobInputStream is = null;
        try {
            is = new RDMClobInputStream(this.clobHandler);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName, is);
        return is;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        String methodName = "getCharacterStream";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        RDMClobReader rdr = null;
        try {
            rdr = new RDMClobReader(this.clobHandler);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName, rdr);
        return rdr;
    }

    @Override
    public Reader getCharacterStream(long pos, long len) throws SQLException {
        String methodName = "getCharacterStream";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        RDMClobReader rdr = null;
        try {
            if (--pos < 0L || len < 0L || pos + len > this.clobHandler.size()) {
                throw this.createSQLException(methodName, invalidParameter);
            }
            rdr = new RDMClobReader(this.clobHandler, pos, len);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName, rdr);
        return rdr;
    }

    @Override
    public String getSubString(long pos, int len) throws SQLException {
        String methodName = "getSubString";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        String s = null;
        try {
            if (--pos < 0L || len < 0 || pos + (long)len > this.clobHandler.size()) {
                throw this.createSQLException(methodName, invalidParameter);
            }
            char[] carray = new char[len];
            this.clobHandler.read(pos, carray, 0, len);
            s = String.valueOf(carray);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName, s);
        return s;
    }

    @Override
    public long length() throws SQLException {
        String methodName = "length";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        long len = -1L;
        try {
            len = this.clobHandler.size();
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName, len);
        return len;
    }

    @Override
    public long position(Clob pattern, long start) throws SQLException {
        String methodName = "position";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        if (start < 1L || pattern == null) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        try {
            long end = this.clobHandler.size() - pattern.length();
            char[] firstPatternPart = pattern.getSubString(1L, (int)Math.min(256L, pattern.length())).toCharArray();
            for (long ii = start - 1L; ii <= end; ++ii) {
                long jj;
                char[] patternPart = null;
                for (jj = 0L; jj < (long)firstPatternPart.length && this.clobHandler.read(ii + jj) == firstPatternPart[(int)jj]; ++jj) {
                }
                if (jj == (long)firstPatternPart.length) {
                    while (jj < pattern.length()) {
                        if (jj % 256L == 0L) {
                            patternPart = pattern.getSubString(jj + 1L, (int)Math.min(256L, pattern.length() - jj)).toCharArray();
                        }
                        if (this.clobHandler.read(ii + jj) != patternPart[(int)(jj % 256L)]) break;
                        ++jj;
                    }
                }
                if (jj != pattern.length()) continue;
                this.logger.exiting(className, methodName, ii + 1L);
                return ii + 1L;
            }
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName, -1);
        return -1L;
    }

    @Override
    public long position(String pattern, long start) throws SQLException {
        String methodName = "position";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        if (start < 1L || pattern == null) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        char[] carray = pattern.toCharArray();
        try {
            long end = this.clobHandler.size() - (long)pattern.length();
            for (long ii = start - 1L; ii <= end; ++ii) {
                int jj;
                for (jj = 0; jj < carray.length && this.clobHandler.read(ii + (long)jj) == carray[jj]; ++jj) {
                }
                if (jj != carray.length) continue;
                this.logger.exiting(className, methodName, ii + 1L);
                return ii + 1L;
            }
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName, -1);
        return -1L;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        String methodName = "setAsciiStream";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        if (--pos < 0L) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        RDMClobOutputStream os = new RDMClobOutputStream(this.clobHandler, pos);
        this.logger.exiting(className, methodName, os);
        return os;
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        String methodName = "setCharacterStream";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, "Clob alread freed");
        }
        if (--pos < 0L) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        RDMClobWriter w = new RDMClobWriter(this.clobHandler, pos);
        this.logger.exiting(className, methodName, w);
        return w;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str == null ? 0 : str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        String methodName = "setString";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        if (--pos < 0L || str == null || offset < 0 || len < 0 || offset + len > str.length()) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        try {
            this.clobHandler.write(pos, str.substring(offset, len).toCharArray());
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName, str.length());
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        String methodName = "setString";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, clobAlreadyFreed);
        }
        if (len < 0L) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        try {
            this.clobHandler.truncate(len);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingClob, e);
        }
        this.logger.exiting(className, methodName);
    }

    private SQLException createSQLException(String methodName, String string) throws SQLException {
        return this.createSQLException(methodName, string, null);
    }

    private SQLException createSQLException(String methodName, String string, Throwable cause) throws SQLException {
        SQLException sqlex = new SQLException(string, cause);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

