/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model.plan;

import com.couchbase.client.core.error.DatasetNotFoundException;
import com.couchbase.client.java.analytics.AnalyticsMetrics;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.analytics.AnalyticsStatus;
import com.couchbase.client.java.query.QueryResult;
import com.dbeaver.db.couchbase3.exec.CouchbaseSession;
import com.dbeaver.db.couchbase3.model.plan.CouchbasePlanNode;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class CouchbaseExecutionPlan
extends AbstractExecutionPlan {
    private static final Log log = Log.getLog(CouchbaseExecutionPlan.class);
    private final String query;
    private List<CouchbasePlanNode> nodes;

    public CouchbaseExecutionPlan(@NotNull String query, @NotNull CouchbaseSession session) {
        this.query = query;
        Gson gson = new Gson();
        String planQueryString = this.getPlanQueryString();
        QueryResult planResultSet = session.getExecutionContext().getCluster().query(planQueryString);
        for (com.couchbase.client.java.json.JsonObject jsonObject : planResultSet.rowsAsObject()) {
            ArrayList<CouchbasePlanNode> nodes = new ArrayList<CouchbasePlanNode>();
            JsonObject gsonObject = (JsonObject)gson.fromJson(jsonObject.toString(), JsonObject.class);
            CouchbasePlanNode rootNode = new CouchbasePlanNode(null, "Analytics", gsonObject);
            try {
                AnalyticsResult analyticsResult = session.getExecutionContext().getCluster().analyticsQuery(query);
                if (analyticsResult.metaData().status().equals((Object)AnalyticsStatus.SUCCESS)) {
                    AnalyticsMetrics metricsJSON = analyticsResult.metaData().metrics();
                    rootNode.injectMetrics(metricsJSON);
                }
            }
            catch (DatasetNotFoundException exception) {
                log.warn((Object)exception);
            }
            nodes.add(rootNode);
            this.nodes = nodes;
        }
    }

    public CouchbaseExecutionPlan(@NotNull String query, @NotNull List<CouchbasePlanNode> nodes) {
        this.nodes = nodes;
        this.query = query;
    }

    @NotNull
    public String getQueryString() {
        return this.query;
    }

    public Object getPlanFeature(String feature) {
        return null;
    }

    public String getPlanQueryString() {
        return "EXPLAIN " + this.query;
    }

    @NotNull
    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.nodes;
    }
}

