/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.couchbase.client.java.http.HttpPath;
import com.couchbase.client.java.http.HttpResponse;
import com.couchbase.client.java.http.HttpTarget;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.dbeaver.db.couchbase3.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.impl.AbstractDataSourceInfo;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CouchbaseDataSourceInfo
extends AbstractDataSourceInfo {
    private static final Log log = Log.getLog(CouchbaseDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "org.jkiss.bundle.couchbase";
    private final CouchbaseDataSource dataSource;

    public CouchbaseDataSourceInfo(CouchbaseDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDatabaseProductName() {
        JsonObject value;
        JsonArray nodes;
        HttpPath of = HttpPath.of((String)"/pools/default/terseClusterInfo?all=true", (String[])new String[0]);
        HttpResponse httpResponse = ((CouchbaseExecutionContext)this.dataSource.getDefaultContext()).getCluster().httpClient().get(HttpTarget.manager(), of);
        if (httpResponse.success() && (nodes = (value = JsonObject.fromJson((String)httpResponse.contentAsString())).getArray("nodes")) != null && !nodes.isEmpty()) {
            String version = nodes.getObject(0).getString("version");
            return "Couchbase " + version;
        }
        return "Couchbase";
    }

    public String getDatabaseProductVersion() {
        return this.getDatabaseVersion().toString();
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Couchbase driver bundle 'org.jkiss.bundle.couchbase' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        JsonObject value;
        JsonArray nodes;
        HttpPath of = HttpPath.of((String)"/pools/default/terseClusterInfo?all=true", (String[])new String[0]);
        HttpResponse httpResponse = ((CouchbaseExecutionContext)this.dataSource.getDefaultContext()).getCluster().httpClient().get(HttpTarget.manager(), of);
        if (httpResponse.success() && (nodes = (value = JsonObject.fromJson((String)httpResponse.contentAsString())).getArray("nodes")) != null && !nodes.isEmpty()) {
            String version = nodes.getObject(0).getString("version");
            String[] values = version.split("-");
            return new Version(CommonUtils.toInt((Object)values[0].replace(".", "")), CommonUtils.toInt((Object)values[1].replace(".", "")), 0, values[2]);
        }
        return null;
    }

    public String getDriverName() {
        Optional version = ((CouchbaseExecutionContext)this.dataSource.getDefaultContext()).getCluster().environment().clientVersion();
        if (version.isEmpty()) {
            return "Couchbase";
        }
        return "Couchbase " + (String)version.get();
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return null;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsResultSetLimit() {
        return true;
    }

    public boolean supportsResultSetScroll() {
        return true;
    }

    public boolean supportsMultipleResults() {
        return true;
    }

    public boolean isDynamicMetadata() {
        return true;
    }
}

