/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import com.dbeaver.model.document.data.DBMapValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;

public class CouchbaseUtils {
    private static final Log log = Log.getLog(CouchbaseUtils.class);

    public static DBPDataKind getAttributeKind(Object value) {
        if (value instanceof String) {
            return DBPDataKind.STRING;
        }
        if (value instanceof Number) {
            return DBPDataKind.NUMERIC;
        }
        if (value instanceof Boolean) {
            return DBPDataKind.BOOLEAN;
        }
        if (value instanceof Date) {
            return DBPDataKind.DATETIME;
        }
        if (value instanceof JsonObject) {
            return DBPDataKind.STRUCT;
        }
        if (value instanceof JsonArray) {
            return DBPDataKind.ARRAY;
        }
        return DBPDataKind.OBJECT;
    }

    public static Object getRawAttributeValue(@NotNull CouchbaseDataSource dataSource, Object parent, Object value) {
        if (value instanceof JsonObject) {
            return CouchbaseUtils.makeRawMap(dataSource, parent, (JsonObject)value);
        }
        if (value instanceof JsonArray) {
            return CouchbaseUtils.makeRawList(dataSource, parent, (JsonArray)value);
        }
        return value;
    }

    private static List<Object> makeRawList(@NotNull CouchbaseDataSource dataSource, Object parent, JsonArray list) {
        ArrayList<Object> rawList = new ArrayList<Object>();
        for (Object av : list) {
            rawList.add(CouchbaseUtils.getRawAttributeValue(dataSource, parent, av));
        }
        return rawList;
    }

    public static DBMapValue<CouchbaseDataSource> makeRawMap(@NotNull CouchbaseDataSource dataSource, Object parent, JsonObject item) {
        LinkedHashMap<String, Object> rawMap = new LinkedHashMap<String, Object>();
        for (String name : item.getNames()) {
            rawMap.put(name, CouchbaseUtils.getRawAttributeValue(dataSource, parent, item.get(name)));
        }
        return new DBMapValue((DBPDataSource)dataSource, parent, rawMap);
    }
}

