/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions.restriction;

import com.influxdb.query.dsl.functions.properties.FunctionsParameters;
import com.influxdb.query.dsl.functions.restriction.Restrictions;
import com.influxdb.utils.Arguments;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ColumnRestriction {
    private final String fieldName;

    ColumnRestriction(@Nonnull String recordColumn) {
        Arguments.checkNonEmpty((String)recordColumn, (String)"Record column");
        this.fieldName = recordColumn;
    }

    @Nonnull
    public Restrictions equal(@Nonnull Object value) {
        return this.custom(value, "==");
    }

    @Nonnull
    public Restrictions notEqual(@Nonnull Object value) {
        return this.custom(value, "!=");
    }

    @Nonnull
    public Restrictions less(@Nonnull Object value) {
        return this.custom(value, "<");
    }

    @Nonnull
    public Restrictions greater(@Nonnull Object value) {
        return this.custom(value, ">");
    }

    @Nonnull
    public Restrictions lessOrEqual(@Nonnull Object value) {
        return this.custom(value, "<=");
    }

    @Nonnull
    public Restrictions greaterOrEqual(@Nonnull Object value) {
        return this.custom(value, ">=");
    }

    @Nonnull
    public Restrictions custom(@Nonnull Object value, @Nonnull String operator) {
        return new OperatorRestrictions(this.fieldName, value, operator);
    }

    @Nonnull
    public Restrictions exists() {
        return new ExistsRestrictions(this.fieldName);
    }

    @Nonnull
    public Restrictions contains(@Nonnull String[] set) {
        return new ContainsRestrictions(this.fieldName, set);
    }

    private static final class OperatorRestrictions
    extends Restrictions {
        private final String fieldName;
        private final Object fieldValue;
        private final String operator;

        private OperatorRestrictions(@Nonnull String fieldName, @Nonnull Object fieldValue, @Nonnull String operator) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
            this.operator = operator;
        }

        public String toString() {
            Object value = this.fieldValue instanceof String ? (this.operator.contains("~") ? FunctionsParameters.escapeDoubleQuotes((String)this.fieldValue) : "\"" + FunctionsParameters.escapeDoubleQuotes((String)this.fieldValue) + "\"") : FunctionsParameters.serializeValue(this.fieldValue, false);
            return "r[\"" + FunctionsParameters.escapeDoubleQuotes(this.fieldName) + "\"] " + this.operator + " " + (String)value;
        }
    }

    private static final class ExistsRestrictions
    extends Restrictions {
        private final String fieldName;

        public ExistsRestrictions(@Nonnull String fieldName) {
            this.fieldName = fieldName;
        }

        public String toString() {
            return "exists r[\"" + FunctionsParameters.escapeDoubleQuotes(this.fieldName) + "\"]";
        }
    }

    private static final class ContainsRestrictions
    extends Restrictions {
        private final String fieldName;
        private final String[] set;

        public ContainsRestrictions(@Nonnull String fieldName, @Nonnull String[] set) {
            this.fieldName = fieldName;
            this.set = set;
        }

        public String toString() {
            return "contains(value: r[\"" + FunctionsParameters.escapeDoubleQuotes(this.fieldName) + "\"], set:[" + Arrays.stream(this.set).map(FunctionsParameters::escapeDoubleQuotes).collect(Collectors.joining("\", \"", "\"", "\"")) + "])";
        }
    }
}

