/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DataImporterXML
extends StreamImporterAbstract {
    private static final int MAX_COLUMN_LENGTH = 1024;
    private static final int ROW_ELEMENT = 2;
    private static final int COLUMN_ELEMENT = 3;
    public static final String PROP_STRICT_FORMAT = "strictFormat";
    public static final String PROP_COLUMN_READ_METHOD = "columnReadMethod";
    private static final String PROP_ITEM_ELEMENT = "itemElement";
    private boolean strictFormat;
    private ColumnReadMethod columnReadMethod;
    private String itemElement;

    @NotNull
    public List<StreamDataImporterColumnInfo> readColumnsInfo(final @NotNull StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        final LinkedHashMap columns = new LinkedHashMap();
        this.initFromParameters();
        try {
            new SAXReader(inputStream).parse((SAXListener)new BaseSaxListener(this){

                @Override
                public void saxStartElement(@NotNull SAXReader reader, @Nullable String ns, @NotNull String name, @NotNull Attributes attributes) throws XMLException {
                    super.saxStartElement(reader, ns, name, attributes);
                    if (this.isRowElement && columnReadMethod.isAttributes()) {
                        int i = 0;
                        while (i < attributes.getLength()) {
                            String attrName = attributes.getLocalName(i);
                            columns.computeIfAbsent(attrName, key -> new XMLAttributeColumn(entityMapping, columns.size(), attrName, "String", 1024, DBPDataKind.STRING, true));
                            ++i;
                        }
                    }
                }

                @Override
                public void saxEndElement(@NotNull SAXReader reader, @Nullable String ns, @NotNull String name) throws XMLException {
                    this.detectElementType(name);
                    if (this.isColumnElement) {
                        String data = this.buffer.toString();
                        Pair dataType = DatabaseTransferUtils.getDataType((String)data);
                        StreamDataImporterColumnInfo columnInfo = columns.computeIfAbsent(name, key -> {
                            XMLAttributeColumn info = new XMLAttributeColumn(entityMapping, columns.size(), (String)key, "String", 1024, DBPDataKind.UNKNOWN, false);
                            info.setMappingMetadataPresent(true);
                            return info;
                        });
                        switch ((DBPDataKind)dataType.getFirst()) {
                            case STRING: {
                                columnInfo.updateMaxLength(entityMapping.getDataSource(), (long)data.length());
                            }
                            case BOOLEAN: 
                            case NUMERIC: {
                                columnInfo.updateType((DBPDataKind)dataType.getFirst(), (String)dataType.getSecond());
                                break;
                            }
                        }
                    }
                    super.saxEndElement(reader, ns, name);
                }
            });
        }
        catch (IOException | XMLException e) {
            throw new DBException("Error parsing XML file", e);
        }
        return new ArrayList<StreamDataImporterColumnInfo>(columns.values());
    }

    private void initFromParameters() {
        Map properties = this.getSite().getProcessorProperties();
        this.strictFormat = CommonUtils.toBoolean(properties.get(PROP_STRICT_FORMAT));
        this.itemElement = CommonUtils.toString(properties.get(PROP_ITEM_ELEMENT), null);
        if (CommonUtils.isEmpty((String)this.itemElement)) {
            this.itemElement = null;
        }
        this.columnReadMethod = (ColumnReadMethod)CommonUtils.valueOf(ColumnReadMethod.class, (String)CommonUtils.toString(properties.get(PROP_COLUMN_READ_METHOD)).toUpperCase(), (Enum)ColumnReadMethod.ELEMENTS);
    }

    public void runImport(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource streamDataSource, @NotNull InputStream inputStream, final @NotNull IDataTransferConsumer<?, ?> consumer) throws DBException {
        this.initFromParameters();
        DBCExecutionContext context = streamDataSource.getDefaultInstance().getDefaultContext(monitor, false);
        StreamEntityMapping entityMapping = this.getSite().getSourceObject();
        Throwable throwable = null;
        Object var8_9 = null;
        try (final DBCSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");){
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (LocalStatement localStatement = new LocalStatement(producerSession, "SELECT * FROM " + this.getSite().getSourceObject().getEntityName());){
                Throwable throwable3 = null;
                Object var14_19 = null;
                try (final StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);){
                    DBDDataReceiver.startFetchWorkflow(consumer, (DBCSession)producerSession, (DBCResultSet)resultSet, (long)-1L, (long)-1L);
                    try {
                        new SAXReader(inputStream).parse((SAXListener)new BaseSaxListener(this, entityMapping){
                            private final Map<String, String> values;
                            private final List<XMLAttributeColumn> attrColumns;
                            {
                                this.values = new LinkedHashMap<String, String>();
                                this.attrColumns = new ArrayList<XMLAttributeColumn>();
                                for (StreamDataImporterColumnInfo column : streamEntityMapping.getStreamColumns()) {
                                    XMLAttributeColumn xmlAttr;
                                    this.values.put(column.getName(), null);
                                    if (!(column instanceof XMLAttributeColumn) || !(xmlAttr = (XMLAttributeColumn)column).isXmlAttribute()) continue;
                                    this.attrColumns.add(xmlAttr);
                                }
                            }

                            @Override
                            public void saxStartElement(@NotNull SAXReader reader, @Nullable String ns, @NotNull String name, @NotNull Attributes attributes) throws XMLException {
                                super.saxStartElement(reader, ns, name, attributes);
                                if (this.isRowElement && columnReadMethod.isAttributes() && !this.attrColumns.isEmpty()) {
                                    for (XMLAttributeColumn xmlAttr : this.attrColumns) {
                                        String value = attributes.getValue("", xmlAttr.getName());
                                        if (value == null) continue;
                                        this.values.put(xmlAttr.getName(), value.trim());
                                    }
                                }
                            }

                            @Override
                            public void saxEndElement(@NotNull SAXReader reader, @Nullable String ns, @NotNull String name) throws XMLException {
                                this.detectElementType(name);
                                if (this.isColumnElement) {
                                    this.values.put(name, this.buffer.toString().trim());
                                } else if (this.isRowElement) {
                                    resultSet.setStreamRow(this.values.values().toArray());
                                    this.values.replaceAll((k, v) -> null);
                                    try {
                                        consumer.fetchRow(producerSession, (DBCResultSet)resultSet);
                                    }
                                    catch (DBException e) {
                                        throw new XMLException("Error fetching row", (Throwable)e);
                                    }
                                }
                                super.saxEndElement(reader, ns, name);
                            }
                        });
                    }
                    catch (IOException | XMLException e) {
                        throw new DBException("Error importing date from XML file", e);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private class BaseSaxListener
    implements SAXListener {
        protected final StringBuilder buffer = new StringBuilder();
        protected String lastRowElemName;
        protected final List<String> elementStack = new ArrayList<String>();
        protected boolean isRowElement;
        protected boolean isColumnElement;

        private BaseSaxListener() {
        }

        private String getParentElement() {
            return this.elementStack.size() < 2 ? null : this.elementStack.get(this.elementStack.size() - 2);
        }

        protected void detectElementType(String name) {
            this.isRowElement = this.elementStack.size() == 2 && DataImporterXML.this.itemElement == null || DataImporterXML.this.itemElement != null && Objects.equals(DataImporterXML.this.itemElement, name);
            this.isColumnElement = !this.isRowElement && DataImporterXML.this.columnReadMethod.isElements() && (this.elementStack.size() == 3 && DataImporterXML.this.itemElement == null || DataImporterXML.this.itemElement != null && Objects.equals(DataImporterXML.this.itemElement, this.getParentElement()));
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String ns, @NotNull String name, @NotNull Attributes attributes) throws XMLException {
            this.elementStack.add(name);
            this.detectElementType(name);
            if (this.isRowElement) {
                if (this.lastRowElemName != null) {
                    if (DataImporterXML.this.strictFormat && !this.lastRowElemName.equals(name)) {
                        throw new XMLException("Inconsistent XML format. Row elements must have the same element name.\n'" + name + "' encountered while '" + this.lastRowElemName + "' was expected");
                    }
                } else {
                    this.lastRowElemName = name;
                }
            }
        }

        public void saxEndElement(@NotNull SAXReader reader, @Nullable String ns, @NotNull String name) throws XMLException {
            this.elementStack.removeLast();
            this.buffer.setLength(0);
            this.isColumnElement = false;
            this.isRowElement = false;
        }

        public void saxText(@NotNull SAXReader reader, @NotNull String data) {
            if (this.isColumnElement) {
                this.buffer.append(data);
            }
        }
    }

    public static enum ColumnReadMethod {
        ELEMENTS(true, false),
        ATTRIBUTES(false, true),
        BOTH(true, true);

        private final boolean elements;
        private final boolean attributes;

        private ColumnReadMethod(boolean elements, boolean attributes) {
            this.elements = elements;
            this.attributes = attributes;
        }

        public boolean isElements() {
            return this.elements;
        }

        public boolean isAttributes() {
            return this.attributes;
        }
    }

    private static class XMLAttributeColumn
    extends StreamDataImporterColumnInfo {
        private final boolean xmlAttribute;

        public XMLAttributeColumn(StreamEntityMapping entity, int columnIndex, @NotNull String columnName, @NotNull String typeName, int maxLength, DBPDataKind dataKind, boolean isXmlAttribute) {
            super(entity, columnIndex, columnName, typeName, maxLength, dataKind);
            this.xmlAttribute = isXmlAttribute;
        }

        public boolean isXmlAttribute() {
            return this.xmlAttribute;
        }
    }
}

