/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.xls;

import com.github.pjfanning.xlsx.StreamingReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.stream.IMultiStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.utils.CommonUtils;

public class DataImporterXLSX
extends StreamImporterAbstract
implements IMultiStreamDataImporter {
    private static final Log log = Log.getLog(DataImporterXLSX.class);
    private static final String PROP_HEADER = "header";
    private static final String PROP_SKIP_EMPTY_ROWS = "skipEmptyRows";
    private static final String PROP_MANY_SHEETS = "manySheets";
    private static final String PROP_SPECIFIC_SHEET_NAME = "specificSheetName";
    private int columnNumber;

    @NotNull
    public List<StreamDataImporterColumnInfo> readColumnsInfo(StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        ArrayList<StreamDataImporterColumnInfo> columnsInfo;
        block19: {
            columnsInfo = new ArrayList<StreamDataImporterColumnInfo>();
            Map processorProperties = this.getSite().getProcessorProperties();
            HeaderPosition headerPosition = this.getHeaderPosition(processorProperties);
            String specificSheetName = CommonUtils.toString(processorProperties.get(PROP_SPECIFIC_SHEET_NAME));
            boolean useManySheets = CommonUtils.isEmpty((String)specificSheetName) && CommonUtils.getBoolean(processorProperties.get(PROP_MANY_SHEETS), (boolean)false);
            int columnSamplesCount = Math.max(CommonUtils.toInt(processorProperties.get("columnTypeSamplesCount"), (int)100), 0);
            int columnMinimalLength = Math.max(CommonUtils.toInt(processorProperties.get("columnTypeMinimalLength"), (int)1), 1);
            try {
                Throwable throwable = null;
                Iterator iterator = null;
                try (Workbook workbook = DataImporterXLSX.openWorkbook(inputStream);){
                    Sheet specificSheet = null;
                    if (entityMapping.isChild()) {
                        specificSheet = workbook.getSheet(entityMapping.getEntityName());
                    } else if (CommonUtils.isNotEmpty((String)specificSheetName)) {
                        try {
                            specificSheet = workbook.getSheet(specificSheetName);
                        }
                        catch (Exception exception) {
                            log.error((Object)("Sheet '" + specificSheetName + "' does not exist. The first sheet will be used."));
                        }
                    }
                    if (specificSheet != null) {
                        this.readColumnInfoFromSheet(entityMapping, columnsInfo, headerPosition, columnSamplesCount, columnMinimalLength, specificSheet.rowIterator());
                        break block19;
                    }
                    for (Sheet sheet : workbook) {
                        Iterator it = sheet.rowIterator();
                        this.readColumnInfoFromSheet(entityMapping, columnsInfo, headerPosition, columnSamplesCount, columnMinimalLength, it);
                        if (useManySheets) continue;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new DBException("Error reading XLSX", e);
            }
        }
        for (StreamDataImporterColumnInfo columnInfo : columnsInfo) {
            if (columnInfo.getDataKind() != DBPDataKind.UNKNOWN) continue;
            log.debug((Object)("Cannot guess data type for column '" + columnInfo.getName() + "', defaulting to VARCHAR"));
            columnInfo.updateType(DBPDataKind.STRING, "VARCHAR");
        }
        return columnsInfo;
    }

    @NotNull
    public List<StreamEntityMapping> readEntitiesInfo(@NotNull StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        ArrayList<StreamEntityMapping> entities = new ArrayList<StreamEntityMapping>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Workbook workbook = DataImporterXLSX.openWorkbook(inputStream);){
                for (Sheet sheet : workbook) {
                    entities.add(new StreamEntityMapping(entityMapping.getInputFile(), sheet.getSheetName(), true));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading XLSX", (Throwable)e);
        }
        return entities;
    }

    private void readColumnInfoFromSheet(@NotNull StreamEntityMapping entityMapping, @NotNull List<StreamDataImporterColumnInfo> columnsInfo, @NotNull HeaderPosition headerPosition, int columnSamplesCount, int columnMinimalLength, @NotNull Iterator<Row> it) throws DBException {
        if (it.hasNext()) {
            Row header = it.next();
            int col = 0;
            while (col < header.getLastCellNum()) {
                Object name = null;
                Cell cell = header.getCell(col);
                if (headerPosition == HeaderPosition.top && cell != null) {
                    name = cell.getStringCellValue();
                }
                if (CommonUtils.isEmptyTrimmed(name)) {
                    name = "Column" + ++this.columnNumber;
                }
                StreamDataImporterColumnInfo info = new StreamDataImporterColumnInfo(entityMapping, col, (String)name, "String", columnMinimalLength, DBPDataKind.UNKNOWN);
                info.setMappingMetadataPresent(headerPosition != HeaderPosition.none);
                columnsInfo.add(info);
                ++col;
            }
            int sample = 0;
            while (sample < columnSamplesCount && it.hasNext()) {
                Row row = it.next();
                int col2 = 0;
                int len = columnsInfo.size();
                while (col2 < len) {
                    StreamDataImporterColumnInfo info = columnsInfo.get(col2);
                    Cell cell = row.getCell(col2);
                    if (cell == null) {
                        info.updateType(DBPDataKind.STRING, "varchar");
                    } else {
                        CellType type = cell.getCellType();
                        switch (type) {
                            case NUMERIC: {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    info.updateType(DBPDataKind.DATETIME, "DATE");
                                    break;
                                }
                                info.updateType(DBPDataKind.NUMERIC, "INT");
                                break;
                            }
                            case BOOLEAN: {
                                info.updateType(DBPDataKind.BOOLEAN, "BOOLEAN");
                                break;
                            }
                            default: {
                                String value = cell.getStringCellValue();
                                String stringType = "varchar";
                                if (value == null) break;
                                if (!value.isEmpty() && !SQLUtils.isLatinLetter((int)value.charAt(0))) {
                                    stringType = "nvarchar";
                                }
                                info.updateType(DBPDataKind.STRING, stringType);
                                info.updateMaxLength(entityMapping.getDataSource(), (long)value.length());
                            }
                        }
                    }
                    ++col2;
                }
                ++sample;
            }
        } else {
            throw new DBException("Empty XLSX file");
        }
    }

    public void runImport(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource streamDataSource, @NotNull InputStream inputStream, @NotNull IDataTransferConsumer<?, ?> consumer) throws DBException {
        block45: {
            IStreamDataImporterSite site = this.getSite();
            StreamEntityMapping entityMapping = site.getSourceObject();
            Map properties = site.getProcessorProperties();
            boolean skipEmptyRow = CommonUtils.getBoolean(properties.get(PROP_SKIP_EMPTY_ROWS), (boolean)true);
            String specificSheetName = CommonUtils.toString(properties.get(PROP_SPECIFIC_SHEET_NAME));
            boolean useManySheets = CommonUtils.isEmpty((String)specificSheetName) && CommonUtils.getBoolean(properties.get(PROP_MANY_SHEETS), (boolean)false);
            DBCExecutionContext context = streamDataSource.getDefaultInstance().getDefaultContext(monitor, false);
            Throwable throwable = null;
            Object var13_14 = null;
            try (DBCSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");){
                Throwable throwable2 = null;
                Object var16_19 = null;
                try (LocalStatement localStatement = new LocalStatement(producerSession, "SELECT * FROM Stream");){
                    Throwable throwable3 = null;
                    Object var19_24 = null;
                    try (StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);){
                        DBDDataReceiver.startFetchWorkflow(consumer, (DBCSession)producerSession, (DBCResultSet)resultSet, (long)-1L, (long)-1L);
                        this.applyTransformHints(resultSet, consumer, properties, "timestampFormat", "timestampZone");
                        try {
                            Throwable throwable4 = null;
                            Object var22_30 = null;
                            try (Workbook workbook = DataImporterXLSX.openWorkbook(inputStream);){
                                HeaderPosition headerPosition = this.getHeaderPosition(properties);
                                int maxRows = site.getSettings().getMaxRows();
                                int targetAttrSize = entityMapping.getStreamColumns().size();
                                Sheet specificSheet = null;
                                if (entityMapping.isChild()) {
                                    specificSheet = workbook.getSheet(entityMapping.getEntityName());
                                } else if (CommonUtils.isNotEmpty((String)specificSheetName)) {
                                    try {
                                        specificSheet = workbook.getSheet(specificSheetName);
                                    }
                                    catch (Exception exception) {
                                        log.error((Object)("Sheet '" + specificSheetName + "' does not exist. The first sheet will be used."));
                                    }
                                }
                                if (specificSheet != null) {
                                    this.runImportFromSheet(monitor, consumer, skipEmptyRow, producerSession, resultSet, headerPosition, maxRows, targetAttrSize, specificSheet);
                                    break block45;
                                }
                                for (Sheet sheet : workbook) {
                                    this.runImportFromSheet(monitor, consumer, skipEmptyRow, producerSession, resultSet, headerPosition, maxRows, targetAttrSize, sheet);
                                    if (useManySheets) continue;
                                    break;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable4 == null) {
                                    throwable4 = throwable5;
                                } else if (throwable4 != throwable5) {
                                    throwable4.addSuppressed(throwable5);
                                }
                                throw throwable4;
                            }
                        }
                        catch (IOException e) {
                            throw new DBException("IO error reading XLSX", (Throwable)e);
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable3 == null) {
                            throwable3 = throwable6;
                        } else if (throwable3 != throwable6) {
                            throwable3.addSuppressed(throwable6);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                    } else if (throwable2 != throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
    }

    private void runImportFromSheet(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferConsumer<?, ?> consumer, boolean skipEmptyRow, DBCSession producerSession, @NotNull StreamTransferResultSet resultSet, @NotNull HeaderPosition headerPosition, int maxRows, int targetAttrSize, @NotNull Sheet sheet) throws DBException {
        boolean headerRead = false;
        monitor.subTask("Import from XLSX file");
        int rowNum = 0;
        for (Row row : sheet) {
            if (monitor.isCanceled()) break;
            ++rowNum;
            if (headerPosition == HeaderPosition.top && !headerRead) {
                headerRead = true;
                continue;
            }
            if (maxRows > 0 && rowNum >= maxRows) break;
            int lastCellNum = row.getLastCellNum();
            if (lastCellNum < 0) {
                if (skipEmptyRow) continue;
                lastCellNum = targetAttrSize;
            }
            Object[] cellsToResultSet = new Object[lastCellNum];
            boolean allBlank = true;
            int cellNum = row.getFirstCellNum();
            while (cellNum < lastCellNum) {
                Cell currentCell = row.getCell(cellNum);
                if (currentCell != null) {
                    if (allBlank && currentCell.getCellType() != CellType.BLANK) {
                        allBlank = false;
                    }
                    switch (currentCell.getCellType()) {
                        case NUMERIC: {
                            List targetAttributes;
                            boolean readCellAsString = false;
                            if (consumer instanceof DatabaseTransferConsumer && !CommonUtils.isEmpty((Collection)(targetAttributes = ((DatabaseTransferConsumer)consumer).getTargetAttributes())) && cellNum >= 0 && cellNum < targetAttributes.size()) {
                                boolean bl = readCellAsString = ((DBSAttributeBase)targetAttributes.get(cellNum)).getDataKind() == DBPDataKind.STRING;
                            }
                            if (DateUtil.isCellDateFormatted((Cell)currentCell)) {
                                cellsToResultSet[cellNum] = currentCell.getDateCellValue();
                                break;
                            }
                            if (!readCellAsString) {
                                cellsToResultSet[cellNum] = currentCell.getNumericCellValue();
                                break;
                            }
                            cellsToResultSet[cellNum] = currentCell.getStringCellValue();
                            break;
                        }
                        case BOOLEAN: {
                            cellsToResultSet[cellNum] = currentCell.getBooleanCellValue();
                            break;
                        }
                        case BLANK: {
                            cellsToResultSet[cellNum] = null;
                            break;
                        }
                        default: {
                            cellsToResultSet[cellNum] = currentCell.getStringCellValue();
                        }
                    }
                }
                ++cellNum;
            }
            if (skipEmptyRow && allBlank) continue;
            if (cellsToResultSet.length < targetAttrSize) {
                Object[] newCellsToResultSet = new Object[targetAttrSize];
                System.arraycopy(cellsToResultSet, 0, newCellsToResultSet, 0, cellsToResultSet.length);
                int i = cellsToResultSet.length;
                while (i < targetAttrSize) {
                    newCellsToResultSet[i] = null;
                    ++i;
                }
                cellsToResultSet = newCellsToResultSet;
            }
            resultSet.setStreamRow(cellsToResultSet);
            consumer.fetchRow(producerSession, (DBCResultSet)resultSet);
            monitor.worked(1);
            if (rowNum % 1000 != 0) continue;
            monitor.subTask(rowNum + " rows processed");
        }
    }

    @NotNull
    private HeaderPosition getHeaderPosition(Map<String, Object> processorProperties) {
        return (HeaderPosition)CommonUtils.valueOf(HeaderPosition.class, (String)CommonUtils.toString((Object)processorProperties.get(PROP_HEADER)), (Enum)HeaderPosition.none);
    }

    @NotNull
    private static Workbook openWorkbook(@NotNull InputStream inputStream) {
        return StreamingReader.builder().rowCacheSize(200).bufferSize(10000).open(inputStream);
    }

    static enum HeaderPosition {
        none,
        top;

    }
}

