/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.pref;

import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.TBUtils;
import com.dbeaver.model.tableau.auth.TBAuthConfiguration;
import com.dbeaver.model.tableau.auth.TBAuthProfile;
import com.dbeaver.model.tableau.navigator.DBNTableauAbstractNode;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.model.tableau.navigator.DBNTableauRootNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import com.dbeaver.ui.tableau.actions.NavigatorHandlerAssociateDataSource;
import com.dbeaver.ui.tableau.actions.NavigatorHandlerShowPreferences;
import com.dbeaver.ui.tableau.view.TableauSitesView;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectBrowserDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;

public class TableauDataSourcePreferencePage
extends AbstractPrefPage
implements IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(TableauDataSourcePreferencePage.class);
    private IAdaptable element;
    private Table conTable;
    private Combo profileCombo;
    private List<TBAuthProfile> allProfiles;
    private TBAuthProfile selectedProfile;

    protected void performDefaults() {
    }

    public boolean performOk() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite placeholder = UIUtils.createComposite((Composite)parent, (int)3);
        placeholder.setLayoutData((Object)new GridData(1808));
        this.profileCombo = UIUtils.createLabelCombo((Composite)placeholder, (String)"Profile", (int)12);
        UIUtils.createDialogButton((Composite)placeholder, (String)"Settings", (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            NavigatorHandlerShowPreferences.showPreferences(this.getShell());
            this.loadProfileList();
        }));
        Group dsGroup = UIUtils.createControlGroup((Composite)placeholder, (String)"Associated Tableau connections", (int)1, (int)1808, (int)-1);
        ((GridData)dsGroup.getLayoutData()).horizontalSpan = 3;
        this.conTable = new Table((Composite)dsGroup, 67584);
        this.conTable.setLayoutData((Object)new GridData(1808));
        this.conTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)this.conTable, (int)16384, (String)"Site");
        UIUtils.createTableColumn((Table)this.conTable, (int)16384, (String)"Data Source");
        UIUtils.createTableColumn((Table)this.conTable, (int)16384, (String)"Connection");
        Composite buttonsPanel = UIUtils.createComposite((Composite)dsGroup, (int)2);
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Link connection", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBNTableauRootNode tbRootNode = TBUtils.getTableauProjectNode((DBNModel)DBWorkbench.getPlatform().getNavigatorModel());
                DBNNode tbConNode = ObjectBrowserDialog.selectObject((Shell)TableauDataSourcePreferencePage.this.getShell(), (String)"Select Tableau connection", (DBNNode)tbRootNode, null, (Class[])new Class[]{DBNTableauAbstractNode.class}, (Class[])new Class[]{TDSConnection.class}, null);
                if (tbConNode instanceof DBNTableauDataSourceConnectionNode && NavigatorHandlerAssociateDataSource.linkConnectionWithDataSource((DBNTableauDataSourceConnectionNode)tbConNode, TableauDataSourcePreferencePage.this.getRealDataSource())) {
                    TableauDataSourcePreferencePage.this.createConnectionItem(((DBNTableauDataSourceConnectionNode)tbConNode).getConnection());
                }
            }
        });
        Button unlinkButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Unlink connection", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selectedItem = TableauDataSourcePreferencePage.this.conTable.getSelection()[0];
                if (!(selectedItem.getData() instanceof TDSConnection)) {
                    return;
                }
                TDSConnection tdsConnection = (TDSConnection)selectedItem.getData();
                if (!UIUtils.confirmAction((Shell)TableauDataSourcePreferencePage.this.getShell(), (String)"Unlink Tableau connection", (String)("Are you sure you want to unlink connection '" + tdsConnection.getName() + "'?"))) {
                    return;
                }
                try {
                    DBNTableauRootNode tbRootNode = TBUtils.getTableauProjectNode((DBNModel)DBWorkbench.getPlatform().getNavigatorModel());
                    DBNTableauDataSourceConnectionNode connectionNode = tbRootNode.findConnectionNode((DBRProgressMonitor)new VoidProgressMonitor(), tdsConnection);
                    if (connectionNode != null && NavigatorHandlerAssociateDataSource.unlinkConnectionFromDataSource(connectionNode, TableauDataSourcePreferencePage.this.getRealDataSource())) {
                        selectedItem.dispose();
                    }
                }
                catch (DBException ex) {
                    DBWorkbench.getPlatformUI().showError("Unlink error", "Error unlinking Tableau connection", (Throwable)ex);
                }
            }
        });
        unlinkButton.setEnabled(false);
        this.conTable.addMouseListener(MouseListener.mouseDoubleClickAdapter(mouseEvent -> {}));
        this.conTable.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(selectionEvent -> {
            try {
                TableItem selectedItem = this.conTable.getSelection()[0];
                if (!(selectedItem.getData() instanceof TDSConnection)) {
                    return;
                }
                TDSConnection tdsConnection = (TDSConnection)selectedItem.getData();
                TableauSitesView tbView = (TableauSitesView)UIUtils.getActiveWorkbenchWindow().getActivePage().showView("com.dbeaver.tableau.sites");
                if (tbView != null) {
                    UIUtils.asyncExec(() -> this.showConnectionInView(tdsConnection, tbView));
                }
            }
            catch (Exception e1) {
                DBWorkbench.getPlatformUI().showError("Show view", "Error opening Tableau view", (Throwable)e1);
            }
        }));
        this.conTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            boolean dsSelected = this.conTable.getSelectionIndex() >= 0;
            unlinkButton.setEnabled(dsSelected);
        }));
        this.loadProfileList();
        this.performDefaults();
        return placeholder;
    }

    private DBPDataSourceContainer getRealDataSource() {
        DBPDataSourceContainer dataSource = this.getDataSource();
        return dataSource.getRegistry().getDataSource(dataSource.getId());
    }

    private void showConnectionInView(TDSConnection tdsConnection, TableauSitesView tbView) {
        try {
            UIUtils.runInProgressService(monitor -> {
                DBNTableauRootNode rootNode = (DBNTableauRootNode)tbView.getNavigatorTree().getModel();
                try {
                    DBNTableauDataSourceConnectionNode conNode = rootNode.findConnectionNode(monitor, tdsConnection);
                    if (conNode != null) {
                        UIUtils.syncExec(() -> tbView.getNavigatorViewer().setSelection((ISelection)new StructuredSelection((Object)conNode)));
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Show view", "Error opening Tableau view", (Throwable)e);
        }
    }

    private void loadProfileList() {
        this.allProfiles = TBAuthConfiguration.getConfiguration().getGlobalProfiles();
        this.profileCombo.removeAll();
        for (TBAuthProfile profile : this.allProfiles) {
            this.profileCombo.add(profile.getName());
        }
        if (this.allProfiles.size() > 0) {
            this.profileCombo.select(0);
            this.selectedProfile = this.allProfiles.get(0);
            this.loadProfileConnections();
            this.profileCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
                this.selectedProfile = this.allProfiles.get(this.profileCombo.getSelectionIndex());
                this.loadProfileConnections();
            }));
        }
    }

    private void loadProfileConnections() {
        this.conTable.removeAll();
        try {
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    this.fillAssociatedConnections(monitor, this.selectedProfile);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Profile load error", "Error while loading Tableau site information", (Throwable)e);
        }
    }

    private void fillAssociatedConnections(DBRProgressMonitor monitor, TBAuthProfile profile) throws DBException {
        DBPDataSourceContainer ds = this.getDataSource();
        TBSession session = profile.getSession(monitor);
        TBUtils.DataSourceAssociation dsa = new TBUtils.DataSourceAssociation(monitor, session, ds);
        List connectionList = dsa.getConnectionList();
        UIUtils.syncExec(() -> {
            this.conTable.removeAll();
            for (TDSConnection connection : connectionList) {
                if (!connection.getDataSource().getSession().getAuthProfile().equals(profile)) continue;
                this.createConnectionItem(connection);
            }
            UIUtils.packColumns((Table)this.conTable, (boolean)true);
        });
    }

    private void createConnectionItem(TDSConnection connection) {
        TableItem item = new TableItem(this.conTable, 0);
        item.setData((Object)connection);
        item.setText(0, connection.getDataSource().getSite().getName());
        item.setText(1, connection.getDataSource().getName());
        item.setText(2, connection.getCaption());
    }

    private DBPDataSourceContainer getDataSource() {
        return (DBPDataSourceContainer)this.element.getAdapter(DBPDataSourceContainer.class);
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }
}

