/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.pref;

import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.ui.tableau.actions.NavigatorHandlerAssociateDataSource;
import com.dbeaver.ui.tableau.pref.TableauDataSourcePreferencePage;
import com.dbeaver.ui.tableau.pref.TableauObjectEditDialog;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class TableauConnectionEditDialog
extends TableauObjectEditDialog<DBNTableauDataSourceConnectionNode> {
    public TableauConnectionEditDialog(Shell parentShell, DBNTableauDataSourceConnectionNode object) {
        super(parentShell, object);
    }

    @Override
    protected void createObjectDetails(Composite detailsPanel) {
        Composite form = UIUtils.createComposite((Composite)detailsPanel, (int)1);
        UIUtils.createLabelText((Composite)form, (String)"Tableau Connection", (String)((DBNTableauDataSourceConnectionNode)this.getNode()).getNodeDisplayName(), (int)2056);
        Group dsGroup = UIUtils.createControlGroup((Composite)form, (String)"Database connections", (int)1, (int)1808, (int)-1);
        final Table dsTable = new Table((Composite)dsGroup, 2048);
        dsTable.setLayoutData((Object)new GridData(1808));
        Composite buttonsPanel = UIUtils.createComposite((Composite)dsGroup, (int)1);
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Link database connection", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NavigatorHandlerAssociateDataSource.linkConnectionWithDataSource(TableauConnectionEditDialog.this.getShell(), (DBNTableauDataSourceConnectionNode)TableauConnectionEditDialog.this.getNode())) {
                    TableauConnectionEditDialog.this.fillAssociatedDataSources(dsTable);
                }
            }
        });
        Button unlinkButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Unlink connection", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NavigatorHandlerAssociateDataSource.unlinkConnectionFromDataSource((DBNTableauDataSourceConnectionNode)TableauConnectionEditDialog.this.getNode(), (DBPDataSourceContainer)dsTable.getSelection()[0].getData())) {
                    TableauConnectionEditDialog.this.fillAssociatedDataSources(dsTable);
                }
            }
        });
        unlinkButton.setEnabled(false);
        Button openButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Edit connection", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableauConnectionEditDialog.this.openDataSourceEditor((DBPDataSourceContainer)dsTable.getSelection()[0].getData());
            }
        });
        openButton.setEnabled(false);
        this.fillAssociatedDataSources(dsTable);
        dsTable.addMouseListener(MouseListener.mouseDoubleClickAdapter(mouseEvent -> this.openDataSourceEditor((DBPDataSourceContainer)dsTable.getSelection()[0].getData())));
        dsTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            boolean dsSelected = dsTable.getSelectionIndex() >= 0;
            unlinkButton.setEnabled(dsSelected);
            openButton.setEnabled(dsSelected);
        }));
    }

    private void openDataSourceEditor(DBPDataSourceContainer dataSourceContainer) {
        UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
        if (serviceConnections != null) {
            serviceConnections.openConnectionEditor(dataSourceContainer, TableauDataSourcePreferencePage.class.getName());
        }
    }

    private void fillAssociatedDataSources(Table dsTable) {
        dsTable.removeAll();
        DBNTableauDataSourceConnectionNode node = (DBNTableauDataSourceConnectionNode)this.getNode();
        for (DBPDataSourceContainer dataSource : node.getAssociatedDataSources()) {
            TableItem item = new TableItem(dsTable, 0);
            item.setText(dataSource.getName());
            DBNDatabaseNode dsNode = node.getModel().getNodeByObject((DBSObject)dataSource);
            if (dsNode != null) {
                item.setImage(DBeaverIcons.getImage((DBPImage)dsNode.getNodeIcon()));
            }
            item.setData((Object)dataSource);
        }
    }
}

