/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.actions;

import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import com.dbeaver.ui.tableau.actions.NavigatorHandlerAssociateDataSource;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class NavigatorHandlerCreateDataSource
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBNTableauDataSourceConnectionNode selectedConnectionNode = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                DBNNode node = (DBNNode)RuntimeUtils.getObjectAdapter(o, DBNNode.class);
                if (!(node instanceof DBNTableauDataSourceConnectionNode)) continue;
                selectedConnectionNode = (DBNTableauDataSourceConnectionNode)node;
                break;
            }
        }
        if (selectedConnectionNode == null) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        TDSConnection tdsConnection = selectedConnectionNode.getNodeObject();
        DBPDriver connectionDriver = tdsConnection.getConnectionDriver();
        if (connectionDriver == null) {
            UIUtils.showMessageBox((Shell)shell, (String)"Bad driver", (String)("Connection class " + tdsConnection.getConnectionClass() + " is not supported"), (int)1);
            return null;
        }
        Map conProperties = tdsConnection.getProperties();
        String serverName = (String)conProperties.get("server");
        String serverPort = (String)conProperties.get("port");
        String dbName = (String)conProperties.get("dbname");
        String userName = (String)conProperties.get("username");
        String conName = EnterNameDialog.chooseName((Shell)shell, (String)"New connection name", (String)serverName);
        if (conName == null) {
            return null;
        }
        DBPProject project = selectedConnectionNode.getOwnerProject();
        DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
        DBPConnectionConfiguration configuration = new DBPConnectionConfiguration();
        configuration.setHostName(serverName);
        configuration.setHostPort(serverPort);
        configuration.setDatabaseName(dbName);
        configuration.setUserName(userName);
        DataSourceDescriptor dataSource = (DataSourceDescriptor)dataSourceRegistry.createDataSource(DataSourceDescriptor.generateNewId((DBPDriver)connectionDriver), connectionDriver, configuration);
        dataSource.setName(conName);
        dataSource.setSavePassword(false);
        try {
            dataSourceRegistry.addDataSource((DBPDataSourceContainer)dataSource);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error adding connection", "Error adding new datasource", (Throwable)e);
            return null;
        }
        NavigatorHandlerAssociateDataSource.linkConnectionWithDataSource(selectedConnectionNode, (DBPDataSourceContainer)dataSource);
        DBNDatabaseNode dsNode = DBNUtils.getNodeByObject((DBSObject)dataSource);
        if (dsNode != null) {
            NavigatorUtils.showNodeInNavigator((DBNDatabaseNode)dsNode);
        }
        return null;
    }
}

